/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.refraction.common.block;

import com.google.common.collect.Lists;
import com.teamwizardry.librarianlib.common.base.block.BlockMod;
import com.teamwizardry.librarianlib.common.base.block.IBlockColorProvider;
import com.teamwizardry.refraction.api.IOpticConnectable;
import com.teamwizardry.refraction.api.beam.Beam;
import com.teamwizardry.refraction.api.beam.IBeamHandler;
import com.teamwizardry.refraction.api.beam.modes.BeamModeRegistry;
import java.awt.Color;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function4;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import org.jetbrains.annotations.Nullable;

public class BlockFilter
extends BlockMod
implements IBeamHandler,
IOpticConnectable,
IBlockColorProvider {
    public static final PropertyEnum<EnumFilterType> TYPE = PropertyEnum.func_177709_a((String)"color", EnumFilterType.class);
    public static final AxisAlignedBB AABB = new AxisAlignedBB(0.25, 0.25, 0.25, 0.75, 0.75, 0.75);
    private static final String[] VARIANTS = new String[]{"filter_white", "filter_red", "filter_green", "filter_blue", "filter_cyan", "filter_yellow", "filter_magenta", "filter_pink", "filter_orange"};

    public BlockFilter() {
        super("filter", Material.field_151592_s, VARIANTS);
        this.func_149722_s();
        this.func_149711_c(100000.0f);
        this.func_149672_a(SoundType.field_185853_f);
    }

    public int func_180651_a(IBlockState state) {
        return this.func_176201_c(state);
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFilterType)((Object)state.func_177229_b(TYPE))).ordinal();
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(TYPE, (Comparable)((Object)EnumFilterType.values()[meta % EnumFilterType.values().length]));
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{TYPE});
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return AABB;
    }

    @Override
    public void handleBeams(@Nonnull World world, @Nonnull BlockPos pos, Beam ... beams) {
        IBlockState state = world.func_180495_p(pos);
        EnumFilterType type = (EnumFilterType)((Object)state.func_177229_b(TYPE));
        for (Beam beam : beams) {
            beam.createSimilarBeam(beam.finalLoc, beam.slope, new Color(type.red, type.green, type.blue, (float)beam.color.getAlpha() / 255.0f)).setMode(BeamModeRegistry.EFFECT).spawn();
        }
    }

    @Override
    @Nonnull
    public List<EnumFacing> getAvailableFacings(@Nonnull IBlockState state, @Nonnull IBlockAccess source, @Nonnull BlockPos pos, @Nonnull EnumFacing facing) {
        return Lists.newArrayList((Object[])EnumFacing.field_82609_l);
    }

    @Override
    public void handleFiberBeam(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull Beam beam) {
        IBlockState state = world.func_180495_p(pos);
        beam.createSimilarBeam(beam.finalLoc, beam.slope, new Color(((EnumFilterType)((Object)state.func_177229_b(BlockFilter.TYPE))).color)).setMode(BeamModeRegistry.EFFECT).spawn();
    }

    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.TRANSLUCENT;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState blockState) {
        return false;
    }

    @Nullable
    public Function2<ItemStack, Integer, Integer> getItemColorFunction() {
        return (stack, tintIndex) -> EnumFilterType.values()[stack.func_77952_i() % EnumFilterType.values().length].color;
    }

    @Nullable
    public Function4<IBlockState, IBlockAccess, BlockPos, Integer, Integer> getBlockColorFunction() {
        return (state, worldIn, pos, tintIndex) -> ((EnumFilterType)((Object)((Object)state.func_177229_b(BlockFilter.TYPE)))).color;
    }

    public boolean isToolEffective(String type, IBlockState state) {
        return super.isToolEffective(type, state) || Objects.equals(type, "screwdriver");
    }

    public static enum EnumFilterType implements IStringSerializable
    {
        WHITE(0xFFFFFF),
        RED(0xFF0000),
        GREEN(65280),
        BLUE(255),
        CYAN(65535),
        YELLOW(0xFFFF00),
        MAGENTA(0xFF00FF),
        PINK(0xFFAFAF),
        ORANGE(16753920);

        public final int color;
        public final float red;
        public final float green;
        public final float blue;

        private EnumFilterType(int color) {
            this.color = color;
            this.red = (float)((color & 0xFF0000) >> 16) / 255.0f;
            this.green = (float)((color & 0xFF00) >> 8) / 255.0f;
            this.blue = (float)(color & 0xFF) / 255.0f;
        }

        public String func_176610_l() {
            return this.name().toLowerCase();
        }
    }
}

