/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.refraction.common.block;

import com.teamwizardry.librarianlib.client.util.TooltipHelper;
import com.teamwizardry.librarianlib.common.base.block.BlockModContainer;
import com.teamwizardry.refraction.api.PosUtils;
import com.teamwizardry.refraction.api.beam.Beam;
import com.teamwizardry.refraction.api.beam.IBeamHandler;
import com.teamwizardry.refraction.api.beam.modes.BeamModeRegistry;
import com.teamwizardry.refraction.api.beam.modes.ModeEffect;
import com.teamwizardry.refraction.common.block.BlockLightBridge;
import com.teamwizardry.refraction.common.effect.EffectAttract;
import com.teamwizardry.refraction.common.effect.EffectDisperse;
import com.teamwizardry.refraction.common.tile.TileElectronExciter;
import com.teamwizardry.refraction.init.ModBlocks;
import java.awt.Color;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BlockElectronExciter
extends BlockModContainer
implements IBeamHandler {
    public static final PropertyDirection FACING = PropertyDirection.func_177714_a((String)"facing");
    private static final PropertyBool UP = PropertyBool.func_177716_a((String)"up");
    private static final PropertyBool DOWN = PropertyBool.func_177716_a((String)"down");
    private static final PropertyBool LEFT = PropertyBool.func_177716_a((String)"left");
    private static final PropertyBool RIGHT = PropertyBool.func_177716_a((String)"right");

    public BlockElectronExciter() {
        super("electron_exciter", Material.field_151573_f, new String[0]);
        this.func_149711_c(1.0f);
        this.func_149672_a(SoundType.field_185852_e);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH));
    }

    public void addInformation(ItemStack stack, EntityPlayer player, List<String> tooltip, boolean advanced) {
        TooltipHelper.addToTooltip(tooltip, (String)("simple_name.refraction:" + this.getRegistryName().func_110623_a()), (Object[])new Object[0]);
    }

    private TileElectronExciter getTE(World world, BlockPos pos) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileElectronExciter) {
            return (TileElectronExciter)tile;
        }
        return null;
    }

    @NotNull
    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        if (placer.field_70125_A > 45.0f) {
            return this.func_176203_a(meta).func_177226_a((IProperty)FACING, (Comparable)EnumFacing.UP);
        }
        if (placer.field_70125_A < -45.0f) {
            return this.func_176203_a(meta).func_177226_a((IProperty)FACING, (Comparable)EnumFacing.DOWN);
        }
        return this.func_176203_a(meta).func_177226_a((IProperty)FACING, (Comparable)placer.func_184172_bi().func_176734_d());
    }

    @Override
    public boolean handleBeam(@NotNull World world, @NotNull BlockPos pos, @NotNull Beam beam) {
        TileElectronExciter exciter;
        if (beam.mode instanceof ModeEffect && beam.effect != null) {
            EnumFacing block;
            if (beam.effect instanceof EffectAttract) {
                if (beam.color.getAlpha() > 128) {
                    block = (EnumFacing)world.func_180495_p(pos).func_177229_b((IProperty)FACING);
                    Vec3d vec3d = new Vec3d(block.func_176734_d().func_176730_m());
                    if (beam.slope.func_72432_b().func_72430_b(vec3d) > 0.999) {
                        TileElectronExciter exciter2 = this.getTE(world, pos);
                        if (exciter2 != null) {
                            exciter2.expire = 20;
                            exciter2.hasCardinalBeam = true;
                        }
                        boolean pass = false;
                        for (EnumFacing facing : EnumFacing.field_82609_l) {
                            TileElectronExciter neighbor;
                            if (facing == block && facing == block.func_176734_d() || (neighbor = this.getTE(world, pos.func_177972_a(facing))) == null || !neighbor.hasCardinalBeam || world.func_180495_p(pos.func_177972_a(facing)).func_177229_b((IProperty)FACING) != block) continue;
                            pass = true;
                            break;
                        }
                        if (pass && world.func_175623_d(pos.func_177972_a(block))) {
                            world.func_180501_a(pos.func_177972_a(block), ModBlocks.LIGHT_BRIDGE.func_176223_P().func_177226_a(BlockLightBridge.FACING, (Comparable)block.func_176740_k()), 3);
                        }
                        return true;
                    }
                }
            } else if (beam.effect instanceof EffectDisperse) {
                block = (EnumFacing)world.func_180495_p(pos).func_177229_b((IProperty)FACING);
                Vec3d vec3d = new Vec3d(block.func_176734_d().func_176730_m());
                if (beam.slope.func_72432_b().func_72430_b(vec3d) > 0.999) {
                    HashSet<EnumFacing> exciters = new HashSet<EnumFacing>();
                    for (EnumFacing facing : EnumFacing.field_82609_l) {
                        TileElectronExciter neighbor;
                        if (facing == block && facing == block.func_176734_d() || (neighbor = this.getTE(world, pos.func_177972_a(facing))) == null || world.func_180495_p(pos.func_177972_a(facing)).func_177229_b((IProperty)FACING) != block) continue;
                        exciters.add(facing);
                    }
                    if (!exciters.isEmpty()) {
                        Color color = new Color(0, 150, 255, beam.color.getAlpha() / exciters.size());
                        for (EnumFacing facing : exciters) {
                            beam.createSimilarBeam(PosUtils.getSideCenter(pos.func_177972_a(facing), block), PosUtils.getVecFromFacing(block), color).setMode(BeamModeRegistry.GRAVITY).spawn();
                        }
                    }
                    return true;
                }
            }
        }
        if ((exciter = this.getTE(world, pos)) != null) {
            exciter.expire = 20;
            exciter.hasCardinalBeam = true;
        }
        return true;
    }

    @NotNull
    public IBlockState func_176221_a(@NotNull IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        boolean right;
        boolean left;
        boolean down;
        boolean up;
        EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)FACING);
        switch (facing) {
            case DOWN: {
                up = this.checkState(worldIn, pos.func_177972_a(EnumFacing.NORTH), facing);
                down = this.checkState(worldIn, pos.func_177972_a(EnumFacing.SOUTH), facing);
                left = this.checkState(worldIn, pos.func_177972_a(EnumFacing.WEST), facing);
                right = this.checkState(worldIn, pos.func_177972_a(EnumFacing.EAST), facing);
                break;
            }
            case UP: {
                up = this.checkState(worldIn, pos.func_177972_a(EnumFacing.SOUTH), facing);
                down = this.checkState(worldIn, pos.func_177972_a(EnumFacing.NORTH), facing);
                left = this.checkState(worldIn, pos.func_177972_a(EnumFacing.EAST), facing);
                right = this.checkState(worldIn, pos.func_177972_a(EnumFacing.WEST), facing);
                break;
            }
            case NORTH: {
                up = this.checkState(worldIn, pos.func_177972_a(EnumFacing.UP), facing);
                down = this.checkState(worldIn, pos.func_177972_a(EnumFacing.DOWN), facing);
                left = this.checkState(worldIn, pos.func_177972_a(EnumFacing.EAST), facing);
                right = this.checkState(worldIn, pos.func_177972_a(EnumFacing.WEST), facing);
                break;
            }
            case SOUTH: {
                up = this.checkState(worldIn, pos.func_177972_a(EnumFacing.UP), facing);
                down = this.checkState(worldIn, pos.func_177972_a(EnumFacing.DOWN), facing);
                left = this.checkState(worldIn, pos.func_177972_a(EnumFacing.WEST), facing);
                right = this.checkState(worldIn, pos.func_177972_a(EnumFacing.EAST), facing);
                break;
            }
            case WEST: {
                up = this.checkState(worldIn, pos.func_177972_a(EnumFacing.UP), facing);
                down = this.checkState(worldIn, pos.func_177972_a(EnumFacing.DOWN), facing);
                left = this.checkState(worldIn, pos.func_177972_a(EnumFacing.NORTH), facing);
                right = this.checkState(worldIn, pos.func_177972_a(EnumFacing.SOUTH), facing);
                break;
            }
            case EAST: {
                up = this.checkState(worldIn, pos.func_177972_a(EnumFacing.UP), facing);
                down = this.checkState(worldIn, pos.func_177972_a(EnumFacing.DOWN), facing);
                left = this.checkState(worldIn, pos.func_177972_a(EnumFacing.SOUTH), facing);
                right = this.checkState(worldIn, pos.func_177972_a(EnumFacing.NORTH), facing);
                break;
            }
            default: {
                up = false;
                down = false;
                left = false;
                right = false;
            }
        }
        return state.func_177226_a((IProperty)UP, (Comparable)Boolean.valueOf(up)).func_177226_a((IProperty)DOWN, (Comparable)Boolean.valueOf(down)).func_177226_a((IProperty)LEFT, (Comparable)Boolean.valueOf(left)).func_177226_a((IProperty)RIGHT, (Comparable)Boolean.valueOf(right));
    }

    private boolean checkState(IBlockAccess world, BlockPos pos, EnumFacing facing) {
        IBlockState state = world.func_180495_p(pos);
        return state.func_177230_c() == this && state.func_177229_b((IProperty)FACING) == facing;
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.func_82600_a((int)(meta & 7)));
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176745_a();
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING, UP, LEFT, RIGHT, DOWN});
    }

    public boolean isToolEffective(String type, IBlockState state) {
        return super.isToolEffective(type, state) || Objects.equals(type, "screwdriver");
    }

    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        super.func_180663_b(worldIn, pos, state);
    }

    public boolean canRenderInLayer(BlockRenderLayer layer) {
        return layer == BlockRenderLayer.CUTOUT;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState blockState) {
        return false;
    }

    @Nullable
    public TileEntity createTileEntity(World world, IBlockState iBlockState) {
        return new TileElectronExciter();
    }
}

