/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.refraction.common.block;

import com.teamwizardry.librarianlib.client.util.TooltipHelper;
import com.teamwizardry.librarianlib.common.base.block.BlockModContainer;
import com.teamwizardry.refraction.api.CapsUtils;
import com.teamwizardry.refraction.api.beam.Beam;
import com.teamwizardry.refraction.api.beam.IBeamHandler;
import com.teamwizardry.refraction.client.render.RenderAssemblyTable;
import com.teamwizardry.refraction.common.tile.TileAssemblyTable;
import java.util.List;
import java.util.Objects;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BlockAssemblyTable
extends BlockModContainer
implements IBeamHandler {
    public BlockAssemblyTable() {
        super("assembly_table", Material.field_151573_f, new String[0]);
        this.func_149711_c(1.0f);
        this.func_149672_a(SoundType.field_185852_e);
    }

    private TileAssemblyTable getTE(World world, BlockPos pos) {
        return (TileAssemblyTable)world.func_175625_s(pos);
    }

    @SideOnly(value=Side.CLIENT)
    public void initModel() {
        ClientRegistry.bindTileEntitySpecialRenderer(TileAssemblyTable.class, (TileEntitySpecialRenderer)new RenderAssemblyTable());
    }

    public void addInformation(ItemStack stack, EntityPlayer player, List<String> tooltip, boolean advanced) {
        TooltipHelper.addToTooltip(tooltip, (String)("simple_name.refraction:" + this.getRegistryName().func_110623_a()), (Object[])new Object[0]);
    }

    @Override
    public boolean handleBeam(@NotNull World world, @NotNull BlockPos pos, @NotNull Beam beam) {
        this.getTE(world, pos).handleBeam(beam);
        return true;
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (!worldIn.field_72995_K) {
            TileAssemblyTable table = this.getTE(worldIn, pos);
            if (table.behavior != null) {
                boolean allowedToEdit = table.behavior.canEditItems((IItemHandlerModifiable)table.inventory, (IItemHandlerModifiable)table.output, table.craftingTime);
                if (allowedToEdit) {
                    table.behavior = null;
                } else {
                    return true;
                }
            }
            if (table.output.getStackInSlot(0) != null) {
                ItemHandlerHelper.giveItemToPlayer((EntityPlayer)playerIn, (ItemStack)table.output.extractItem(0, 64, false));
                playerIn.field_71070_bA.func_75142_b();
            } else if (heldItem != null && heldItem.field_77994_a > 0) {
                ItemStack stack = heldItem.func_77946_l();
                stack.field_77994_a = 1;
                ItemStack insert = ItemHandlerHelper.insertItem((IItemHandler)table.inventory, (ItemStack)stack, (boolean)false);
                if (insert == null || insert.field_77994_a == 0) {
                    --heldItem.field_77994_a;
                }
                playerIn.field_71070_bA.func_75142_b();
            } else if (CapsUtils.getOccupiedSlotCount((IItemHandler)table.inventory) > 0) {
                ItemHandlerHelper.giveItemToPlayer((EntityPlayer)playerIn, (ItemStack)table.inventory.extractItem(CapsUtils.getLastOccupiedSlot((IItemHandler)table.inventory), 1, false));
                playerIn.field_71070_bA.func_75142_b();
            }
            table.func_70296_d();
        }
        return true;
    }

    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        TileAssemblyTable table = (TileAssemblyTable)worldIn.func_175625_s(pos);
        if (table != null) {
            for (ItemStack stack : CapsUtils.getListOfItems((IItemHandler)table.inventory)) {
                InventoryHelper.func_180173_a((World)worldIn, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (ItemStack)stack);
            }
        }
        super.func_180663_b(worldIn, pos, state);
    }

    public boolean canRenderInLayer(BlockRenderLayer layer) {
        return layer == BlockRenderLayer.CUTOUT;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState blockState) {
        return false;
    }

    @Nullable
    public TileEntity createTileEntity(World world, IBlockState iBlockState) {
        return new TileAssemblyTable();
    }

    public boolean isToolEffective(String type, IBlockState state) {
        return super.isToolEffective(type, state) || Objects.equals(type, "screwdriver");
    }
}

