/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.refraction.common.block;

import com.google.common.collect.Lists;
import com.teamwizardry.librarianlib.client.util.TooltipHelper;
import com.teamwizardry.librarianlib.common.base.block.BlockMod;
import com.teamwizardry.librarianlib.common.base.block.ItemModBlock;
import com.teamwizardry.librarianlib.common.network.PacketHandler;
import com.teamwizardry.librarianlib.common.util.DimWithPos;
import com.teamwizardry.librarianlib.common.util.EnumBiFacing;
import com.teamwizardry.refraction.api.IOpticConnectable;
import com.teamwizardry.refraction.api.beam.Beam;
import com.teamwizardry.refraction.api.beam.IBeamHandler;
import com.teamwizardry.refraction.common.block.BlockOpticFiber;
import com.teamwizardry.refraction.common.network.PacketAXYZMarks;
import com.teamwizardry.refraction.init.ModBlocks;
import gnu.trove.map.hash.TObjectIntHashMap;
import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.Set;
import javax.annotation.Nonnull;
import kotlin.Pair;
import net.minecraft.block.Block;
import net.minecraft.block.BlockPistonMoving;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldSavedData;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BlockAXYZ
extends BlockMod
implements IBeamHandler,
IOpticConnectable {
    public static final PropertyBool[] PROPS = new PropertyBool[]{PropertyBool.func_177716_a((String)"down"), PropertyBool.func_177716_a((String)"up"), PropertyBool.func_177716_a((String)"north"), PropertyBool.func_177716_a((String)"south"), PropertyBool.func_177716_a((String)"west"), PropertyBool.func_177716_a((String)"east")};
    public final Map<DimWithPos, DimWithPos> mappedPositions = new HashMap<DimWithPos, DimWithPos>();
    private final Set<DimWithPos> removeQueue = new HashSet<DimWithPos>();
    private final Set<DimWithPos> checkedCoords = new HashSet<DimWithPos>();
    private final TObjectIntHashMap<DimWithPos> coordsToCheck = new TObjectIntHashMap(10, 0.5f, -1);
    private final AxisAlignedBB AABB = new AxisAlignedBB(0.1875, 0.1875, 0.1875, 0.8125, 0.8125, 0.8125);
    private boolean harvesting = false;

    public BlockAXYZ() {
        super("axyz", Material.field_151572_C, new String[0]);
        this.func_149711_c(2.0f);
        this.func_149752_b(10.0f);
        this.func_149672_a(SoundType.field_185852_e);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        for (int i = 0; i < PROPS.length; ++i) {
            EnumFacing facing = EnumFacing.field_82609_l[i];
            IBlockState fiber = worldIn.func_180495_p(pos.func_177972_a(facing));
            state = state.func_177226_a((IProperty)PROPS[i], (Comparable)Boolean.valueOf(fiber.func_177230_c() instanceof BlockOpticFiber && ((EnumBiFacing)fiber.func_177229_b(BlockOpticFiber.FACING)).contains(facing.func_176734_d())));
        }
        return state;
    }

    public int func_176201_c(IBlockState state) {
        return 0;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, (IProperty[])PROPS);
    }

    public void addInformation(ItemStack stack, EntityPlayer player, List<String> tooltip, boolean advanced) {
        TooltipHelper.addToTooltip(tooltip, (String)("simple_name.refraction:" + this.getRegistryName().func_110623_a()), (Object[])new Object[0]);
    }

    public void func_176208_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer player) {
        if (player.func_184812_l_()) {
            return;
        }
        this.harvesting = true;
        this.func_176226_b(worldIn, pos, state, 0);
        this.harvesting = false;
    }

    public int quantityDropped(IBlockState state, int fortune, @Nonnull Random random) {
        return this.harvesting ? 1 : 0;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149730_j(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_185481_k(IBlockState state) {
        return false;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return this.AABB;
    }

    public void func_180663_b(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull IBlockState state) {
        if (!world.field_72995_K) {
            this.mapCoords(world.field_73011_w.getDimension(), pos, 2);
        }
    }

    private void mapCoords(int world, BlockPos pos, int time) {
        this.coordsToCheck.put((Object)new DimWithPos(world, pos), time);
    }

    private void decrCoords(DimWithPos key) {
        int time = this.getTimeInCoords(key);
        if (time <= 0) {
            this.removeQueue.add(key);
        } else {
            this.coordsToCheck.adjustValue((Object)key, -1);
        }
    }

    private int getTimeInCoords(DimWithPos key) {
        return this.coordsToCheck.get((Object)key);
    }

    private Block getBlockAt(DimWithPos key) {
        return this.getStateAt(key).func_177230_c();
    }

    private IBlockState getStateAt(DimWithPos key) {
        MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
        if (server == null) {
            return Blocks.field_150350_a.func_176223_P();
        }
        return server.func_71218_a(key.getDim()).func_180495_p(key.getPos());
    }

    @SubscribeEvent
    public void onWorldLoad(WorldEvent.Load event) {
        if (!event.getWorld().field_72995_K) {
            WorldData.get(event.getWorld());
        }
    }

    @SubscribeEvent
    public void onWorldUnload(WorldEvent.Unload event) {
        if (!event.getWorld().field_72995_K) {
            WorldData.get(event.getWorld()).func_76185_a();
        }
    }

    @SubscribeEvent
    public void tickEnd(TickEvent event) {
        if (event.type == TickEvent.Type.SERVER && event.phase == TickEvent.Phase.END) {
            for (DimWithPos s : this.coordsToCheck.keySet()) {
                this.decrCoords(s);
                if (this.checkedCoords.contains(s)) continue;
                Block block = this.getBlockAt(s);
                if (block == Blocks.field_180384_M) {
                    IBlockState state = this.getStateAt(s);
                    EnumFacing dir = (EnumFacing)state.func_177229_b((IProperty)BlockPistonMoving.field_176426_a);
                    MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
                    if (server == null || this.getTimeInCoords(s) != 0) continue;
                    int worldId = s.getDim();
                    int x = s.getPos().func_177958_n();
                    int y = s.getPos().func_177956_o();
                    int z = s.getPos().func_177952_p();
                    BlockPos pos = s.getPos();
                    WorldServer world = server.func_71218_a(worldId);
                    if (world.func_175623_d(pos.func_177972_a(dir))) {
                        world.func_175656_a(pos.func_177972_a(dir), ModBlocks.AXYZ.func_176223_P());
                    } else if (!world.field_72995_K) {
                        ItemStack stack = new ItemStack((Block)ModBlocks.AXYZ);
                        world.func_72838_d((Entity)new EntityItem((World)world, (double)(x + dir.func_82601_c()), (double)(y + dir.func_96559_d()), (double)(z + dir.func_82599_e()), stack));
                    }
                    this.checkedCoords.add(s);
                    DimWithPos newPos = new DimWithPos(world.field_73011_w.getDimension(), pos.func_177972_a(dir));
                    if (!this.mappedPositions.containsKey(s)) continue;
                    DimWithPos dPos = this.mappedPositions.get(s);
                    worldId = dPos.getDim();
                    BlockPos pos2 = dPos.getPos();
                    world = server.func_71218_a(worldId);
                    this.mappedPositions.remove(s);
                    this.mappedPositions.put(newPos, new DimWithPos(world.field_73011_w.getDimension(), pos2.func_177972_a(dir)));
                    this.save((World)world);
                    continue;
                }
                this.removeQueue.add(s);
            }
            for (DimWithPos s : this.removeQueue) {
                this.coordsToCheck.remove((Object)s);
                this.checkedCoords.remove(s);
                this.mappedPositions.remove(s);
            }
            this.removeQueue.clear();
            HashMap<Integer, ArrayList> map = new HashMap<Integer, ArrayList>();
            for (Map.Entry<DimWithPos, DimWithPos> s : this.mappedPositions.entrySet()) {
                int dim = s.getKey().getDim();
                if (!map.containsKey(dim)) {
                    map.put(dim, Lists.newArrayList());
                }
                ((List)map.get(dim)).add(new Pair((Object)s.getValue().getPos(), (Object)s.getKey().getPos()));
            }
            for (Integer dim : map.keySet()) {
                List l = (List)map.get(dim);
                BlockPos[] arr1 = new BlockPos[l.size()];
                BlockPos[] arr2 = new BlockPos[l.size()];
                for (int i = 0; i < arr1.length; ++i) {
                    arr1[i] = (BlockPos)((Pair)l.get(i)).getFirst();
                    arr2[i] = (BlockPos)((Pair)l.get(i)).getSecond();
                }
                PacketHandler.NETWORK.sendToAll((IMessage)new PacketAXYZMarks(arr1, arr2, dim));
            }
        }
    }

    public void save(World world) {
        WorldData data = WorldData.get(world);
        if (data != null) {
            data.func_76185_a();
        }
    }

    @Override
    public void handleBeams(@Nonnull World world, @Nonnull BlockPos pos, Beam ... beams) {
        for (Beam beam : beams) {
            this.handleFiberBeam(world, pos, beam);
        }
    }

    @Override
    @Nonnull
    public List<EnumFacing> getAvailableFacings(@Nonnull IBlockState state, @Nonnull IBlockAccess source, @Nonnull BlockPos pos, @Nonnull EnumFacing facing) {
        return Lists.newArrayList((Object[])EnumFacing.field_82609_l);
    }

    @Override
    public void handleFiberBeam(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull Beam beam) {
        int dim = world.field_73011_w.getDimension();
        Color c = new Color(beam.color.getRed(), beam.color.getGreen(), beam.color.getBlue(), (int)((double)beam.color.getAlpha() / 1.05));
        DimWithPos key = new DimWithPos(dim, pos);
        if (this.mappedPositions.containsKey(key)) {
            BlockPos mapPos = this.mappedPositions.get(key).getPos();
            beam.createSimilarBeam(new Vec3d((Vec3i)mapPos).func_72441_c(0.5, 0.5, 0.5), beam.slope).setColor(c).spawn();
        }
    }

    @Nullable
    public ItemBlock createItemForm() {
        return new ItemModBlock((Block)this){
            private int RAND_NAMES;
            private Random rand;
            private long prevTime;
            private int curRand;
            {
                this.RAND_NAMES = 0;
                this.rand = new Random();
                this.prevTime = 0x80000000L;
                this.curRand = -1;
            }

            @NotNull
            public String func_77667_c(ItemStack par1ItemStack) {
                if (par1ItemStack.func_77952_i() == 0 && FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT) {
                    StackTraceElement[] stackTrace;
                    if (this.RAND_NAMES == 0) {
                        this.RAND_NAMES = 0;
                        while (I18n.func_188566_a((String)(super.func_77667_c(par1ItemStack) + "." + (this.RAND_NAMES + 1) + ".name"))) {
                            ++this.RAND_NAMES;
                        }
                    }
                    if ("net.minecraft.item.Item".equals((stackTrace = new Throwable().getStackTrace())[1].getClassName())) {
                        long curTime = System.currentTimeMillis();
                        if (curTime - this.prevTime > 1000L || this.curRand == -1) {
                            this.curRand = this.rand.nextInt(this.RAND_NAMES);
                        }
                        this.prevTime = curTime;
                        return super.func_77667_c(par1ItemStack) + "." + this.curRand;
                    }
                }
                return super.func_77667_c(par1ItemStack);
            }
        };
    }

    public boolean isToolEffective(String type, @NotNull IBlockState state) {
        return Objects.equals(type, "pickaxe") || Objects.equals(type, "screwdriver");
    }

    @Nullable
    public String getHarvestTool(@NotNull IBlockState state) {
        return "pickaxe";
    }

    public static class WorldData
    extends WorldSavedData {
        private static final String ID = "refraction-LaserRelayPairs";

        public WorldData(String id) {
            super(id);
        }

        public static WorldData get(World world) {
            if (world.func_175693_T() == null) {
                return null;
            }
            WorldData data = (WorldData)world.func_175693_T().func_75742_a(WorldData.class, ID);
            if (data == null) {
                data = new WorldData(ID);
                data.func_76185_a();
                world.func_175693_T().func_75745_a(ID, (WorldSavedData)data);
            }
            return data;
        }

        public void func_76184_a(@Nonnull NBTTagCompound nbttagcompound) {
            ModBlocks.AXYZ.mappedPositions.clear();
            Set tags = nbttagcompound.func_150296_c();
            for (String key : tags) {
                NBTBase tag = nbttagcompound.func_74781_a(key);
                if (!(tag instanceof NBTTagString)) continue;
                String value = ((NBTTagString)tag).func_150285_a_();
                DimWithPos dimWithPos = DimWithPos.fromString((String)key);
                WorldServer world = FMLCommonHandler.instance().getMinecraftServerInstance().func_71218_a(dimWithPos.getDim());
                if (world.func_180495_p(dimWithPos.getPos()).func_177230_c() != ModBlocks.AXYZ) continue;
                ModBlocks.AXYZ.mappedPositions.put(DimWithPos.fromString((String)key), DimWithPos.fromString((String)value));
            }
        }

        @Nonnull
        public NBTTagCompound func_189551_b(@Nonnull NBTTagCompound nbttagcompound) {
            for (DimWithPos s : ModBlocks.AXYZ.mappedPositions.keySet()) {
                nbttagcompound.func_74778_a(s.toString(), ModBlocks.AXYZ.mappedPositions.get(s).toString());
            }
            return nbttagcompound;
        }
    }
}

