/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.refraction.client.render;

import com.teamwizardry.librarianlib.client.core.ClientTickHandler;
import com.teamwizardry.librarianlib.client.sprite.Sprite;
import com.teamwizardry.librarianlib.client.sprite.Texture;
import com.teamwizardry.refraction.common.block.BlockSpectrometer;
import com.teamwizardry.refraction.common.tile.TileSpectrometer;
import com.teamwizardry.refraction.init.ModBlocks;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;

public class RenderSpectrometer
extends TileEntitySpecialRenderer<TileSpectrometer> {
    private static ResourceLocation loc = new ResourceLocation("refraction", "textures/bar.png");
    private static Texture texture = new Texture(loc);
    private static Sprite BAR_SPRITE = texture.getSprite("bar", 1, 1);

    public void renderTileEntityAt(TileSpectrometer te, double x, double y, double z, float partialTicks, int destroyStage) {
        IBlockState state = te.func_145831_w().func_180495_p(te.func_174877_v());
        if (state.func_177230_c() != ModBlocks.SPECTROMETER) {
            return;
        }
        EnumFacing value = (EnumFacing)te.func_145831_w().func_180495_p(te.func_174877_v()).func_177229_b(BlockSpectrometer.FACING);
        double r = (double)te.currentColor.getRed() / 255.0;
        double g = (double)te.currentColor.getGreen() / 255.0;
        double b = (double)te.currentColor.getBlue() / 255.0;
        double a = (double)te.currentColor.getAlpha() / 255.0;
        GlStateManager.func_179094_E();
        GlStateManager.func_179147_l();
        GlStateManager.func_179129_p();
        GlStateManager.func_179140_f();
        GlStateManager.func_179098_w();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179137_b((double)x, (double)y, (double)(z + 0.5));
        if (value == EnumFacing.SOUTH) {
            GlStateManager.func_179137_b((double)0.0, (double)0.0, (double)0.501);
        } else if (value == EnumFacing.NORTH) {
            GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179137_b((double)-1.0, (double)0.0, (double)0.501);
        } else if (value == EnumFacing.EAST) {
            GlStateManager.func_179114_b((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179137_b((double)-0.5, (double)0.0, (double)1.01);
        } else {
            GlStateManager.func_179114_b((float)270.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179137_b((double)-0.5, (double)0.0, (double)0.01);
        }
        GlStateManager.func_179139_a((double)0.375, (double)0.375, (double)0.0);
        GlStateManager.func_179137_b((double)0.328125, (double)0.15625, (double)0.0);
        texture.bind();
        GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179137_b((double)0.0, (double)1.35, (double)0.0);
        this.drawClipped(BAR_SPRITE, ClientTickHandler.getTicks(), 0.0f, 0.0f, 1.0, a);
        GlStateManager.func_179137_b((double)0.0, (double)-1.35, (double)0.0);
        GlStateManager.func_179124_c((float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179137_b((double)1.0, (double)1.35, (double)0.0);
        this.drawClipped(BAR_SPRITE, ClientTickHandler.getTicks(), 0.0f, 0.0f, 1.0, r);
        GlStateManager.func_179137_b((double)-1.0, (double)-1.35, (double)0.0);
        GlStateManager.func_179124_c((float)0.0f, (float)1.0f, (float)0.0f);
        this.drawClipped(BAR_SPRITE, ClientTickHandler.getTicks(), 0.0f, 0.0f, 1.0, g);
        GlStateManager.func_179124_c((float)0.0f, (float)0.0f, (float)1.0f);
        GlStateManager.func_179109_b((float)1.0f, (float)0.0f, (float)0.0f);
        this.drawClipped(BAR_SPRITE, ClientTickHandler.getTicks(), 0.0f, 0.0f, 1.0, b);
        GlStateManager.func_179109_b((float)-1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179145_e();
        GlStateManager.func_179089_o();
        GlStateManager.func_179084_k();
        GlStateManager.func_179121_F();
    }

    private void drawClipped(Sprite sprite, int animTicks, float x, float y, double width, double height) {
        Tessellator tessellator = Tessellator.func_178181_a();
        VertexBuffer vb = tessellator.func_178180_c();
        vb.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        int wholeSpritesX = (int)Math.ceil(width / (double)sprite.getWidth()) - 1;
        int wholeSpritesY = (int)Math.ceil(height / (double)sprite.getHeight()) - 1;
        double leftoverWidth = width % (double)sprite.getWidth();
        double leftoverHeight = height % (double)sprite.getHeight();
        if (leftoverWidth <= 0.0) {
            leftoverWidth = sprite.getWidth();
        }
        if (leftoverHeight <= 0.0) {
            leftoverHeight = sprite.getHeight();
        }
        for (int xIndex = 0; xIndex <= wholeSpritesX; ++xIndex) {
            for (int yIndex = 0; yIndex <= wholeSpritesY; ++yIndex) {
                double spriteWidth;
                boolean smallY;
                boolean smallX = xIndex == wholeSpritesX;
                boolean bl = smallY = yIndex == wholeSpritesY;
                double d = smallX ? (wholeSpritesX == 0 ? width : leftoverWidth) : (spriteWidth = (double)sprite.getWidth());
                double spriteHeight = smallY ? (wholeSpritesY == 0 ? height : leftoverHeight) : (double)sprite.getHeight();
                double offsetX = sprite.getWidth() * xIndex;
                double offsetY = sprite.getHeight() * yIndex;
                double minX = (double)x + offsetX;
                double minY = (double)y + offsetY;
                double maxX = minX + spriteWidth;
                double maxY = minY + spriteHeight;
                double uSpan = sprite.maxU(animTicks) - sprite.minU(animTicks);
                double vSpan = sprite.maxV(animTicks) - sprite.minV(animTicks);
                double minU = sprite.minU(animTicks);
                double minV = sprite.minV(animTicks);
                double maxU = minU + uSpan * (spriteWidth / (double)sprite.getWidth());
                double maxV = minV + vSpan * (spriteHeight / (double)sprite.getHeight());
                vb.func_181662_b(minX, maxY, 0.0).func_187315_a(minU, maxV).func_181675_d();
                vb.func_181662_b(maxX, maxY, 0.0).func_187315_a(maxU, maxV).func_181675_d();
                vb.func_181662_b(maxX, minY, 0.0).func_187315_a(maxU, minV).func_181675_d();
                vb.func_181662_b(minX, minY, 0.0).func_187315_a(minU, minV).func_181675_d();
            }
        }
        tessellator.func_78381_a();
    }
}

