/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.refraction.client.render;

import com.teamwizardry.refraction.api.ConfigValues;
import com.teamwizardry.refraction.client.core.RenderLaserUtil;
import java.awt.Color;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public class LaserRenderer {
    public static final LaserRenderer INSTANCE = new LaserRenderer();
    protected Map<LaserRenderInfo, Integer> lasers = new ConcurrentHashMap<LaserRenderInfo, Integer>();

    private LaserRenderer() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public static void add(Vec3d start, Vec3d end, Color color) {
        LaserRenderer.INSTANCE.lasers.put(new LaserRenderInfo(start, end, color), ConfigValues.BEAM_PARTICLE_LIFE);
    }

    @SubscribeEvent
    public void unload(WorldEvent.Unload event) {
        this.lasers.clear();
    }

    @SubscribeEvent
    public void load(WorldEvent.Load event) {
        this.lasers.clear();
    }

    @SubscribeEvent
    public void renderWorldLast(RenderWorldLastEvent event) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179123_a();
        EntityPlayerSP rootPlayer = Minecraft.func_71410_x().field_71439_g;
        double x = rootPlayer.field_70142_S + (rootPlayer.field_70165_t - rootPlayer.field_70142_S) * (double)event.getPartialTicks();
        double y = rootPlayer.field_70137_T + (rootPlayer.field_70163_u - rootPlayer.field_70137_T) * (double)event.getPartialTicks();
        double z = rootPlayer.field_70136_U + (rootPlayer.field_70161_v - rootPlayer.field_70136_U) * (double)event.getPartialTicks();
        GlStateManager.func_179137_b((double)(-x), (double)(-y), (double)(-z));
        GlStateManager.func_179147_l();
        GlStateManager.func_179092_a((int)518, (float)0.003921569f);
        RenderLaserUtil.startRenderingLasers();
        for (LaserRenderInfo info : this.lasers.keySet()) {
            RenderLaserUtil.renderLaser(info.color, info.start, info.end);
        }
        RenderLaserUtil.finishRenderingLasers();
        GlStateManager.func_179084_k();
        GlStateManager.func_179121_F();
        GlStateManager.func_179099_b();
    }

    @SubscribeEvent
    public void tick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            // empty if block
        }
    }

    public void update() {
        this.lasers.entrySet().removeIf(e -> {
            if ((Integer)e.getValue() <= 0) {
                return true;
            }
            e.setValue((Integer)e.getValue() - 1);
            return false;
        });
    }

    public static class LaserRenderInfo {
        public Vec3d start;
        public Vec3d end;
        public Color color;

        public LaserRenderInfo(Vec3d start, Vec3d end, Color color) {
            this.start = start;
            this.end = end;
            this.color = color == null ? Color.WHITE : color;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            LaserRenderInfo that = (LaserRenderInfo)o;
            if (!this.start.equals((Object)that.start)) {
                return false;
            }
            if (!this.end.equals((Object)that.end)) {
                return false;
            }
            return this.color.equals(that.color);
        }

        public int hashCode() {
            int result = this.start.hashCode();
            result = 31 * result + this.end.hashCode();
            result = 31 * result + this.color.hashCode();
            return result;
        }
    }
}

