/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.refraction.client.jei;

import com.teamwizardry.refraction.api.recipe.AssemblyBehaviors;
import com.teamwizardry.refraction.client.jei.AssemblyTableRecipeCategory;
import com.teamwizardry.refraction.client.jei.AssemblyTableRecipeHandler;
import com.teamwizardry.refraction.init.ModBlocks;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import mezz.jei.api.BlankModPlugin;
import mezz.jei.api.IJeiHelpers;
import mezz.jei.api.IJeiRuntime;
import mezz.jei.api.IModRegistry;
import mezz.jei.api.IRecipeRegistry;
import mezz.jei.api.JEIPlugin;
import mezz.jei.api.gui.IRecipeLayoutDrawable;
import mezz.jei.api.recipe.IFocus;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.api.recipe.IRecipeHandler;
import mezz.jei.api.recipe.IRecipeWrapper;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;

@JEIPlugin
public class JEIRefractionPlugin
extends BlankModPlugin {
    public static IJeiRuntime jeiRuntime;

    public static IRecipeLayoutDrawable getDrawableFromItem(ItemStack stack) {
        if (stack != null) {
            IRecipeRegistry registry = jeiRuntime.getRecipeRegistry();
            IFocus focus = registry.createFocus(IFocus.Mode.OUTPUT, (Object)stack);
            for (IRecipeCategory category : registry.getRecipeCategories(focus)) {
                List<IRecipeLayoutDrawable> layouts;
                if (!category.getUid().equals("refraction.assembly_table") && !category.getUid().equals("minecraft.crafting") || (layouts = JEIRefractionPlugin.getLayouts(registry, category, (IFocus<ItemStack>)focus)).isEmpty()) continue;
                return layouts.get(0);
            }
        }
        return null;
    }

    private static <T extends IRecipeWrapper> List<IRecipeLayoutDrawable> getLayouts(IRecipeRegistry registry, IRecipeCategory<T> category, IFocus<ItemStack> focus) {
        ArrayList<IRecipeLayoutDrawable> layouts = new ArrayList<IRecipeLayoutDrawable>();
        List wrappers = registry.getRecipeWrappers(category, focus);
        for (IRecipeWrapper wrapper : wrappers) {
            IRecipeLayoutDrawable layout = registry.createRecipeLayoutDrawable(category, wrapper, focus);
            layouts.add(layout);
        }
        return layouts;
    }

    public void register(@Nonnull IModRegistry registry) {
        IJeiHelpers jeiHelpers = registry.getJeiHelpers();
        registry.addRecipeCategories(new IRecipeCategory[]{new AssemblyTableRecipeCategory(jeiHelpers.getGuiHelper())});
        registry.addRecipeHandlers(new IRecipeHandler[]{new AssemblyTableRecipeHandler()});
        registry.addRecipes(new ArrayList(AssemblyBehaviors.getBehaviors().values()));
        registry.addRecipeCategoryCraftingItem(new ItemStack((Block)ModBlocks.ASSEMBLY_TABLE), new String[]{"refraction.assembly_table"});
    }

    public void onRuntimeAvailable(IJeiRuntime jeiRuntime) {
        super.onRuntimeAvailable(jeiRuntime);
        JEIRefractionPlugin.jeiRuntime = jeiRuntime;
    }
}

