/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.refraction.client.jei;

import com.google.common.collect.ImmutableList;
import com.teamwizardry.librarianlib.client.core.ClientTickHandler;
import com.teamwizardry.librarianlib.client.sprite.Sprite;
import com.teamwizardry.librarianlib.client.sprite.Texture;
import com.teamwizardry.refraction.api.Utils;
import com.teamwizardry.refraction.api.recipe.AssemblyRecipe;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.IRecipeWrapper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;

public class AssemblyTableRecipeWrapper
implements IRecipeWrapper {
    private static ResourceLocation loc = new ResourceLocation("refraction", "textures/gui/assembly_recipe_alpha_bar.png");
    private static Texture texture = new Texture(loc);
    private static Sprite SLOT = texture.getSprite("slot", 18, 18);
    private static Sprite BAR = texture.getSprite("bar", 64, 8);
    private static Sprite OUTLINE = texture.getSprite("outline", 68, 12);
    private static final int CENTER_X = 91;
    private static final int CENTER_Y = 91;
    private ArrayList<Object> inputs = new ArrayList();
    private ArrayList<ItemStack> outputs = new ArrayList();
    private List<FluidStack> fluidInputs = ImmutableList.of();
    private List<FluidStack> fluidOutputs = ImmutableList.of();
    private Color minColor;
    private Color maxColor;
    private Color currentColor;
    private int cycleTimer = 0;
    private int transitionTicks = 0;
    private boolean cycleDirection;
    private boolean transition = false;

    public AssemblyTableRecipeWrapper(AssemblyRecipe recipe) {
        this.inputs.addAll(recipe.getRecipe());
        this.outputs.add(recipe.getResult());
        this.maxColor = recipe.getMaxColor();
        this.minColor = recipe.getMinColor();
        this.currentColor = recipe.getMinColor();
        this.cycleDirection = true;
        this.transition = true;
    }

    public void getIngredients(IIngredients ingredients) {
    }

    public List<?> getInputs() {
        return this.inputs;
    }

    public List<?> getOutputs() {
        return this.outputs;
    }

    public List<FluidStack> getFluidInputs() {
        return this.fluidInputs;
    }

    public List<FluidStack> getFluidOutputs() {
        return this.fluidOutputs;
    }

    public void drawInfo(@Nonnull Minecraft minecraft, int recipeWidth, int recipeHeight, int mouseX, int mouseY) {
        if (!this.transition) {
            if (this.cycleTimer < 50) {
                ++this.cycleTimer;
            } else {
                this.cycleTimer = 0;
                this.transition = true;
            }
        } else {
            this.currentColor = this.cycleDirection ? Utils.mixColors(this.currentColor, this.maxColor, 0.9) : Utils.mixColors(this.currentColor, this.minColor, 0.9);
            if (this.transitionTicks < 50) {
                ++this.transitionTicks;
            } else {
                this.transitionTicks = 0;
                this.transition = false;
                this.cycleDirection = !this.cycleDirection;
            }
        }
        GlStateManager.func_179094_E();
        texture.bind();
        GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
        SLOT.draw(ClientTickHandler.getTicks(), (float)(91 - SLOT.getWidth() / 2), (float)(91 - SLOT.getHeight() / 2));
        GlStateManager.func_179114_b((float)90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        GlStateManager.func_179124_c((float)0.3f, (float)0.3f, (float)0.3f);
        BAR.draw(ClientTickHandler.getTicks(), (float)(91 - BAR.getWidth() / 2), -10.0f);
        GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        BAR.drawClipped(ClientTickHandler.getTicks(), (float)(-91 - BAR.getWidth() / 2), 2.0f, (int)((double)this.currentColor.getAlpha() / 255.0 * 64.0), 8);
        GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        GlStateManager.func_179124_c((float)0.3f, (float)0.0f, (float)0.0f);
        BAR.draw(ClientTickHandler.getTicks(), (float)(91 - BAR.getWidth() / 2), -20.0f);
        GlStateManager.func_179124_c((float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        BAR.drawClipped(ClientTickHandler.getTicks(), (float)(-91 - BAR.getWidth() / 2), 12.0f, (int)((double)this.currentColor.getRed() / 255.0 * 64.0), 8);
        GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        GlStateManager.func_179124_c((float)0.0f, (float)0.3f, (float)0.0f);
        BAR.draw(ClientTickHandler.getTicks(), (float)(91 - BAR.getWidth() / 2), (float)(20 - recipeWidth - 9));
        GlStateManager.func_179124_c((float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        BAR.drawClipped(ClientTickHandler.getTicks(), (float)(-91 - BAR.getWidth() / 2), (float)(recipeWidth - 28 + 9), (int)((double)this.currentColor.getGreen() / 255.0 * 64.0), 8);
        GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        GlStateManager.func_179124_c((float)0.0f, (float)0.0f, (float)0.3f);
        BAR.draw(ClientTickHandler.getTicks(), (float)(91 - BAR.getWidth() / 2), (float)(10 - recipeWidth - 9));
        GlStateManager.func_179124_c((float)0.0f, (float)0.0f, (float)1.0f);
        GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        BAR.drawClipped(ClientTickHandler.getTicks(), (float)(-91 - BAR.getWidth() / 2), (float)(recipeWidth - 18 + 9), (int)((double)this.currentColor.getBlue() / 255.0 * 64.0), 8);
        GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179121_F();
    }

    public void drawAnimations(@Nonnull Minecraft minecraft, int recipeWidth, int recipeHeight) {
    }

    public List<String> getTooltipStrings(int mouseX, int mouseY) {
        int recipeWidth = 180;
        if (mouseY >= 91 - BAR.getWidth() / 2 && mouseY <= 91 + BAR.getWidth() / 2) {
            if (mouseX >= 0 && mouseX <= 8) {
                return ImmutableList.of((Object)("Max Strength: " + this.maxColor.getAlpha()), (Object)("Min Strength: " + this.minColor.getAlpha()));
            }
            if (mouseX >= 10 && mouseX <= 18) {
                return ImmutableList.of((Object)("Max Red: " + this.maxColor.getRed()), (Object)("Min Red: " + this.minColor.getRed()));
            }
            if (mouseX >= recipeWidth - 21 && mouseX <= recipeWidth - 13) {
                return ImmutableList.of((Object)("Max Green: " + this.maxColor.getGreen()), (Object)("Min Green: " + this.minColor.getGreen()));
            }
            if (mouseX >= recipeWidth - 11 && mouseX <= recipeWidth - 3) {
                return ImmutableList.of((Object)("Max Blue: " + this.maxColor.getBlue()), (Object)("Min Blue: " + this.minColor.getBlue()));
            }
        }
        return ImmutableList.of();
    }

    public boolean handleClick(@Nonnull Minecraft minecraft, int mouseX, int mouseY, int mouseButton) {
        return false;
    }
}

