/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.refraction.client.gui.tablet;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.teamwizardry.librarianlib.client.gui.EnumMouseButton;
import com.teamwizardry.librarianlib.client.gui.GuiComponent;
import com.teamwizardry.librarianlib.client.gui.components.ComponentSprite;
import com.teamwizardry.librarianlib.client.gui.components.ComponentText;
import com.teamwizardry.librarianlib.client.gui.mixin.ButtonMixin;
import com.teamwizardry.librarianlib.common.util.math.Vec2d;
import com.teamwizardry.refraction.api.book.TextAdapter;
import com.teamwizardry.refraction.client.gui.LeftSidebar;
import com.teamwizardry.refraction.client.gui.tablet.ExtraSidebar;
import com.teamwizardry.refraction.client.gui.tablet.Page;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.util.text.TextFormatting;

public class SubPage {
    public Page page;
    public String title;
    public String text = "";
    public boolean isSelected = false;
    public int id;
    public int selectedExtraID = 0;
    public List<ExtraSidebar> extraSidebars = new ArrayList<ExtraSidebar>();
    public List<String> textPages = new ArrayList<String>();
    private ComponentSprite component;
    private JsonObject object;
    private TextAdapter adapter;

    public SubPage(Page page, int id, JsonObject object) {
        this.page = page;
        this.id = id;
        this.object = object;
        if (object.has("title") && object.get("title").isJsonPrimitive()) {
            this.title = object.get("title").getAsString();
        }
        if (object.has("text") && object.get("text").isJsonArray()) {
            JsonArray pageArray = object.getAsJsonArray("text");
            this.adapter = new TextAdapter(this, 0, (JsonElement)pageArray);
            this.text = this.adapter.convertLinesToString();
        }
        int letterCount = 0;
        String builder = "";
        for (String word : this.text.split(" ")) {
            word = word.trim();
            if (letterCount < 950) {
                letterCount += word.length();
                builder = builder + " " + word;
                continue;
            }
            this.textPages.add(builder.trim());
            builder = "";
            letterCount = 0;
        }
        this.textPages.add(builder);
        ComponentSprite background = new ComponentSprite(LeftSidebar.leftNormal, 0, 0, LeftSidebar.leftNormal.getWidth(), LeftSidebar.leftNormal.getHeight());
        background.addTag((Object)id);
        ComponentText titleComp = new ComponentText(10, 9, ComponentText.TextAlignH.LEFT, ComponentText.TextAlignV.MIDDLE);
        background.add(new GuiComponent[]{titleComp});
        new ButtonMixin((GuiComponent)background, () -> {});
        background.BUS.hook(GuiComponent.ComponentTickEvent.class, event -> {
            if (page.isSelected) {
                background.setVisible(true);
                background.setEnabled(true);
            } else {
                background.setVisible(false);
                background.setEnabled(false);
            }
            if (this.isSelected) {
                background.setSprite(LeftSidebar.leftExtended);
                int x = LeftSidebar.leftExtended.getWidth() - LeftSidebar.leftExtended.getWidth();
                background.setPos(new Vec2d((double)(x + 5), (double)(20 + 20 * id)));
                background.setSize(new Vec2d((double)LeftSidebar.leftExtended.getWidth(), (double)LeftSidebar.leftExtended.getHeight()));
                titleComp.getText().setValue((Object)(TextFormatting.ITALIC + this.title));
            } else {
                background.setSprite(LeftSidebar.leftNormal);
                int x = LeftSidebar.leftExtended.getWidth() - LeftSidebar.leftNormal.getWidth();
                background.setPos(new Vec2d((double)(x + 5), (double)(20 + 20 * id)));
                background.setSize(new Vec2d((double)LeftSidebar.leftNormal.getWidth(), (double)LeftSidebar.leftNormal.getHeight()));
                titleComp.getText().setValue((Object)this.title);
            }
        });
        background.BUS.hook(ButtonMixin.ButtonClickEvent.class, event -> {
            if (event.getButton() == EnumMouseButton.LEFT && !this.isSelected) {
                page.pageNB = 0;
                for (SubPage subPage : page.subPages) {
                    subPage.isSelected = false;
                }
                this.isSelected = true;
                page.selectedSubPage = id;
                page.text = this.text;
            }
        });
        this.component = background;
    }

    public SubPage init() {
        int i = 0;
        if (this.adapter != null) {
            for (ExtraSidebar extraSidebar : this.adapter.extraSidebars) {
                i = extraSidebar.id;
                this.extraSidebars.add(extraSidebar);
            }
        }
        if (this.adapter != null && !this.adapter.extraSidebars.isEmpty()) {
            ++i;
        }
        if (this.object.has("extra") && this.object.get("extra").isJsonArray()) {
            for (JsonElement extraObject : this.object.get("extra").getAsJsonArray()) {
                if (!extraObject.isJsonObject()) continue;
                ExtraSidebar extraSidebar = new ExtraSidebar(this, i++, extraObject.getAsJsonObject(), ExtraSidebar.SidebarType.IMAGE).init();
                this.extraSidebars.add(extraSidebar);
            }
        }
        for (ExtraSidebar extraSidebar : this.extraSidebars) {
            this.component.add(new GuiComponent[]{extraSidebar.getComponent()});
        }
        return this;
    }

    public ComponentSprite getComponent() {
        return this.component;
    }
}

