/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.refraction.client.gui.tablet;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.teamwizardry.librarianlib.client.gui.EnumMouseButton;
import com.teamwizardry.librarianlib.client.gui.GuiComponent;
import com.teamwizardry.librarianlib.client.gui.components.ComponentSprite;
import com.teamwizardry.librarianlib.client.gui.components.ComponentText;
import com.teamwizardry.librarianlib.client.gui.mixin.ButtonMixin;
import com.teamwizardry.librarianlib.client.sprite.Sprite;
import com.teamwizardry.librarianlib.common.util.math.Vec2d;
import com.teamwizardry.refraction.client.gui.LeftSidebar;
import com.teamwizardry.refraction.client.gui.tablet.GuiBook;
import com.teamwizardry.refraction.client.gui.tablet.SubPage;
import java.util.ArrayList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;

public class Page {
    public final int id;
    public int selectedSubPage = 0;
    public ArrayList<SubPage> subPages = new ArrayList();
    public boolean isSelected = false;
    public Sprite icon;
    public String title;
    public GuiBook book;
    public String text = "";
    public int pageNB = 0;
    private ComponentSprite component;
    private JsonObject object;

    public Page(GuiBook book, int id, JsonObject object) {
        this.book = book;
        this.id = id;
        this.object = object;
        if (object.has("title") && object.get("title").isJsonPrimitive()) {
            this.title = object.get("title").getAsString();
        }
        if (object.has("icon") && object.get("icon").isJsonPrimitive()) {
            ResourceLocation icon = new ResourceLocation(object.get("icon").getAsString());
            ResourceLocation iconQualified = new ResourceLocation(icon.func_110624_b(), icon.func_110623_a());
            this.icon = new Sprite(iconQualified);
        }
        ComponentSprite background = new ComponentSprite(LeftSidebar.leftNormal, -LeftSidebar.leftNormal.getWidth(), 20 * id, LeftSidebar.leftNormal.getWidth(), LeftSidebar.leftNormal.getHeight());
        background.addTag((Object)id);
        ComponentText textComponent = new ComponentText(0, 0, ComponentText.TextAlignH.LEFT, ComponentText.TextAlignV.TOP);
        textComponent.getUnicode().setValue((Object)true);
        textComponent.getWrap().setValue((Object)190);
        background.add(new GuiComponent[]{textComponent});
        ComponentSprite icon = new ComponentSprite(this.icon, 5, 1, 16, 16);
        background.add(new GuiComponent[]{icon});
        ComponentText titleComp = new ComponentText(icon.getSize().getXi() + 10, 9, ComponentText.TextAlignH.LEFT, ComponentText.TextAlignV.MIDDLE);
        background.add(new GuiComponent[]{titleComp});
        ComponentText continueText = new ComponentText(GuiBook.BACKGROUND_SPRITE.getWidth() + LeftSidebar.leftArrow.getWidth() / 2, GuiBook.BACKGROUND_SPRITE.getHeight() - 50, ComponentText.TextAlignH.LEFT, ComponentText.TextAlignV.TOP);
        continueText.getUnicode().setValue((Object)true);
        continueText.getText().setValue((Object)"...");
        ComponentSprite leftNav = new ComponentSprite(LeftSidebar.leftArrow, GuiBook.BACKGROUND_SPRITE.getWidth() + LeftSidebar.leftArrow.getWidth() / 2 - 50, GuiBook.BACKGROUND_SPRITE.getHeight() - 30, 16, 10);
        new ButtonMixin((GuiComponent)leftNav, () -> {});
        leftNav.BUS.hook(GuiComponent.MouseClickEvent.class, mouseClickEvent -> {
            this.pageNB = this.pageNB > 0 ? this.pageNB - 1 : this.pageNB;
        });
        ComponentSprite rightNav = new ComponentSprite(LeftSidebar.rightArrow, GuiBook.BACKGROUND_SPRITE.getWidth() + LeftSidebar.leftArrow.getWidth() / 2 + 50, GuiBook.BACKGROUND_SPRITE.getHeight() - 30, 16, 10);
        new ButtonMixin((GuiComponent)rightNav, () -> {});
        rightNav.BUS.hook(GuiComponent.MouseClickEvent.class, mouseClickEvent -> {
            this.pageNB = this.pageNB < this.subPages.get((int)this.selectedSubPage).textPages.size() - 1 ? this.pageNB + 1 : this.pageNB;
        });
        background.add(new GuiComponent[]{leftNav, rightNav, continueText});
        this.subPages.forEach(subPage -> {
            if (this.selectedSubPage == subPage.id) {
                subPage.isSelected = true;
            }
            background.add(new GuiComponent[]{subPage.getComponent()});
        });
        new ButtonMixin((GuiComponent)background, () -> {});
        background.BUS.hook(GuiComponent.ComponentTickEvent.class, event -> {
            if (this.isSelected) {
                textComponent.setVisible(true);
                textComponent.setEnabled(true);
                if (this.subPages.get((int)this.selectedSubPage).textPages.size() > 1) {
                    rightNav.setEnabled(true);
                    rightNav.setVisible(true);
                    leftNav.setEnabled(true);
                    leftNav.setVisible(true);
                    continueText.setVisible(true);
                } else {
                    rightNav.setEnabled(false);
                    rightNav.setVisible(false);
                    leftNav.setEnabled(false);
                    leftNav.setVisible(false);
                    continueText.setVisible(false);
                }
            } else {
                textComponent.setVisible(false);
                textComponent.setEnabled(false);
                rightNav.setEnabled(false);
                rightNav.setVisible(false);
                leftNav.setEnabled(false);
                leftNav.setVisible(false);
                continueText.setVisible(false);
            }
            if (this.isSelected) {
                textComponent.getText().setValue((Object)this.subPages.get((int)this.selectedSubPage).textPages.get(this.pageNB));
                background.setSprite(LeftSidebar.leftExtended);
                background.setSize(new Vec2d((double)LeftSidebar.leftExtended.getWidth(), (double)LeftSidebar.leftExtended.getHeight()));
                background.setPos(new Vec2d((double)(-LeftSidebar.leftExtended.getWidth()), (double)(20 * id)));
                titleComp.getText().setValue((Object)(TextFormatting.ITALIC + this.title));
            } else {
                background.setSprite(LeftSidebar.leftNormal);
                background.setSize(new Vec2d((double)LeftSidebar.leftNormal.getWidth(), (double)LeftSidebar.leftNormal.getHeight()));
                if (book.selectedPage < id) {
                    background.setPos(new Vec2d((double)(-LeftSidebar.leftNormal.getWidth()), (double)(20 * id + 20 * book.pages.get((int)book.selectedPage).subPages.size())));
                } else {
                    background.setPos(new Vec2d((double)(-LeftSidebar.leftNormal.getWidth()), (double)(20 * id)));
                }
                titleComp.getText().setValue((Object)this.title);
            }
            textComponent.setPos(new Vec2d((double)(background.getSize().getXi() + 20), (double)(-background.getPos().getYi() + 5)));
        });
        background.BUS.hook(ButtonMixin.ButtonClickEvent.class, event -> {
            if (event.getButton() == EnumMouseButton.LEFT && !this.isSelected) {
                for (Page page : book.pages) {
                    page.isSelected = false;
                }
                this.isSelected = true;
                book.selectedPage = id;
            }
        });
        this.component = background;
    }

    public Page init() {
        if (this.object.has("subpages") && this.object.get("subpages").isJsonArray()) {
            JsonArray pages = this.object.get("subpages").getAsJsonArray();
            int subID = 0;
            for (JsonElement element : pages) {
                if (!element.isJsonObject()) continue;
                SubPage subPage = new SubPage(this, subID++, element.getAsJsonObject());
                if (this.selectedSubPage == subPage.id) {
                    subPage.isSelected = true;
                }
                this.subPages.add(subPage.init());
            }
        }
        for (SubPage subPage : this.subPages) {
            this.component.add(new GuiComponent[]{subPage.getComponent()});
        }
        return this;
    }

    public ComponentSprite getComponent() {
        return this.component;
    }
}

