/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.refraction.client.gui.tablet;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.teamwizardry.librarianlib.LibrarianLib;
import com.teamwizardry.librarianlib.client.gui.GuiBase;
import com.teamwizardry.librarianlib.client.gui.GuiComponent;
import com.teamwizardry.librarianlib.client.gui.components.ComponentSprite;
import com.teamwizardry.librarianlib.client.gui.components.ComponentVoid;
import com.teamwizardry.librarianlib.client.sprite.Sprite;
import com.teamwizardry.librarianlib.client.sprite.Texture;
import com.teamwizardry.librarianlib.common.util.math.Vec2d;
import com.teamwizardry.refraction.client.gui.builder.GuiBuilder;
import com.teamwizardry.refraction.client.gui.tablet.Page;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.util.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public class GuiBook
extends GuiBase {
    private static Texture BACKGROUND_TEXTURE = new Texture(new ResourceLocation("refraction", "textures/gui/book_background.png"));
    static Sprite BACKGROUND_SPRITE = BACKGROUND_TEXTURE.getSprite("bg", 232, 323);
    private static Texture BACKGROUND_HANDLE_TEXTURE = new Texture(new ResourceLocation("refraction", "textures/gui/book_background_handle.png"));
    private static Sprite BACKGROUND_HANDLE_SPRITE = BACKGROUND_HANDLE_TEXTURE.getSprite("bg", 232, 323);
    private static Texture BACKGROUND_BOOTUP_TEXTURE = new Texture(new ResourceLocation("refraction", "textures/gui/book_background_bootup.png"));
    public static Sprite BACKGROUND_BOOTUP_SPRITE = BACKGROUND_BOOTUP_TEXTURE.getSprite("bg", 232, 323);
    private static Texture scaleTex = new Texture(new ResourceLocation("refraction", "textures/gui/scale_icon.png"));
    private static Sprite scaleSprite = scaleTex.getSprite("icon", 16, 16);
    @NotNull
    public ArrayList<Page> pages = new ArrayList();
    int selectedPage = 0;

    public GuiBook() {
        super(232, 300);
        ComponentVoid mainComponent = new ComponentVoid(this.field_146294_l / 2, this.field_146295_m / 2, 232, 323);
        ComponentSprite background = new ComponentSprite(BACKGROUND_SPRITE, this.getGuiWidth() / 2 - BACKGROUND_HANDLE_SPRITE.getWidth() / 2, this.getGuiHeight() / 2 - BACKGROUND_HANDLE_SPRITE.getHeight() / 2);
        mainComponent.add(new GuiComponent[]{background});
        ComponentSprite backgroundHandle = new ComponentSprite(BACKGROUND_HANDLE_SPRITE, this.getGuiWidth() / 2 - BACKGROUND_HANDLE_SPRITE.getWidth() / 2, this.getGuiHeight() / 2 - BACKGROUND_HANDLE_SPRITE.getHeight() / 2);
        mainComponent.add(new GuiComponent[]{backgroundHandle});
        if (this.pages.isEmpty()) {
            InputStreamReader reader;
            JsonElement json;
            InputStream stream;
            String langname = Minecraft.func_71410_x().func_135016_M().func_135041_c().func_135034_a();
            try {
                stream = LibrarianLib.PROXY.getResource("refraction", "tablet/" + (String)langname + ".json");
            }
            catch (Throwable e) {
                stream = LibrarianLib.PROXY.getResource("refraction", "tablet/en_US.json");
            }
            if (stream != null && (json = new JsonParser().parse((Reader)(reader = new InputStreamReader(stream)))).isJsonObject() && json.getAsJsonObject().has("pages")) {
                JsonArray array = json.getAsJsonObject().getAsJsonArray("pages");
                int id = 0;
                for (JsonElement element : array) {
                    if (!element.isJsonObject()) continue;
                    Page page = new Page(this, id++, element.getAsJsonObject()).init();
                    if (this.selectedPage == page.id) {
                        page.isSelected = true;
                    }
                    this.pages.add(page);
                }
            }
        }
        for (Page page : this.pages) {
            background.add(new GuiComponent[]{page.getComponent()});
        }
        ScaledResolution resolution = new ScaledResolution(Minecraft.func_71410_x());
        Vec2d res = new Vec2d((double)resolution.func_78326_a(), (double)resolution.func_78328_b());
        ComponentSprite icon = new ComponentSprite(scaleSprite, res.getXi() - 16, res.getYi() / 2, 16, 16);
        icon.BUS.hook(GuiComponent.MouseClickEvent.class, mouseClickEvent -> mainComponent.setChildScale(1.0));
        ComponentSprite increase = new ComponentSprite(GuiBuilder.sprArrowUp, res.getXi() - 16, res.getYi() / 2 - 16, 16, 16);
        increase.BUS.hook(GuiComponent.MouseClickEvent.class, mouseClickEvent -> mainComponent.setChildScale(mainComponent.getChildScale() + 0.1));
        ComponentSprite decrease = new ComponentSprite(GuiBuilder.sprArrowDown, res.getXi() - 16, res.getYi() / 2 + 16, 16, 16);
        decrease.BUS.hook(GuiComponent.MouseClickEvent.class, mouseClickEvent -> {
            if (mainComponent.getChildScale() > 0.1) {
                mainComponent.setChildScale(mainComponent.getChildScale() - 0.1);
            }
        });
        this.getFullscreenComponents().add(new GuiComponent[]{icon, increase, decrease});
        this.getMainComponents().add(new GuiComponent[]{mainComponent});
    }

    public boolean func_73868_f() {
        return true;
    }
}

