/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.refraction.client.gui.tablet;

import com.google.gson.JsonObject;
import com.teamwizardry.librarianlib.client.gui.EnumMouseButton;
import com.teamwizardry.librarianlib.client.gui.GuiComponent;
import com.teamwizardry.librarianlib.client.gui.components.ComponentSprite;
import com.teamwizardry.librarianlib.client.gui.components.ComponentStack;
import com.teamwizardry.librarianlib.client.gui.components.ComponentText;
import com.teamwizardry.librarianlib.client.gui.components.ComponentVoid;
import com.teamwizardry.librarianlib.client.gui.mixin.ButtonMixin;
import com.teamwizardry.librarianlib.client.sprite.Sprite;
import com.teamwizardry.librarianlib.common.util.math.Vec2d;
import com.teamwizardry.refraction.client.gui.RightSidebar;
import com.teamwizardry.refraction.client.gui.tablet.GuiBook;
import com.teamwizardry.refraction.client.gui.tablet.SubPage;
import com.teamwizardry.refraction.client.jei.JEIRefractionPlugin;
import mezz.jei.api.IRecipeRegistry;
import mezz.jei.api.gui.IRecipeLayoutDrawable;
import mezz.jei.api.recipe.IFocus;
import mezz.jei.api.recipe.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.Loader;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExtraSidebar {
    @NotNull
    private final SidebarType sidebarType;
    public int id = 0;
    @Nullable
    public ComponentVoid contentComp;
    @Nullable
    public ComponentVoid iconComp;
    @Nullable
    public ComponentStack slotcomp;
    @Nullable
    public Sprite image;
    public String title;
    public SubPage subPage;
    public boolean isSelected = false;
    private ComponentSprite component;

    public ExtraSidebar(SubPage subPage, int id, @Nullable JsonObject object, @NotNull SidebarType sidebarType) {
        this.subPage = subPage;
        this.id = id;
        this.sidebarType = sidebarType;
        if (object != null) {
            if (sidebarType == SidebarType.IMAGE && object.has("image") && object.get("image").isJsonPrimitive()) {
                ResourceLocation icon = new ResourceLocation(object.get("image").getAsString());
                ResourceLocation iconQualified = new ResourceLocation(icon.func_110624_b(), icon.func_110623_a());
                this.image = new Sprite(iconQualified);
            }
            if (object.has("title") && object.get("title").isJsonPrimitive()) {
                this.title = object.get("title").getAsString();
            }
        }
    }

    public ExtraSidebar init() {
        int x = RightSidebar.rightNormal.getWidth() + GuiBook.BACKGROUND_SPRITE.getWidth() - 14;
        ComponentSprite background = new ComponentSprite(RightSidebar.rightNormal, x, 0, RightSidebar.rightNormal.getWidth(), RightSidebar.rightNormal.getHeight());
        background.addTag((Object)this.id);
        if (this.sidebarType == SidebarType.IMAGE && this.image != null) {
            ComponentSprite imageComp = new ComponentSprite(this.image, RightSidebar.rightNormal.getWidth() - this.image.getWidth(), 1, 16, 16);
            new ButtonMixin((GuiComponent)imageComp, () -> {});
            imageComp.BUS.hook(GuiComponent.ComponentTickEvent.class, event -> {
                if (this.isSelected) {
                    imageComp.setSize(new Vec2d(64.0, 64.0));
                    imageComp.setPos(new Vec2d(32.0, 20.0));
                } else {
                    imageComp.setSize(new Vec2d(16.0, 16.0));
                    imageComp.setPos(new Vec2d((double)(RightSidebar.rightNormal.getWidth() - imageComp.getSize().getXi() - 8), 1.0));
                }
            });
            background.add(new GuiComponent[]{imageComp});
        } else if (this.sidebarType == SidebarType.RECIPE && this.slotcomp != null) {
            background.add(new GuiComponent[]{this.slotcomp});
        }
        ComponentText titleComp = new ComponentText(5, 9, ComponentText.TextAlignH.LEFT, ComponentText.TextAlignV.MIDDLE);
        titleComp.getText().setValue((Object)this.title);
        background.add(new GuiComponent[]{titleComp});
        new ButtonMixin((GuiComponent)background, () -> {});
        background.BUS.hook(GuiComponent.ComponentTickEvent.class, event -> {
            if (this.subPage.isSelected) {
                background.setVisible(true);
                background.setEnabled(true);
            } else {
                background.setVisible(false);
                background.setEnabled(false);
            }
            if (this.isSelected) {
                background.setSprite(RightSidebar.rightLarge);
                background.setPos(new Vec2d((double)x, (double)(20 * this.id - this.subPage.id * 20 - this.subPage.page.id * 20 - 20)));
                background.setSize(new Vec2d((double)RightSidebar.rightLarge.getWidth(), (double)RightSidebar.rightLarge.getHeight()));
            } else {
                background.setSprite(RightSidebar.rightNormal);
                if (this.subPage.selectedExtraID < this.id && this.subPage.extraSidebars.get((int)this.subPage.selectedExtraID).isSelected) {
                    background.setPos(new Vec2d((double)x, (double)(20 * this.id - this.subPage.id * 20 - this.subPage.page.id * 20 + RightSidebar.rightLarge.getHeight() - 38)));
                } else {
                    background.setPos(new Vec2d((double)x, (double)(20 * this.id - this.subPage.id * 20 - this.subPage.page.id * 20 - 20)));
                }
                background.setSize(new Vec2d((double)RightSidebar.rightNormal.getWidth(), (double)RightSidebar.rightNormal.getHeight()));
            }
        });
        if (this.sidebarType == SidebarType.RECIPE && Loader.isModLoaded((String)"JEI")) {
            ItemStack stack = (ItemStack)this.slotcomp.getStack().getValue((Object)this.slotcomp);
            IRecipeLayoutDrawable drawable = JEIRefractionPlugin.getDrawableFromItem(stack);
            background.BUS.hook(GuiComponent.PostDrawEvent.class, event -> {
                if (this.subPage.isSelected && this.isSelected) {
                    GlStateManager.func_179094_E();
                    RenderHelper.func_74520_c();
                    GlStateManager.func_179109_b((float)(background.getPos().getXi() + 8), (float)(background.getPos().getYi() + 30), (float)0.0f);
                    Vec2d pos = event.getMousePos();
                    pos = new Vec2d((double)(pos.getXi() - 8), (double)(pos.getYi() - 30));
                    boolean isAssembly = false;
                    IRecipeRegistry registry = JEIRefractionPlugin.jeiRuntime.getRecipeRegistry();
                    IFocus focus = registry.createFocus(IFocus.Mode.OUTPUT, (Object)stack);
                    for (IRecipeCategory category : registry.getRecipeCategories(focus)) {
                        if (!category.getUid().equals("refraction.assembly_table")) continue;
                        isAssembly = true;
                    }
                    if (isAssembly) {
                        GlStateManager.func_179109_b((float)10.0f, (float)-10.0f, (float)0.0f);
                        GlStateManager.func_179139_a((double)0.5, (double)0.5, (double)0.5);
                        pos = new Vec2d((double)(pos.getXi() - 10), (double)(pos.getYi() + 10)).mul(2.0);
                    }
                    drawable.draw(Minecraft.func_71410_x(), pos.getXi(), pos.getYi());
                    if (isAssembly) {
                        GlStateManager.func_179109_b((float)-10.0f, (float)10.0f, (float)0.0f);
                        GlStateManager.func_179139_a((double)2.0, (double)2.0, (double)2.0);
                        GlStateManager.func_179109_b((float)(-background.getPos().getXi() - 8), (float)(-background.getPos().getYi() - 30), (float)0.0f);
                    }
                    GlStateManager.func_179147_l();
                    RenderHelper.func_74518_a();
                    GlStateManager.func_179121_F();
                }
            });
        }
        background.BUS.hook(ButtonMixin.ButtonClickEvent.class, event -> {
            if (event.getButton() == EnumMouseButton.LEFT) {
                if (!this.isSelected) {
                    for (ExtraSidebar sidebar : this.subPage.extraSidebars) {
                        sidebar.isSelected = false;
                    }
                    this.isSelected = true;
                    this.subPage.selectedExtraID = this.id;
                } else {
                    this.isSelected = false;
                }
            }
        });
        this.component = background;
        return this;
    }

    public ComponentSprite getComponent() {
        return this.component;
    }

    public static enum SidebarType {
        IMAGE,
        RECIPE;

    }
}

