/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.refraction.client.gui.builder;

import com.teamwizardry.librarianlib.client.core.ClientTickHandler;
import com.teamwizardry.librarianlib.client.gui.EnumMouseButton;
import com.teamwizardry.librarianlib.client.gui.GuiBase;
import com.teamwizardry.librarianlib.client.gui.GuiComponent;
import com.teamwizardry.librarianlib.client.gui.components.ComponentList;
import com.teamwizardry.librarianlib.client.gui.components.ComponentSprite;
import com.teamwizardry.librarianlib.client.gui.mixin.ButtonMixin;
import com.teamwizardry.librarianlib.client.sprite.Sprite;
import com.teamwizardry.librarianlib.client.sprite.Texture;
import com.teamwizardry.librarianlib.common.util.math.Vec2d;
import com.teamwizardry.refraction.client.gui.LeftSidebar;
import com.teamwizardry.refraction.client.gui.RightSidebar;
import com.teamwizardry.refraction.client.gui.builder.LayerSelector;
import com.teamwizardry.refraction.client.gui.builder.ModeSelector;
import com.teamwizardry.refraction.client.gui.builder.regionoptions.OptionFill;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.ResourceLocation;
import org.jetbrains.annotations.Nullable;

public class GuiBuilder
extends GuiBase {
    private static final Texture texScreen = new Texture(new ResourceLocation("refraction", "textures/gui/builder/screen.png"));
    private static final Texture texBorder = new Texture(new ResourceLocation("refraction", "textures/gui/builder/border.png"));
    private static final Texture texSpriteSheet = new Texture(new ResourceLocation("refraction", "textures/gui/builder/builder_sheet.png"));
    public static final Sprite sprArrowUp = texSpriteSheet.getSprite("arrow_up", 16, 16);
    public static final Sprite sprArrowDown = texSpriteSheet.getSprite("arrow_down", 16, 16);
    public static final Sprite sprLayers = texSpriteSheet.getSprite("layers", 16, 16);
    private static final Sprite sprScreen = texScreen.getSprite("bg", 256, 256);
    private static final Sprite sprBorder = texBorder.getSprite("bg", 276, 276);
    private static final Sprite sprTileRightSelected = texSpriteSheet.getSprite("tile_right_selected", 16, 16);
    private static final Sprite sprTileLeftSelected = texSpriteSheet.getSprite("tile_left_selected", 16, 16);
    private static final Sprite sprTileNormal = texSpriteSheet.getSprite("tile_normal", 16, 16);
    private static final Sprite sprIconDirect = texSpriteSheet.getSprite("icon_direct", 16, 16);
    private static final Sprite sprIconRegionSelection = texSpriteSheet.getSprite("icon_region_selection", 16, 16);
    private static final Sprite sprTabMode = texSpriteSheet.getSprite("tab_mode", 16, 16);
    public TileType[][][] grid = new TileType[16][16][16];
    public int selectedLayer = 0;
    public Mode selectedMode = Mode.DIRECT;

    public GuiBuilder() {
        super(sprBorder.getWidth() + LeftSidebar.leftExtended.getWidth() * 2, sprBorder.getHeight());
        for (int i = 0; i < this.grid.length; ++i) {
            for (int j = 0; j < this.grid.length; ++j) {
                for (int k = 0; k < this.grid.length; ++k) {
                    this.grid[i][j][k] = TileType.EMPTY;
                }
            }
        }
        ComponentList leftSidebar = new ComponentList(LeftSidebar.leftExtended.getWidth(), 0);
        LeftSidebar modeComp = new LeftSidebar(leftSidebar, "Selection Modes", sprTabMode, true, true);
        modeComp.listComp.setMarginLeft(5.0);
        modeComp.listComp.add(new GuiComponent[]{new ModeSelector((ComponentList)modeComp.listComp, (GuiBuilder)this, (Mode)Mode.DIRECT, (String)"Set Tiles Directly", (Sprite)GuiBuilder.sprIconDirect, (boolean)true).component});
        ComponentList selectRegionOptions = new ComponentList(0, 0);
        selectRegionOptions.add(new GuiComponent[]{new OptionFill((GuiBuilder)this, (ComponentList)selectRegionOptions, (String)"Fill", (Sprite)GuiBuilder.sprIconDirect, (TileType)TileType.PLACED).component});
        selectRegionOptions.add(new GuiComponent[]{new OptionFill((GuiBuilder)this, (ComponentList)selectRegionOptions, (String)"Clear", (Sprite)GuiBuilder.sprIconDirect, (TileType)TileType.EMPTY).component});
        ModeSelector selectRegionComp = new ModeSelector(modeComp.listComp, this, Mode.SELECT, "Select Regions", sprIconRegionSelection, false);
        selectRegionComp.listComp.add(new GuiComponent[]{selectRegionOptions});
        modeComp.listComp.add(new GuiComponent[]{selectRegionComp.component});
        leftSidebar.add(new GuiComponent[]{modeComp.component});
        this.getMainComponents().add(new GuiComponent[]{leftSidebar});
        ComponentList rightSidebar = new ComponentList(sprBorder.getWidth() * 2 - 11, 0);
        RightSidebar layers = new RightSidebar(rightSidebar, "Layers", sprLayers, false, true);
        layers.listComp.setMarginLeft(-5.0);
        layers.component.BUS.hook(GuiComponent.ComponentTickEvent.class, componentTickEvent -> {
            layers.title = "Layers - Current: " + this.selectedLayer;
        });
        LayerSelector layerUp = new LayerSelector(this, rightSidebar, "Layer Up", sprArrowUp, true);
        LayerSelector layerDown = new LayerSelector(this, rightSidebar, "Layer Down", sprArrowDown, false);
        layers.listComp.add(new GuiComponent[]{layerUp.component, layerDown.component});
        rightSidebar.add(new GuiComponent[]{layers.component});
        this.getMainComponents().add(new GuiComponent[]{rightSidebar});
        ComponentSprite compBorder = new ComponentSprite(sprBorder, this.getGuiWidth() / 2 - sprBorder.getWidth() / 2, this.getGuiHeight() / 2 - sprBorder.getHeight() / 2);
        this.getMainComponents().add(new GuiComponent[]{compBorder});
        ComponentSprite compScreen = new ComponentSprite(sprScreen, this.getGuiWidth() / 2 - sprScreen.getWidth() / 2, this.getGuiHeight() / 2 - sprScreen.getHeight() / 2);
        new ButtonMixin((GuiComponent)compScreen, () -> {});
        compScreen.BUS.hook(GuiComponent.MouseDragEvent.class, event -> {
            Vec2d pos = event.getMousePos();
            int x = pos.getXi() / 16;
            int y = pos.getYi() / 16;
            if (x < this.grid.length && y < this.grid.length && x > 0 && y > 0 && this.selectedMode == Mode.DIRECT) {
                if (event.getButton() == EnumMouseButton.LEFT) {
                    this.grid[this.selectedLayer][x][y] = TileType.PLACED;
                } else if (event.getButton() == EnumMouseButton.RIGHT) {
                    this.grid[this.selectedLayer][x][y] = TileType.EMPTY;
                }
            }
        });
        compScreen.BUS.hook(GuiComponent.MouseDownEvent.class, event -> {
            Vec2d pos = event.getMousePos();
            int x = pos.getXi() / 16;
            int y = pos.getYi() / 16;
            if (x < this.grid.length && y < this.grid.length && x > 0 && y > 0) {
                if (this.selectedMode == Mode.DIRECT) {
                    this.grid[this.selectedLayer][x][y] = this.grid[this.selectedLayer][x][y] == TileType.EMPTY ? TileType.PLACED : TileType.EMPTY;
                } else if (this.selectedMode == Mode.SELECT) {
                    if (this.grid[this.selectedLayer][x][y] == TileType.EMPTY) {
                        if (event.getButton() == EnumMouseButton.LEFT) {
                            Vec2d left = this.getTile(TileType.LEFT_SELECTED);
                            if (left != null) {
                                this.grid[this.selectedLayer][left.getXi()][left.getYi()] = TileType.EMPTY;
                            }
                            this.grid[this.selectedLayer][x][y] = TileType.LEFT_SELECTED;
                        } else {
                            Vec2d left = this.getTile(TileType.RIGHT_SELECTED);
                            if (left != null) {
                                this.grid[this.selectedLayer][left.getXi()][left.getYi()] = TileType.EMPTY;
                            }
                            this.grid[this.selectedLayer][x][y] = TileType.RIGHT_SELECTED;
                        }
                    } else {
                        this.grid[this.selectedLayer][x][y] = TileType.EMPTY;
                    }
                }
            }
        });
        compScreen.BUS.hook(GuiComponent.PostDrawEvent.class, event -> {
            TileType box;
            int j;
            int i;
            for (i = 0; i < this.grid.length; ++i) {
                for (j = 0; j < this.grid.length; ++j) {
                    box = this.grid[this.selectedLayer][i][j];
                    GlStateManager.func_179094_E();
                    GlStateManager.func_179141_d();
                    GlStateManager.func_179147_l();
                    GlStateManager.func_179098_w();
                    GlStateManager.func_179140_f();
                    texSpriteSheet.bind();
                    if (box == TileType.PLACED) {
                        sprTileNormal.draw((int)ClientTickHandler.getPartialTicks(), (float)(event.getComponent().getPos().getXi() + i * 16), (float)(event.getComponent().getPos().getYi() + j * 16));
                    } else if (box == TileType.LEFT_SELECTED) {
                        sprTileLeftSelected.draw((int)ClientTickHandler.getPartialTicks(), (float)(event.getComponent().getPos().getXi() + i * 16), (float)(event.getComponent().getPos().getYi() + j * 16));
                    } else if (box == TileType.RIGHT_SELECTED) {
                        sprTileRightSelected.draw((int)ClientTickHandler.getPartialTicks(), (float)(event.getComponent().getPos().getXi() + i * 16), (float)(event.getComponent().getPos().getYi() + j * 16));
                    }
                    GlStateManager.func_179145_e();
                    GlStateManager.func_179090_x();
                    GlStateManager.func_179121_F();
                }
            }
            for (i = 0; i < this.grid.length; ++i) {
                for (j = 0; j < this.grid.length; ++j) {
                    if (this.selectedLayer - 1 < 0) continue;
                    box = this.grid[this.selectedLayer - 1][i][j];
                    GlStateManager.func_179094_E();
                    GlStateManager.func_179141_d();
                    GlStateManager.func_179147_l();
                    GlStateManager.func_179098_w();
                    GlStateManager.func_179140_f();
                    GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)0.3f);
                    texSpriteSheet.bind();
                    if (box == TileType.PLACED) {
                        sprTileNormal.draw((int)ClientTickHandler.getPartialTicks(), (float)(event.getComponent().getPos().getXi() + i * 16), (float)(event.getComponent().getPos().getYi() + j * 16));
                    } else if (box == TileType.LEFT_SELECTED) {
                        sprTileLeftSelected.draw((int)ClientTickHandler.getPartialTicks(), (float)(event.getComponent().getPos().getXi() + i * 16), (float)(event.getComponent().getPos().getYi() + j * 16));
                    } else if (box == TileType.RIGHT_SELECTED) {
                        sprTileRightSelected.draw((int)ClientTickHandler.getPartialTicks(), (float)(event.getComponent().getPos().getXi() + i * 16), (float)(event.getComponent().getPos().getYi() + j * 16));
                    }
                    GlStateManager.func_179145_e();
                    GlStateManager.func_179090_x();
                    GlStateManager.func_179121_F();
                }
            }
        });
        this.getMainComponents().add(new GuiComponent[]{compScreen});
    }

    public boolean func_73868_f() {
        return false;
    }

    public boolean hasTile(TileType type) {
        TileType[][] tileTypeArray = this.grid[this.selectedLayer];
        int n = tileTypeArray.length;
        for (int i = 0; i < n; ++i) {
            TileType[] x;
            for (TileType tileType : x = tileTypeArray[i]) {
                if (tileType != type) continue;
                return true;
            }
        }
        return false;
    }

    @Nullable
    public Vec2d getTile(TileType type) {
        for (int i = 0; i < this.grid.length; ++i) {
            for (int j = 0; j < this.grid.length; ++j) {
                if (this.grid[this.selectedLayer][i][j] != type) continue;
                return new Vec2d((double)i, (double)j);
            }
        }
        return null;
    }

    public static enum Mode {
        DIRECT,
        SELECT;

    }

    public static enum TileType {
        EMPTY,
        LEFT_SELECTED,
        RIGHT_SELECTED,
        PLACED;

    }
}

