/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.refraction.client.core;

import com.teamwizardry.librarianlib.common.util.math.Vec2d;
import com.teamwizardry.refraction.api.IPrecision;
import com.teamwizardry.refraction.init.ModItems;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.client.event.DrawBlockHighlightEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class ScrewdriverOverlay {
    public static final ScrewdriverOverlay INSTANCE = new ScrewdriverOverlay();
    private BlockPos highlighting;

    private ScrewdriverOverlay() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void overlay(RenderGameOverlayEvent.Post event) {
        WorldClient world;
        IBlockState state;
        ItemStack stack = this.getItemInHand((Item)ModItems.SCREW_DRIVER);
        if (stack == null) {
            return;
        }
        if (event.getType() == RenderGameOverlayEvent.ElementType.HOTBAR) {
            ScaledResolution res = new ScaledResolution(Minecraft.func_71410_x());
            double SQRT2 = Math.sqrt(0.5);
            double angle = IPrecision.Helper.getRotationMultiplier(stack);
            int textIndex = IPrecision.Helper.getRotationIndex(stack);
            double anglePer = 5.0;
            String text = I18n.func_135052_a((String)("gui.screw_driver.angle." + textIndex), (Object[])new Object[0]);
            int circleRadius = 75;
            int posX = res.func_78326_a();
            int posY = res.func_78328_b();
            if (angle < 5.0) {
                double radiusAdd = 500.0;
                posX = (int)((double)posX + SQRT2 * radiusAdd);
                posY = (int)((double)posY + SQRT2 * radiusAdd);
                circleRadius = (int)((double)circleRadius + radiusAdd);
            }
            GlStateManager.func_179094_E();
            GlStateManager.func_179090_x();
            GlStateManager.func_179124_c((float)0.0f, (float)0.0f, (float)0.0f);
            GlStateManager.func_179109_b((float)posX, (float)posY, (float)0.0f);
            Vec2d vec = new Vec2d(0.0, (double)(-circleRadius));
            vec = this.rot(vec, -angle / 2.0 - 45.0);
            Tessellator tessellator = Tessellator.func_178181_a();
            VertexBuffer vb = tessellator.func_178180_c();
            vb.func_181668_a(6, DefaultVertexFormats.field_181705_e);
            vb.func_181662_b(0.0, 0.0, 0.0).func_181675_d();
            double ang = angle;
            do {
                Vec2d v = this.rot(vec, ang);
                vb.func_181662_b(v.getX(), v.getY(), 0.0).func_181675_d();
            } while ((ang -= anglePer) > 0.0);
            vb.func_181662_b(vec.getX(), vec.getY(), 0.0).func_181675_d();
            tessellator.func_78381_a();
            GlStateManager.func_179098_w();
            int width = Minecraft.func_71410_x().field_71466_p.func_78256_a(text);
            Minecraft.func_71410_x().field_71466_p.func_175065_a(text, (float)(-width - (int)((double)circleRadius * SQRT2)), (float)(-9 - (int)((double)circleRadius * SQRT2)), 0, false);
            GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179121_F();
        }
        if (event.getType() == RenderGameOverlayEvent.ElementType.CROSSHAIRS && this.highlighting != null && (state = (world = Minecraft.func_71410_x().field_71441_e).func_180495_p(this.highlighting)).func_177230_c() instanceof IPrecision) {
            IPrecision prec = (IPrecision)state.func_177230_c();
            GlStateManager.func_179094_E();
            GlStateManager.func_179098_w();
            GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
            String s = prec.getRotX((World)world, this.highlighting) + ", " + prec.getRotY((World)world, this.highlighting);
            Minecraft.func_71410_x().field_71466_p.func_175063_a(s, (float)(event.getResolution().func_78326_a() / 2 - Minecraft.func_71410_x().field_71466_p.func_78256_a(s) / 2), (float)(event.getResolution().func_78328_b() / 2 + 30), 0xFFFFFF);
            GlStateManager.func_179121_F();
            this.highlighting = null;
        }
    }

    @SubscribeEvent
    public void highlight(DrawBlockHighlightEvent event) {
        if (event.getTarget() != null && event.getTarget().field_72313_a == RayTraceResult.Type.BLOCK) {
            BlockPos hit = event.getTarget().func_178782_a();
            IBlockState target = event.getPlayer().func_130014_f_().func_180495_p(hit);
            this.highlighting = target.func_177230_c() instanceof IPrecision ? hit : null;
        }
    }

    private Vec2d rot(Vec2d vec, double deg) {
        double theta = Math.toRadians(deg);
        double cs = Math.cos(theta);
        double sn = Math.sin(theta);
        return new Vec2d(vec.getX() * cs - vec.getY() * sn, vec.getX() * sn + vec.getY() * cs);
    }

    private ItemStack getItemInHand(Item item) {
        ItemStack stack = Minecraft.func_71410_x().field_71439_g.func_184614_ca();
        if (stack == null) {
            stack = Minecraft.func_71410_x().field_71439_g.func_184592_cb();
        }
        if (stack == null) {
            return null;
        }
        if (stack.func_77973_b() != item) {
            return null;
        }
        return stack;
    }
}

