/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.refraction.client.core;

import com.teamwizardry.librarianlib.client.core.ClientTickHandler;
import com.teamwizardry.refraction.api.ConfigValues;
import java.awt.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.Vec3d;

public class RenderLaserUtil {
    private static ResourceLocation textLaser = new ResourceLocation("refraction", "textures/laser.png");
    private static ResourceLocation textLaserFlat = new ResourceLocation("refraction", "textures/laser_flat.png");
    private static boolean drawingLasers = false;

    public static void startRenderingLasers() {
        drawingLasers = true;
        Tessellator tessellator = Tessellator.func_178181_a();
        VertexBuffer vb = tessellator.func_178180_c();
        vb.func_181668_a(7, DefaultVertexFormats.field_181709_i);
    }

    public static void finishRenderingLasers() {
        drawingLasers = false;
        Tessellator.func_178181_a().func_78381_a();
    }

    public static void renderLaser(Color color, Vec3d start, Vec3d end) {
        if (ConfigValues.USE_FLAT_BEAM_TEXTURE) {
            Minecraft.func_71410_x().func_110434_K().func_110577_a(textLaserFlat);
        } else {
            Minecraft.func_71410_x().func_110434_K().func_110577_a(textLaser);
        }
        int alpha = Math.max(50, color.getAlpha());
        int addColorMin = 30 * alpha / 255;
        color = new Color(Math.max(addColorMin, color.getRed()), Math.max(addColorMin, color.getGreen()), Math.max(addColorMin, color.getBlue()), alpha);
        GlStateManager.func_179129_p();
        if (ConfigValues.ADDITIVE_BLENDING) {
            GlStateManager.func_179147_l();
            GlStateManager.func_179112_b((int)770, (int)1);
        }
        Vec3d playerEyes = Minecraft.func_71410_x().field_71439_g.func_174824_e(ClientTickHandler.getPartialTicks());
        Vec3d normal = end.func_178788_d(start).func_72431_c(playerEyes.func_178788_d(start)).func_72432_b();
        if (normal.field_72448_b < 0.0) {
            normal = normal.func_186678_a(-1.0);
        }
        Vec3d d = new Vec3d(0.0, 0.25 * (double)color.getAlpha() / 255.0 / 2.0, 0.0);
        Vec3d d2 = new Vec3d(0.25 * (double)color.getAlpha() / 255.0 / 2.0, 0.0, 0.0);
        Vec3d d3 = new Vec3d(0.0, 0.0, 0.25 * (double)color.getAlpha() / 255.0 / 2.0);
        double vMin = 0.0;
        double vMax = 1.0;
        double uMin = 0.0;
        double uMax = 1.0;
        Tessellator tessellator = Tessellator.func_178181_a();
        VertexBuffer vb = tessellator.func_178180_c();
        GlStateManager.func_179132_a((boolean)false);
        if (!drawingLasers) {
            vb.func_181668_a(7, DefaultVertexFormats.field_181709_i);
        }
        RenderLaserUtil.pos(vb, start.func_178787_e(d)).func_187315_a(uMin, vMin).func_181669_b(color.getRed(), color.getGreen(), color.getBlue(), Math.max(128, color.getAlpha())).func_181675_d();
        RenderLaserUtil.pos(vb, start.func_178788_d(d)).func_187315_a(uMin, vMax).func_181669_b(color.getRed(), color.getGreen(), color.getBlue(), Math.max(128, color.getAlpha())).func_181675_d();
        RenderLaserUtil.pos(vb, end.func_178788_d(d)).func_187315_a(uMax, vMax).func_181669_b(color.getRed(), color.getGreen(), color.getBlue(), Math.max(128, color.getAlpha())).func_181675_d();
        RenderLaserUtil.pos(vb, end.func_178787_e(d)).func_187315_a(uMax, vMin).func_181669_b(color.getRed(), color.getGreen(), color.getBlue(), Math.max(128, color.getAlpha())).func_181675_d();
        if (!drawingLasers) {
            tessellator.func_78381_a();
        }
        if (!drawingLasers) {
            vb.func_181668_a(7, DefaultVertexFormats.field_181709_i);
        }
        RenderLaserUtil.pos(vb, start.func_178787_e(d2)).func_187315_a(uMin, vMin).func_181669_b(color.getRed(), color.getGreen(), color.getBlue(), Math.max(128, color.getAlpha())).func_181675_d();
        RenderLaserUtil.pos(vb, start.func_178788_d(d2)).func_187315_a(uMin, vMax).func_181669_b(color.getRed(), color.getGreen(), color.getBlue(), Math.max(128, color.getAlpha())).func_181675_d();
        RenderLaserUtil.pos(vb, end.func_178788_d(d2)).func_187315_a(uMax, vMax).func_181669_b(color.getRed(), color.getGreen(), color.getBlue(), Math.max(128, color.getAlpha())).func_181675_d();
        RenderLaserUtil.pos(vb, end.func_178787_e(d2)).func_187315_a(uMax, vMin).func_181669_b(color.getRed(), color.getGreen(), color.getBlue(), Math.max(128, color.getAlpha())).func_181675_d();
        if (!drawingLasers) {
            tessellator.func_78381_a();
        }
        if (!drawingLasers) {
            vb.func_181668_a(7, DefaultVertexFormats.field_181709_i);
        }
        RenderLaserUtil.pos(vb, start.func_178787_e(d3)).func_187315_a(uMin, vMin).func_181669_b(color.getRed(), color.getGreen(), color.getBlue(), Math.max(128, color.getAlpha())).func_181675_d();
        RenderLaserUtil.pos(vb, start.func_178788_d(d3)).func_187315_a(uMin, vMax).func_181669_b(color.getRed(), color.getGreen(), color.getBlue(), Math.max(128, color.getAlpha())).func_181675_d();
        RenderLaserUtil.pos(vb, end.func_178788_d(d3)).func_187315_a(uMax, vMax).func_181669_b(color.getRed(), color.getGreen(), color.getBlue(), Math.max(128, color.getAlpha())).func_181675_d();
        RenderLaserUtil.pos(vb, end.func_178787_e(d3)).func_187315_a(uMax, vMin).func_181669_b(color.getRed(), color.getGreen(), color.getBlue(), Math.max(128, color.getAlpha())).func_181675_d();
        if (!drawingLasers) {
            tessellator.func_78381_a();
        }
    }

    private static VertexBuffer pos(VertexBuffer vb, Vec3d pos) {
        return vb.func_181662_b(pos.field_72450_a, pos.field_72448_b, pos.field_72449_c);
    }
}

