/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.refraction.client.core;

import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class HudRenderHelper {
    public static void renderHud(World world, EnumFacing orientation, BlockPos position, double x, double y, double z, List<String> text) {
        HudPlacement hudPlacement = world.func_175623_d(position.func_177984_a()) ? HudPlacement.HUD_ABOVE : HudPlacement.HUD_ABOVE_FRONT;
        HudOrientation hudOrientation = HudOrientation.HUD_SOUTH;
        HudRenderHelper.renderHud(text, hudPlacement, hudOrientation, orientation, x, y, z);
    }

    public static void renderHud(World world, EnumFacing orientation, HudOrientation hudOrientation, BlockPos position, double x, double y, double z, List<String> text) {
        HudPlacement hudPlacement = world.func_175623_d(position.func_177984_a()) ? HudPlacement.HUD_ABOVE : HudPlacement.HUD_ABOVE_FRONT;
        boolean renderAllSides = false;
        if ((hudOrientation == HudOrientation.HUD_TOPLAYER_HORIZ || hudOrientation == HudOrientation.HUD_TOPLAYER) && hudPlacement == HudPlacement.HUD_ABOVE_FRONT) {
            renderAllSides = true;
        }
        if (renderAllSides) {
            HudRenderHelper.renderHud(text, hudPlacement, HudOrientation.HUD_SOUTH, EnumFacing.EAST, x, y, z);
            HudRenderHelper.renderHud(text, hudPlacement, HudOrientation.HUD_SOUTH, EnumFacing.WEST, x, y, z);
            HudRenderHelper.renderHud(text, hudPlacement, HudOrientation.HUD_SOUTH, EnumFacing.SOUTH, x, y, z);
            HudRenderHelper.renderHud(text, hudPlacement, HudOrientation.HUD_SOUTH, EnumFacing.NORTH, x, y, z);
        } else {
            HudRenderHelper.renderHud(text, hudPlacement, hudOrientation, orientation, x, y, z);
        }
    }

    public static void renderHud(List<String> messages, HudPlacement hudPlacement, HudOrientation hudOrientation, EnumFacing orientation, double x, double y, double z) {
        GlStateManager.func_179094_E();
        if (hudPlacement == HudPlacement.HUD_FRONT) {
            GlStateManager.func_179109_b((float)((float)x + 0.5f), (float)((float)y + 0.75f), (float)((float)z + 0.5f));
        } else if (hudPlacement == HudPlacement.HUD_CENTER) {
            GlStateManager.func_179109_b((float)((float)x + 0.5f), (float)((float)y + 0.5f), (float)((float)z + 0.5f));
        } else {
            GlStateManager.func_179109_b((float)((float)x + 0.5f), (float)((float)y + 1.75f), (float)((float)z + 0.5f));
        }
        GlStateManager.func_179137_b((double)0.0, (double)((double)(-messages.size()) / 10.0), (double)0.0);
        switch (hudOrientation) {
            case HUD_SOUTH: {
                GlStateManager.func_179114_b((float)(-HudRenderHelper.getHudAngle(orientation)), (float)0.0f, (float)1.0f, (float)0.0f);
                break;
            }
            case HUD_TOPLAYER_HORIZ: {
                GlStateManager.func_179114_b((float)(-Minecraft.func_71410_x().func_175598_ae().field_78735_i), (float)0.0f, (float)1.0f, (float)0.0f);
                GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                break;
            }
            case HUD_TOPLAYER: {
                GlStateManager.func_179114_b((float)(-Minecraft.func_71410_x().func_175598_ae().field_78735_i), (float)0.0f, (float)1.0f, (float)0.0f);
                GlStateManager.func_179114_b((float)Minecraft.func_71410_x().func_175598_ae().field_78732_j, (float)1.0f, (float)0.0f, (float)0.0f);
                GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            }
        }
        if (hudPlacement == HudPlacement.HUD_FRONT || hudPlacement == HudPlacement.HUD_ABOVE_FRONT) {
            GlStateManager.func_179137_b((double)0.0, (double)-0.25, (double)0.4625);
        } else if (hudPlacement != HudPlacement.HUD_CENTER) {
            GlStateManager.func_179137_b((double)0.0, (double)-0.25, (double)-0.03749999999999998);
        }
        GlStateManager.func_179129_p();
        GlStateManager.func_179090_x();
        GlStateManager.func_179147_l();
        String longest = "";
        FontRenderer fr = Minecraft.func_71410_x().field_71466_p;
        for (String s : messages) {
            if (fr.func_78256_a(s) <= fr.func_78256_a(longest)) continue;
            longest = s;
        }
        double width = (double)fr.func_78256_a(longest) / 180.0;
        double height = (double)messages.size() / 20.0;
        GlStateManager.func_179137_b((double)0.0, (double)height, (double)0.04);
        Tessellator tessellator = Tessellator.func_178181_a();
        VertexBuffer vertexbuffer = tessellator.func_178180_c();
        vertexbuffer.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        vertexbuffer.func_181662_b(-width, -height, 0.0).func_181666_a(0.0f, 0.0f, 0.0f, 0.25f).func_181675_d();
        vertexbuffer.func_181662_b(-width, height, 0.0).func_181666_a(0.0f, 0.0f, 0.0f, 0.25f).func_181675_d();
        vertexbuffer.func_181662_b(width, height, 0.0).func_181666_a(0.0f, 0.0f, 0.0f, 0.25f).func_181675_d();
        vertexbuffer.func_181662_b(width, -height, 0.0).func_181666_a(0.0f, 0.0f, 0.0f, 0.25f).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179137_b((double)0.0, (double)(-height), (double)-0.04);
        GlStateManager.func_179098_w();
        RenderHelper.func_74518_a();
        GlStateManager.func_179084_k();
        GlStateManager.func_179140_f();
        Minecraft.func_71410_x().field_71460_t.func_175072_h();
        GlStateManager.func_179109_b((float)-0.5f, (float)0.5f, (float)0.05f);
        float f3 = 0.0075f;
        GlStateManager.func_179152_a((float)(f3 * 1.0f), (float)(-f3 * 1.0f), (float)f3);
        for (String s : messages) {
            fr.func_78276_b(s, (int)((double)(fr.func_78256_a(longest) / 2) - (double)fr.func_78256_a(s) / 2.0 + (double)(fr.func_78256_a(longest) / 2)), (int)((double)(messages.indexOf(s) * fr.field_78288_b) + (double)(messages.size() * fr.field_78288_b) / 2.0), 0xFFFFFF);
        }
        Minecraft.func_71410_x().field_71460_t.func_180436_i();
        RenderHelper.func_74519_b();
        GlStateManager.func_179145_e();
        GlStateManager.func_179147_l();
        GlStateManager.func_179121_F();
    }

    private static float getHudAngle(EnumFacing orientation) {
        float f3 = 0.0f;
        if (orientation != null) {
            switch (orientation) {
                case NORTH: {
                    f3 = 180.0f;
                    break;
                }
                case WEST: {
                    f3 = 90.0f;
                    break;
                }
                case EAST: {
                    f3 = -90.0f;
                    break;
                }
                default: {
                    f3 = 0.0f;
                }
            }
        }
        return f3;
    }

    private static void renderText(FontRenderer fontrenderer, List<String> messages) {
        GlStateManager.func_179109_b((float)-0.5f, (float)0.5f, (float)0.05f);
        float f3 = 0.0075f;
        GlStateManager.func_179152_a((float)(f3 * 1.0f), (float)(-f3 * 1.0f), (float)f3);
        GlStateManager.func_187432_a((float)0.0f, (float)0.0f, (float)1.0f);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        HudRenderHelper.renderLog(fontrenderer, messages);
    }

    private static void renderLog(FontRenderer fontrenderer, List<String> messages) {
        int currenty = 7;
        int height = 10;
        int logsize = messages.size();
        int i = 0;
        for (String s : messages) {
            fontrenderer.func_78276_b(s, 0, fontrenderer.field_78288_b * i, 0xFFFFFF);
            ++i;
        }
    }

    public static enum HudOrientation {
        HUD_SOUTH,
        HUD_TOPLAYER_HORIZ,
        HUD_TOPLAYER;

    }

    public static enum HudPlacement {
        HUD_ABOVE,
        HUD_ABOVE_FRONT,
        HUD_FRONT,
        HUD_CENTER;

    }
}

