/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.refraction.client.core;

import com.teamwizardry.librarianlib.client.core.ClientTickHandler;
import com.teamwizardry.librarianlib.client.sprite.Sprite;
import com.teamwizardry.librarianlib.client.sprite.Texture;
import com.teamwizardry.refraction.api.IAmmo;
import com.teamwizardry.refraction.api.IAmmoConsumer;
import com.teamwizardry.refraction.api.Utils;
import com.teamwizardry.refraction.init.ModItems;
import java.awt.Color;
import java.util.HashSet;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class GunOverlay {
    public static final GunOverlay INSTANCE = new GunOverlay();
    private static final int SELECTOR_RADIUS = 30;
    private static final int SELECTOR_WIDTH = 10;
    private static final int SELECTOR_SHIFT = 3;
    private static final float SELECTOR_ALPHA = 0.7f;
    private static Texture texBox;
    private static Texture texHandleVignette;
    private static Sprite sprBox;
    private static Sprite sprHandleVignette;

    public GunOverlay() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void overlay(RenderGameOverlayEvent.Post event) {
        ItemStack stack = this.getItemInHand((Item)ModItems.PHOTON_CANNON);
        if (event.getType() != RenderGameOverlayEvent.ElementType.HOTBAR) {
            return;
        }
        if (stack == null) {
            return;
        }
        ScaledResolution res = new ScaledResolution(Minecraft.func_71410_x());
        int posX = res.func_78326_a();
        int posY = res.func_78328_b();
        NBTTagCompound compound = stack.func_77978_p();
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        if (player.func_70093_af()) {
            List<ItemStack> ammoList = IAmmoConsumer.findAllAmmo((EntityPlayer)player);
            HashSet<Color> colors = new HashSet<Color>();
            for (ItemStack item : ammoList) {
                IAmmo ammo = (IAmmo)item.func_77973_b();
                colors.add(new Color(ammo.getInternalColor(item)));
            }
            int numSegmentsPerArc = (int)Math.ceil(360.0 / (double)colors.size());
            float anglePerColor = (float)(Math.PI * 2 / (double)colors.size());
            float anglePerSegment = anglePerColor / (float)numSegmentsPerArc;
            float angle = 0.0f;
            Color gunColor = Color.WHITE;
            if (compound != null && compound.func_74764_b("color")) {
                gunColor = new Color(compound.func_74762_e("color"));
            }
            GlStateManager.func_179094_E();
            GlStateManager.func_179141_d();
            GlStateManager.func_179147_l();
            GlStateManager.func_179090_x();
            GlStateManager.func_179109_b((float)(posX / 2), (float)(posY / 2), (float)0.0f);
            Tessellator tess = Tessellator.func_178181_a();
            VertexBuffer vb = tess.func_178180_c();
            for (Color color : colors) {
                float[] colorVals = color.getRGBColorComponents(null);
                vb.func_181668_a(7, DefaultVertexFormats.field_181706_f);
                for (int i = 0; i < numSegmentsPerArc; ++i) {
                    int currentRadius = 30 + (gunColor.equals(color) ? 3 : 0);
                    float currentAngle = (float)i * anglePerSegment + angle;
                    vb.func_181662_b((double)((float)(currentRadius - 5) * MathHelper.func_76134_b((float)currentAngle)), (double)((float)(currentRadius - 5) * MathHelper.func_76126_a((float)currentAngle)), 0.0).func_181666_a(colorVals[0], colorVals[1], colorVals[2], 0.7f).func_181675_d();
                    vb.func_181662_b((double)((float)(currentRadius - 5) * MathHelper.func_76134_b((float)(currentAngle + anglePerSegment))), (double)((float)(currentRadius - 5) * MathHelper.func_76126_a((float)(currentAngle + anglePerSegment))), 0.0).func_181666_a(colorVals[0], colorVals[1], colorVals[2], 0.7f).func_181675_d();
                    vb.func_181662_b((double)((float)(currentRadius + 5) * MathHelper.func_76134_b((float)(currentAngle + anglePerSegment))), (double)((float)(currentRadius + 5) * MathHelper.func_76126_a((float)(currentAngle + anglePerSegment))), 0.0).func_181666_a(colorVals[0], colorVals[1], colorVals[2], 0.7f).func_181675_d();
                    vb.func_181662_b((double)((float)(currentRadius + 5) * MathHelper.func_76134_b((float)currentAngle)), (double)((float)(currentRadius + 5) * MathHelper.func_76126_a((float)currentAngle)), 0.0).func_181666_a(colorVals[0], colorVals[1], colorVals[2], 0.7f).func_181675_d();
                }
                tess.func_78381_a();
                angle += anglePerColor;
            }
            GlStateManager.func_179098_w();
            GlStateManager.func_179084_k();
            GlStateManager.func_179118_c();
            GlStateManager.func_179121_F();
        }
        GlStateManager.func_179094_E();
        GlStateManager.func_179141_d();
        GlStateManager.func_179147_l();
        GlStateManager.func_179109_b((float)posX, (float)(posY / 2), (float)0.0f);
        GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
        if (compound != null && compound.func_74764_b("color")) {
            texBox.bind();
            sprBox.draw(ClientTickHandler.getTicks(), -28.0f, (float)(-sprBox.getHeight() / 2));
            Color color = new Color(compound.func_74762_e("color"));
            GlStateManager.func_179124_c((float)color.getRed(), (float)color.getGreen(), (float)color.getBlue());
            int width = 0;
            List<ItemStack> ammoList = IAmmoConsumer.findAllAmmo((EntityPlayer)Minecraft.func_71410_x().field_71439_g, color);
            for (ItemStack ammo : ammoList) {
                IAmmo ammoItem = (IAmmo)ammo.func_77973_b();
                width = Math.min(28, width + (int)(ammoItem.remainingPercentage(ammo) * 28.0f));
            }
            texHandleVignette.bind();
            GlStateManager.func_179109_b((float)(-posX), (float)(-posY / 2), (float)0.0f);
            GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            GlStateManager.func_179109_b((float)-28.0f, (float)(-sprHandleVignette.getHeight() / 2), (float)0.0f);
            GlStateManager.func_179109_b((float)(-posX), (float)(-posY / 2), (float)0.0f);
            GlStateManager.func_179109_b((float)28.0f, (float)-1.0f, (float)0.0f);
            texHandleVignette.bind();
            sprHandleVignette.drawClipped(ClientTickHandler.getTicks(), 0.0f, 0.0f, width, 135);
        }
        GlStateManager.func_179109_b((float)(-posX), (float)(-posY / 2), (float)0.0f);
        GlStateManager.func_179121_F();
    }

    private ItemStack getItemInHand(Item item) {
        ItemStack stack = Minecraft.func_71410_x().field_71439_g.func_184614_ca();
        if (stack == null) {
            stack = Minecraft.func_71410_x().field_71439_g.func_184592_cb();
        }
        if (stack == null) {
            return null;
        }
        if (stack.func_77973_b() != item) {
            return null;
        }
        return stack;
    }

    static {
        Utils.HANDLER.runIfClient(() -> {
            texBox = new Texture(new ResourceLocation("refraction", "textures/gui/ammoselector/gun_box.png"));
            texHandleVignette = new Texture(new ResourceLocation("refraction", "textures/gui/ammoselector/gun_vignette.png"));
            sprBox = texBox.getSprite("box", 28, 135);
            sprHandleVignette = texHandleVignette.getSprite("box", 28, 135);
        });
    }
}

