/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.refraction.api.soundmanager;

import com.teamwizardry.refraction.api.soundmanager.SoundManager;
import com.teamwizardry.refraction.api.soundmanager.Speaker;
import com.teamwizardry.refraction.api.soundmanager.SpeakerNode;
import javax.annotation.Nonnull;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.WorldSavedData;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;

public final class WorldSavedDataSound {
    private static final String SOUND = "refraction-sound";

    public static void markDirty() {
        WorldSavedDataSound.getSaveData().func_76185_a();
    }

    @Nonnull
    public static SoundSavedData getSaveData() {
        WorldServer world = DimensionManager.getWorld((int)0);
        if (world == null || world.func_175693_T() == null) {
            return new SoundSavedData();
        }
        SoundSavedData saveData = (SoundSavedData)world.func_175693_T().func_75742_a(SoundSavedData.class, SOUND);
        if (saveData == null) {
            saveData = new SoundSavedData();
            world.func_175693_T().func_75745_a(SOUND, (WorldSavedData)saveData);
        }
        return saveData;
    }

    public static class SoundSavedData
    extends WorldSavedData {
        public SoundSavedData(String id) {
            super(id);
        }

        public SoundSavedData() {
            super(WorldSavedDataSound.SOUND);
        }

        @Nonnull
        public NBTTagCompound func_189551_b(@Nonnull NBTTagCompound compound) {
            NBTTagCompound speakerNodesTag = new NBTTagCompound();
            for (SpeakerNode node : SoundManager.speakerNodes) {
                speakerNodesTag.func_74782_a(node.pos.func_177986_g() + "", (NBTBase)node.serializeNBT());
            }
            compound.func_74782_a("speakerNodes", (NBTBase)speakerNodesTag);
            NBTTagList list = new NBTTagList();
            for (Speaker speaker : SoundManager.speakers) {
                list.func_74742_a((NBTBase)speaker.serializeNBT());
            }
            compound.func_74782_a("speakers", (NBTBase)list);
            return compound;
        }

        public void func_76184_a(@Nonnull NBTTagCompound compound) {
            Object speaker;
            for (String key : compound.func_74775_l("speakerNodes").func_150296_c()) {
                speaker = new SpeakerNode();
                ((SpeakerNode)speaker).deserializeNBT(compound.func_74775_l("speakerNodes").func_74775_l(key));
                SoundManager.speakerNodes.add((SpeakerNode)speaker);
            }
            NBTTagList list = compound.func_150295_c("speakers", 10);
            for (int i = 0; i < list.func_74745_c(); ++i) {
                speaker = new Speaker();
                ((Speaker)speaker).deserializeNBT(list.func_150305_b(i));
                SoundManager.speakers.add((Speaker)speaker);
            }
        }
    }
}

