/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.refraction.api.soundmanager;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.common.util.INBTSerializable;

public class Speaker
implements INBTSerializable<NBTTagCompound> {
    public Block block;
    public List<SoundEvent> sounds = new ArrayList<SoundEvent>();
    public double interval = 10.0;
    public boolean loopOnce = false;
    public float volume = 0.5f;
    public float pitch = 1.0f;

    public Speaker(Block block, int interval, ArrayList<SoundEvent> sounds, float volume, float pitch, boolean loopOnce) {
        this.block = block;
        this.interval = interval;
        this.sounds = sounds;
        this.loopOnce = loopOnce;
        this.volume = volume;
        this.pitch = pitch;
    }

    Speaker() {
    }

    public NBTTagCompound serializeNBT() {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74778_a("block", this.block.getRegistryName().toString());
        NBTTagList soundEvents = new NBTTagList();
        for (SoundEvent event : this.sounds) {
            soundEvents.func_74742_a((NBTBase)new NBTTagString(event.getRegistryName().toString()));
        }
        tag.func_74782_a("soundEvents", (NBTBase)soundEvents);
        tag.func_74780_a("interval", this.interval);
        tag.func_74757_a("loopOnce", this.loopOnce);
        tag.func_74776_a("volume", this.volume);
        tag.func_74776_a("pitch", this.pitch);
        return tag;
    }

    public void deserializeNBT(NBTTagCompound nbt) {
        this.block = Block.func_149684_b((String)nbt.func_74779_i("block"));
        NBTTagList soundEvents = nbt.func_150295_c("soundEvents", 8);
        ArrayList sounds = Lists.newArrayList();
        for (int i = 0; i < soundEvents.func_74745_c(); ++i) {
            sounds.add(SoundEvent.field_187505_a.func_82594_a((Object)new ResourceLocation(soundEvents.func_150307_f(i))));
        }
        this.sounds = sounds;
        this.interval = nbt.func_74769_h("interval");
        this.loopOnce = nbt.func_74767_n("loopOnce");
        this.volume = nbt.func_74760_g("volume");
        this.pitch = nbt.func_74760_g("pitch");
    }
}

