/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.refraction.api.soundmanager;

import com.teamwizardry.refraction.api.soundmanager.ISoundEmitter;
import com.teamwizardry.refraction.api.soundmanager.Speaker;
import com.teamwizardry.refraction.api.soundmanager.SpeakerNode;
import com.teamwizardry.refraction.api.soundmanager.WorldSavedDataSound;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SoundManager {
    public static SoundManager INSTANCE = new SoundManager();
    public static int soundRange = 15;
    public static Set<Speaker> speakers = new HashSet<Speaker>();
    public static Set<SpeakerNode> speakerNodes = new HashSet<SpeakerNode>();

    private SoundManager() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public void addSpeakerNode(World world, BlockPos pos, Block block) {
        for (Speaker speaker : speakers) {
            if (speaker.block != block) continue;
            boolean match = true;
            for (SpeakerNode node : speakerNodes) {
                if (node.pos != pos || node.world.field_73011_w.getDimension() != world.field_73011_w.getDimension()) continue;
                match = false;
            }
            if (!match) continue;
            this.addSpeakerNode(speaker, world, pos);
        }
    }

    public void addSpeakerNode(Speaker speaker, World world, BlockPos pos) {
        speakerNodes.add(new SpeakerNode(speaker, pos, world));
        WorldSavedDataSound.markDirty();
    }

    public void addSpeaker(Block block, int interval, ArrayList<SoundEvent> sounds, float volume, float pitch, boolean loopOnce) {
        for (Speaker speaker : speakers) {
            if (speaker.block != block) continue;
            return;
        }
        speakers.add(new Speaker(block, interval, sounds, volume, pitch, loopOnce));
        WorldSavedDataSound.markDirty();
    }

    @SubscribeEvent
    public void tick(TickEvent.WorldTickEvent event) {
        speakerNodes.removeIf(node -> {
            IBlockState state = node.world.func_180495_p(node.pos);
            if (event.world.field_73011_w.getDimension() != node.world.field_73011_w.getDimension()) {
                return false;
            }
            if (state.func_177230_c() == node.speaker.block) {
                boolean shouldEmit = this.shouldEmit(node.world, node.pos);
                if (shouldEmit && !node.active) {
                    SpeakerNode activeNode = this.searchForActiveNode(node.world, node.speaker.block, node.pos);
                    if (activeNode == null) {
                        node.active = true;
                        WorldSavedDataSound.markDirty();
                    }
                } else if (!shouldEmit && node.active) {
                    node.active = false;
                    this.activateNearbyNode(node.world, node.speaker.block, node.pos);
                    WorldSavedDataSound.markDirty();
                }
                if (!node.active) return false;
                if ((double)node.tick >= node.speaker.interval) {
                    node.tick = 0;
                    WorldSavedDataSound.markDirty();
                    node.world.func_184133_a(null, node.pos, node.speaker.sounds.get(node.queue), SoundCategory.BLOCKS, node.speaker.volume, node.speaker.pitch);
                    if (node.queue >= node.speaker.sounds.size() - 1) {
                        if (node.speaker.loopOnce) return true;
                        node.queue = 0;
                        WorldSavedDataSound.markDirty();
                        return false;
                    } else {
                        ++node.queue;
                        WorldSavedDataSound.markDirty();
                    }
                    return false;
                } else {
                    ++node.tick;
                    WorldSavedDataSound.markDirty();
                }
                return false;
            }
            this.activateNearbyNode(node.world, node.speaker.block, node.pos);
            WorldSavedDataSound.markDirty();
            return true;
        });
    }

    public boolean shouldEmit(World world, BlockPos pos) {
        ISoundEmitter soundEmitter;
        IBlockState state = world.func_180495_p(pos);
        return state.func_177230_c() instanceof ISoundEmitter && (soundEmitter = (ISoundEmitter)state.func_177230_c()).shouldEmit(world, pos);
    }

    public boolean activateNearbyNode(@NotNull World world, @NotNull Block block, @NotNull BlockPos pos) {
        SpeakerNode node;
        if (this.searchForActiveNode(world, block, pos) == null && (node = this.searchForInertNode(world, block, pos)) != null && this.shouldEmit(world, node.pos)) {
            node.active = true;
            WorldSavedDataSound.markDirty();
            return true;
        }
        return false;
    }

    @Nullable
    public SpeakerNode searchForInertNode(@NotNull World world, @NotNull Block block, @NotNull BlockPos pos) {
        for (SpeakerNode node : speakerNodes) {
            if (node.active || node.world.field_73011_w.getDimension() != world.field_73011_w.getDimension() || node.speaker.block != block || Math.abs(node.pos.compareTo((Vec3i)pos)) >= soundRange || Math.abs(node.pos.compareTo((Vec3i)pos)) <= 0) continue;
            return node;
        }
        return null;
    }

    @Nullable
    public SpeakerNode searchForActiveNode(@NotNull World world, @NotNull Block block, @NotNull BlockPos pos) {
        for (SpeakerNode node : speakerNodes) {
            if (!node.active || node.world.field_73011_w.getDimension() != world.field_73011_w.getDimension() || node.speaker.block != block || Math.abs(node.pos.compareTo((Vec3i)pos)) >= soundRange || Math.abs(node.pos.compareTo((Vec3i)pos)) <= 0) continue;
            return node;
        }
        return null;
    }

    @SubscribeEvent
    public void blockBreak(BlockEvent.BreakEvent event) {
        speakerNodes.removeIf(node -> {
            if (node.world.field_73011_w.getDimension() != event.getWorld().field_73011_w.getDimension()) {
                return false;
            }
            if (node.pos.func_177986_g() == event.getPos().func_177986_g()) {
                this.activateNearbyNode(node.world, node.speaker.block, node.pos);
                return true;
            }
            return false;
        });
    }

    @SubscribeEvent
    public void place(BlockEvent.PlaceEvent event) {
        for (Speaker speaker : speakers) {
            if (speaker.block != event.getPlacedBlock().func_177230_c()) continue;
            this.addSpeakerNode(speaker, event.getWorld(), event.getPos());
            return;
        }
    }

    @SubscribeEvent
    public void load(WorldEvent.Load event) {
        WorldSavedDataSound.getSaveData();
    }
}

