/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.refraction.api.recipe;

import com.teamwizardry.librarianlib.LibrarianLog;
import com.teamwizardry.librarianlib.common.util.ItemNBTHelper;
import com.teamwizardry.refraction.api.CapsUtils;
import com.teamwizardry.refraction.api.Utils;
import com.teamwizardry.refraction.api.recipe.IAssemblyBehavior;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.oredict.OreDictionary;

public class ColorConsumingBehavior
implements IAssemblyBehavior {
    private final ArrayList<Object> recipe;
    private final ItemStack result;

    public ColorConsumingBehavior(ItemStack result, Object ... items) {
        this.result = result;
        this.recipe = new ArrayList();
        for (Object obj : items) {
            if (obj instanceof ItemStack) {
                ItemStack stack = (ItemStack)obj;
                int stackSize = stack.field_77994_a;
                stack.field_77994_a = 1;
                for (int i = 0; i < stackSize; ++i) {
                    this.recipe.add(stack);
                }
                continue;
            }
            if (obj instanceof Item) {
                this.recipe.add(new ItemStack((Item)obj));
                continue;
            }
            if (obj instanceof Block) {
                this.recipe.add(new ItemStack((Block)obj));
                continue;
            }
            if (!(obj instanceof String)) continue;
            List oreDicts = OreDictionary.getOres((String)((String)obj));
            if (oreDicts == null || oreDicts.size() <= 0) {
                LibrarianLog.INSTANCE.warn("Invalid OreDict entry " + obj + " in recipe for " + result.func_82833_r(), new Object[0]);
                continue;
            }
            this.recipe.add(OreDictionary.getOres((String)((String)obj)));
        }
    }

    public ArrayList<Object> getRecipe() {
        return this.recipe;
    }

    public ItemStack getResult() {
        return this.result;
    }

    @Override
    public boolean canAccept(Color color, IItemHandler items) {
        return this.recipe.size() == CapsUtils.getOccupiedSlotCount(items) && Utils.matchItemLists(CapsUtils.getListOfItems(items), this.recipe);
    }

    @Override
    public boolean tick(Color color, IItemHandlerModifiable items, IItemHandlerModifiable output, int ticks) {
        if (ticks >= 200) {
            CapsUtils.clearInventory(items);
            ItemStack stack = this.result.func_77946_l();
            ItemNBTHelper.setInt((ItemStack)stack, (String)"color", (int)color.getRGB());
            output.setStackInSlot(0, stack);
            return false;
        }
        return true;
    }

    @Override
    public boolean canEditItems(IItemHandlerModifiable items, IItemHandlerModifiable output, int ticks) {
        return false;
    }
}

