/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.refraction.api.recipe;

import com.teamwizardry.librarianlib.LibrarianLog;
import com.teamwizardry.refraction.api.CapsUtils;
import com.teamwizardry.refraction.api.Utils;
import com.teamwizardry.refraction.api.recipe.IAssemblyBehavior;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.oredict.OreDictionary;

public class AssemblyRecipe
implements IAssemblyBehavior {
    private final ArrayList<Object> recipe;
    private final int minRed;
    private final int minGreen;
    private final int minBlue;
    private final int minStrength;
    private final int maxRed;
    private final int maxGreen;
    private final int maxBlue;
    private final int maxStrength;
    private final Color minColor;
    private final Color maxColor;
    private final ItemStack result;

    public AssemblyRecipe(ItemStack result, int minRed, int minGreen, int minBlue, int minStrength, int maxRed, int maxGreen, int maxBlue, int maxStrength, Object ... items) {
        this.result = result;
        this.minRed = minRed < maxRed ? minRed : maxRed;
        this.maxRed = maxRed < minRed ? minRed : maxRed;
        this.minGreen = minGreen < maxGreen ? minGreen : maxGreen;
        this.maxGreen = maxGreen < minGreen ? minGreen : maxGreen;
        this.minBlue = minBlue < maxBlue ? minBlue : maxBlue;
        this.maxBlue = maxBlue < minBlue ? minBlue : maxBlue;
        this.minStrength = minStrength < maxStrength ? minStrength : maxStrength;
        this.maxStrength = maxStrength < minStrength ? minStrength : maxStrength;
        this.minColor = new Color(this.minRed, this.minGreen, this.minBlue, this.minStrength > 255 ? 255 : this.minStrength);
        this.maxColor = new Color(this.maxRed, this.maxGreen, this.maxBlue, this.maxStrength > 255 ? 255 : this.maxStrength);
        this.recipe = new ArrayList();
        for (Object obj : items) {
            if (obj instanceof ItemStack) {
                ItemStack stack = (ItemStack)obj;
                int stackSize = stack.field_77994_a;
                stack.field_77994_a = 1;
                for (int i = 0; i < stackSize; ++i) {
                    this.recipe.add(stack);
                }
                continue;
            }
            if (obj instanceof Item) {
                this.recipe.add(new ItemStack((Item)obj));
                continue;
            }
            if (obj instanceof Block) {
                this.recipe.add(new ItemStack((Block)obj));
                continue;
            }
            if (!(obj instanceof String)) continue;
            List oreDicts = OreDictionary.getOres((String)((String)obj));
            if (oreDicts == null || oreDicts.size() <= 0) {
                LibrarianLog.INSTANCE.warn("Invalid OreDict entry " + obj + " in recipe for " + result.func_82833_r(), new Object[0]);
                continue;
            }
            this.recipe.add(OreDictionary.getOres((String)((String)obj)));
        }
    }

    public AssemblyRecipe(ItemStack result, Color one, Color two, Object ... items) {
        this(result, one.getRed(), one.getGreen(), one.getBlue(), one.getAlpha(), two.getRed(), two.getGreen(), two.getBlue(), two.getAlpha(), items);
    }

    public ArrayList<Object> getRecipe() {
        return this.recipe;
    }

    public Color getMinColor() {
        return this.minColor;
    }

    public Color getMaxColor() {
        return this.maxColor;
    }

    public ItemStack getResult() {
        return this.result;
    }

    @Override
    public boolean canAccept(Color color, IItemHandler items) {
        return this.recipe.size() == CapsUtils.getOccupiedSlotCount(items) && color.getRed() <= this.maxRed && color.getRed() >= this.minRed && color.getGreen() <= this.maxGreen && color.getGreen() >= this.minGreen && color.getBlue() <= this.maxBlue && color.getBlue() >= this.minBlue && color.getAlpha() <= this.maxStrength && color.getAlpha() >= this.minStrength && Utils.matchItemStackLists(CapsUtils.getListOfItems(items), this.recipe);
    }

    @Override
    public boolean tick(Color color, IItemHandlerModifiable items, IItemHandlerModifiable output, int ticks) {
        if (ticks >= 200) {
            CapsUtils.clearInventory(items);
            output.setStackInSlot(0, this.result.func_77946_l());
            return false;
        }
        return true;
    }

    @Override
    public boolean canEditItems(IItemHandlerModifiable items, IItemHandlerModifiable output, int ticks) {
        return false;
    }
}

