/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.refraction.api.raytrace;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.teamwizardry.refraction.api.ConfigValues;
import com.teamwizardry.refraction.api.beam.Beam;
import com.teamwizardry.refraction.api.beam.BeamPulsar;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.UUID;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EntityTrace {
    @NotNull
    public World world;
    @NotNull
    public Vec3d pos;
    @NotNull
    public Vec3d slope;
    public double range = ConfigValues.BEAM_RANGE;
    public boolean ignoreEntities;
    @Nullable
    public UUID uuidToSkip;
    @Nullable
    public RayTraceResult rayTraceResult;

    public EntityTrace(@NotNull World world, @NotNull Vec3d pos, @NotNull Vec3d slope) {
        this.world = world;
        this.pos = pos;
        this.slope = slope;
    }

    public EntityTrace(@NotNull World world, @NotNull Beam beam) {
        this(world, beam.finalLoc.func_178787_e(beam.slope.func_186678_a(0.05)), beam.slope);
        BlockPos bpos = new BlockPos(beam.finalLoc.func_178787_e(beam.slope));
        IBlockState state = world.func_180495_p(bpos);
        RayTraceResult cast = BeamPulsar.fromBlock(state, world, bpos, beam.finalLoc.func_178787_e(beam.slope.func_186678_a(0.05)), beam.finalLoc.func_178787_e(beam.slope));
        if (!state.func_177230_c().isAir(state, (IBlockAccess)world, bpos) && cast != null && cast.field_72313_a != RayTraceResult.Type.MISS) {
            this.rayTraceResult = cast;
        } else {
            double dist = beam.initLoc.func_72438_d(beam.finalLoc);
            this.range = beam.range - dist;
        }
    }

    private static RayTraceResult blockTrace(World world, Vec3d pos, Vec3d ray, double distance) {
        Vec3d cast = pos.func_178787_e(ray.func_72432_b().func_186678_a(distance));
        return BeamPulsar.rayTraceBlocks(world, new HashSet<BlockPos>((Collection<BlockPos>)ImmutableList.of((Object)new BlockPos(pos))), pos, cast, false, false, true);
    }

    public EntityTrace setRange(double range) {
        this.range = range;
        return this;
    }

    public EntityTrace setIgnoreEntities(boolean ignoreEntities) {
        this.ignoreEntities = ignoreEntities;
        return this;
    }

    public EntityTrace setUUIDToSkip(UUID uuidToSkip) {
        this.uuidToSkip = uuidToSkip;
        return this;
    }

    public RayTraceResult cast() {
        RayTraceResult focusedBlock = EntityTrace.blockTrace(this.world, this.pos, this.slope, this.range);
        double blockDistance = this.range;
        if (focusedBlock != null) {
            blockDistance = focusedBlock.field_72307_f.func_72438_d(this.pos);
        }
        Vec3d cast = this.pos.func_72441_c(this.slope.field_72450_a * this.range, this.slope.field_72448_b * this.range, this.slope.field_72449_c * this.range);
        Entity focusedEntity = null;
        Vec3d vec = null;
        List list = this.world.func_175647_a(Entity.class, new AxisAlignedBB(new BlockPos(this.pos)).func_72321_a(this.slope.field_72450_a * this.range, this.slope.field_72448_b * this.range, this.slope.field_72449_c * this.range).func_72314_b(1.0, 1.0, 1.0), Predicates.and(apply -> apply != null && !this.ignoreEntities && (apply.func_70067_L() || apply instanceof EntityItem), (Predicate)EntitySelectors.field_180132_d));
        double blockDistCopy = blockDistance;
        int j = 0;
        while (j < list.size()) {
            double entityDistance;
            Entity current = (Entity)list.get(j);
            AxisAlignedBB axis = current.func_174813_aQ().func_186662_g((double)current.func_70111_Y());
            if (this.uuidToSkip != null && current.func_110124_au().equals(this.uuidToSkip)) {
                ++j;
                continue;
            }
            if (current instanceof EntityLivingBase && ((EntityLivingBase)current).func_70660_b(MobEffects.field_76441_p) != null || current instanceof EntityPlayer && ((EntityPlayer)current).func_175149_v()) {
                ++j;
                continue;
            }
            if (current instanceof EntityItem) {
                axis = axis.func_72314_b(0.0, 0.25, 0.0);
            }
            RayTraceResult result = axis.func_72327_a(this.pos, cast);
            if (axis.func_72318_a(this.pos)) {
                if (blockDistCopy > 0.0) {
                    focusedEntity = current;
                    vec = result == null ? this.pos : result.field_72307_f;
                    blockDistCopy = 0.0;
                }
            } else if (result != null && ((entityDistance = this.pos.func_72438_d(result.field_72307_f)) < blockDistCopy || blockDistCopy == 0.0)) {
                focusedEntity = current;
                vec = result.field_72307_f;
                blockDistCopy = entityDistance;
            }
            if (focusedEntity != null && (blockDistCopy < blockDistance || focusedBlock == null)) {
                focusedBlock = new RayTraceResult(focusedEntity, vec);
                if (focusedEntity instanceof EntityLivingBase || focusedEntity instanceof EntityItem) {
                    return focusedBlock;
                }
            }
            ++j;
        }
        return focusedBlock;
    }
}

