/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.refraction.api.beam.modes;

import com.teamwizardry.refraction.api.beam.modes.BeamMode;
import com.teamwizardry.refraction.api.beam.modes.ModeEffect;
import com.teamwizardry.refraction.api.beam.modes.ModeGravity;
import com.teamwizardry.refraction.api.beam.modes.ModeGrenade;
import com.teamwizardry.refraction.api.beam.modes.ModeGun;
import com.teamwizardry.refraction.api.beam.modes.ModeNone;
import java.util.HashSet;
import java.util.Set;

public class BeamModeRegistry {
    public static final BeamMode EFFECT = new ModeEffect();
    public static final BeamMode NONE = new ModeNone();
    public static final BeamMode GUN = new ModeGun();
    public static final BeamMode GRENADE = new ModeGrenade();
    public static final BeamMode GRAVITY = new ModeGravity();
    private static Set<BeamMode> modes = new HashSet<BeamMode>();

    public static void init() {
        BeamModeRegistry.registerMode(EFFECT);
        BeamModeRegistry.registerMode(NONE);
        BeamModeRegistry.registerMode(GUN);
        BeamModeRegistry.registerMode(GRENADE);
        BeamModeRegistry.registerMode(GRAVITY);
    }

    public static void registerMode(BeamMode mode) {
        modes.add(mode);
    }

    public static BeamMode getMode(String newMode) {
        for (BeamMode mode : modes) {
            if (!mode.getName().equals(newMode)) continue;
            return mode;
        }
        return NONE;
    }
}

