/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.refraction.api.beam;

import com.google.common.collect.HashMultimap;
import com.teamwizardry.refraction.api.Utils;
import com.teamwizardry.refraction.api.beam.Beam;
import com.teamwizardry.refraction.api.beam.BlockTracker;
import com.teamwizardry.refraction.api.beam.Effect;
import java.awt.Color;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.WeakHashMap;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;

public class EffectTracker {
    public static ArrayList<Effect> effectRegistry = new ArrayList();
    public static HashMap<BlockPos, Integer> gravityProtection = new HashMap();
    public static HashMap<Entity, Integer> gravityReset = new HashMap();
    private static WeakHashMap<World, EffectTracker> effectInstances = new WeakHashMap();
    private HashMultimap<Effect, BlockPos> effects = HashMultimap.create();
    private BlockTracker blockTracker;
    private WeakReference<World> world;

    public EffectTracker(World world) {
        this.world = new WeakReference<World>(world);
        this.blockTracker = new BlockTracker(world);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public static void addEffect(World world, Vec3d pos, Effect effect) {
        if (!effectInstances.containsKey(world)) {
            EffectTracker.addInstance(world);
        }
        EffectTracker.effectInstances.get((Object)world).effects.put((Object)effect, (Object)new BlockPos(pos));
    }

    public static void addEffect(World world, Beam beam) {
        if (!effectInstances.containsKey(world)) {
            EffectTracker.addInstance(world);
        }
        EffectTracker.effectInstances.get((Object)world).blockTracker.addBeam(beam);
    }

    public static boolean addInstance(World world) {
        return effectInstances.putIfAbsent(world, new EffectTracker(world)) == null;
    }

    public static Effect getEffect(Beam beam) {
        Color color = beam.color;
        double closestDist = Utils.getColorDistance(color, Color.WHITE);
        Effect closestColor = null;
        for (Effect effect : effectRegistry) {
            double dist = Utils.getColorDistance(color, effect.getColor());
            if (!(dist < closestDist)) continue;
            closestDist = dist;
            closestColor = effect;
        }
        return closestColor == null ? null : closestColor.copy().setBeam(beam).setPotency(beam.color.getAlpha());
    }

    public static void registerEffect(Effect effect) {
        effectRegistry.add(effect);
    }

    @SubscribeEvent
    public void tick(TickEvent.WorldTickEvent event) {
        if (event.phase == TickEvent.Phase.START && event.side == Side.SERVER) {
            this.blockTracker.generateEffects();
            World w = (World)this.world.get();
            this.effects.keySet().removeIf(effect -> {
                if (effect != null && w != null && this.effects.get(effect) != null) {
                    effect.run(w);
                    if (effect.beam.mode.runSpecialEffects()) {
                        if (effect.beam.caster != null) {
                            if (effect.beam.trace.field_72313_a == RayTraceResult.Type.BLOCK) {
                                effect.specialAddFinalBlock(w, effect.beam.trace.func_178782_a(), (EntityLivingBase)effect.beam.caster);
                            } else if (effect.beam.trace.field_72313_a == RayTraceResult.Type.ENTITY && effect.beam.trace.field_72308_g != null) {
                                effect.specialAddEntity(w, effect.beam.trace.field_72308_g, (EntityLivingBase)effect.beam.caster);
                            }
                            this.effects.get(effect).forEach(blockPos -> {
                                effect.specialAddBlock(w, (BlockPos)blockPos, (EntityLivingBase)effect.beam.caster);
                                if (effect.getType() == Effect.EffectType.BEAM) {
                                    AxisAlignedBB axis = new AxisAlignedBB(blockPos);
                                    List<Entity> entities = effect.filterEntities(w.func_72872_a(Entity.class, axis));
                                    entities.forEach(entity -> {
                                        if (entity != null) {
                                            effect.specialAddEntity(w, (Entity)entity, (EntityLivingBase)effect.beam.caster);
                                        }
                                    });
                                }
                            });
                        }
                    } else if (effect.beam.mode.getClass().isAssignableFrom(effect.getRequiredBeamMode().getClass())) {
                        if (effect.beam.trace.field_72313_a == RayTraceResult.Type.BLOCK) {
                            effect.addFinalBlock(w, effect.beam.trace.func_178782_a());
                        } else if (effect.beam.trace.field_72313_a == RayTraceResult.Type.ENTITY && effect.beam.trace.field_72308_g != null) {
                            effect.addEntity(w, effect.beam.trace.field_72308_g);
                        }
                        this.effects.get(effect).forEach(blockPos -> {
                            effect.addBlock(w, (BlockPos)blockPos);
                            if (effect.getType() == Effect.EffectType.BEAM) {
                                AxisAlignedBB axis = new AxisAlignedBB(blockPos);
                                List<Entity> entities = effect.filterEntities(w.func_72872_a(Entity.class, axis));
                                entities.forEach(entity -> {
                                    if (entity != null) {
                                        effect.addEntity(w, (Entity)entity);
                                    }
                                });
                            }
                        });
                    }
                }
                return true;
            });
            gravityProtection.keySet().removeIf(pos -> {
                if (gravityProtection.get(pos) > 0) {
                    gravityProtection.put((BlockPos)pos, gravityProtection.get(pos) - 1);
                    return false;
                }
                return true;
            });
            gravityReset.keySet().removeIf(entity -> {
                if (gravityReset.get(entity) > 0) {
                    gravityReset.put((Entity)entity, gravityReset.get(entity) - 1);
                    return false;
                }
                entity.func_189654_d(false);
                return true;
            });
        }
    }
}

