/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.refraction.api.beam;

import com.google.common.collect.HashMultimap;
import com.teamwizardry.refraction.api.ConfigValues;
import com.teamwizardry.refraction.api.PosUtils;
import com.teamwizardry.refraction.api.beam.Beam;
import com.teamwizardry.refraction.api.beam.IReflectiveArmor;
import com.teamwizardry.refraction.api.beam.modes.BeamMode;
import com.teamwizardry.refraction.api.beam.modes.BeamModeRegistry;
import java.awt.Color;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;

public class Effect
implements Cloneable {
    public Beam beam;
    public HashMultimap<BlockPos, Entity> entities = HashMultimap.create();
    public Set<BlockPos> blocks = new HashSet<BlockPos>();
    private int potency;
    private HashMap<BlockPos, Integer> blockPotencies = new HashMap();
    private HashMap<UUID, Integer> entityPotencies = new HashMap();

    public Effect setPotency(int potency) {
        this.potency = potency;
        return this;
    }

    public Effect setBeam(Beam beam) {
        this.beam = beam;
        return this;
    }

    public BeamMode getRequiredBeamMode() {
        return BeamModeRegistry.EFFECT;
    }

    public void runEntity(World world, Entity entity, int potency) {
    }

    public void runBlock(World world, BlockPos pos, int potency) {
    }

    public void run(World world) {
    }

    public void specialRunBlock(World world, BlockPos pos, EntityLivingBase caster, int potency) {
        this.runBlock(world, pos, potency);
    }

    public void specialRunFinalBlock(World world, BlockPos pos, EntityLivingBase caster, int potency) {
        this.runFinalBlock(world, pos, potency);
    }

    public void specialRunEntity(World world, Entity entity, EntityLivingBase caster, int potency) {
        this.runEntity(world, entity, potency);
    }

    public void runFinalBlock(World world, BlockPos pos, int potency) {
    }

    void addEntity(@NotNull World world, @NotNull Entity entity) {
        if (this.getChance(this.potency) > 0 && ThreadLocalRandom.current().nextInt(this.getChance(this.potency)) == 0 || this.getChance(this.potency) <= 0) {
            int potency = this.calculateEntityPotency(entity);
            this.entities.put((Object)entity.func_180425_c(), (Object)entity);
            this.runEntity(world, entity, potency);
        }
    }

    void addBlock(@NotNull World world, @NotNull BlockPos pos) {
        if (this.getChance(this.potency) > 0 && ThreadLocalRandom.current().nextInt(this.getChance(this.potency)) == 0 || this.getChance(this.potency) <= 0) {
            this.blocks.add(pos);
            this.runBlock(world, pos, this.calculateBlockPotency(pos));
        }
    }

    void addFinalBlock(@NotNull World world, @NotNull BlockPos pos) {
        if (this.getChance(this.potency) > 0 && ThreadLocalRandom.current().nextInt(this.getChance(this.potency)) == 0 || this.getChance(this.potency) <= 0) {
            this.blocks.add(pos);
            this.runFinalBlock(world, pos, this.calculateBlockPotency(pos));
        }
    }

    void specialAddBlock(@NotNull World world, @NotNull BlockPos pos, @NotNull EntityLivingBase caster) {
        if (this.getChance(this.potency) > 0 && ThreadLocalRandom.current().nextInt(this.getChance(this.potency)) == 0 || this.getChance(this.potency) <= 0) {
            this.blocks.add(pos);
            this.specialRunBlock(world, pos, caster, this.calculateBlockPotency(pos));
        }
    }

    void specialAddFinalBlock(@NotNull World world, @NotNull BlockPos pos, @NotNull EntityLivingBase caster) {
        if (this.getChance(this.potency) > 0 && ThreadLocalRandom.current().nextInt(this.getChance(this.potency)) == 0 || this.getChance(this.potency) <= 0) {
            this.blocks.add(pos);
            this.specialRunFinalBlock(world, pos, caster, this.calculateBlockPotency(pos));
        }
    }

    void specialAddEntity(@NotNull World world, @NotNull Entity entity, @NotNull EntityLivingBase caster) {
        if (this.getChance(this.potency) > 0 && ThreadLocalRandom.current().nextInt(this.getChance(this.potency)) == 0 || this.getChance(this.potency) <= 0) {
            int potency = this.calculateEntityPotency(entity);
            this.entities.put((Object)entity.func_180425_c(), (Object)entity);
            this.specialRunEntity(world, entity, caster, potency);
        }
    }

    List<Entity> filterEntities(List<Entity> entityList) {
        entityList.removeIf(entity -> this.potency < 1 || this.beam.uuidToSkip != null && this.beam.uuidToSkip.equals(entity.func_110124_au()) || entity instanceof EntityLivingBase && ((EntityLivingBase)entity).func_70660_b(MobEffects.field_76441_p) != null || entity instanceof EntityPlayer && ((EntityPlayer)entity).func_175149_v());
        return entityList;
    }

    private int calculateBlockPotency(BlockPos pos) {
        int potency = Math.max(0, this.potency - PosUtils.getDistance(this.beam.initLoc, this.beam.slope, pos) * ConfigValues.DISTANCE_LOSS);
        this.blockPotencies.put(pos, potency);
        return potency;
    }

    private int calculateEntityPotency(Entity entity) {
        int potency = Math.max(0, this.potency - PosUtils.getDistance(this.beam.initLoc, this.beam.slope, entity.func_180425_c()) * ConfigValues.DISTANCE_LOSS);
        for (ItemStack armor : entity.func_184193_aE()) {
            if (armor == null || !(armor.func_77973_b() instanceof IReflectiveArmor)) continue;
            potency = (int)((double)potency / ((IReflectiveArmor)armor.func_77973_b()).reflectionDampeningConstant(armor, this));
        }
        this.entityPotencies.put(entity.func_110124_au(), potency);
        return potency;
    }

    public int getChance(int potency) {
        return -1;
    }

    public Color getColor() {
        return Color.WHITE;
    }

    public EffectType getType() {
        return EffectType.SINGLE;
    }

    public Effect copy() {
        Effect clone = null;
        try {
            clone = (Effect)this.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return clone;
    }

    public static enum EffectType {
        SINGLE,
        BEAM;

    }
}

