/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.refraction.api.beam;

import com.google.common.collect.HashMultimap;
import com.teamwizardry.refraction.api.beam.Beam;
import com.teamwizardry.refraction.api.beam.EffectTracker;
import java.lang.ref.WeakReference;
import java.util.HashSet;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;

public class BlockTracker {
    public HashMultimap<BlockPos, Beam> locations;
    public WeakReference<World> world;

    public BlockTracker(World world) {
        this.world = new WeakReference<World>(world);
        this.locations = HashMultimap.create();
    }

    public void addBeam(Beam beam) {
        HashSet<BlockPos> possible = new HashSet<BlockPos>();
        Vec3d slope = beam.slope;
        Vec3d curPos = beam.initLoc;
        boolean finished = false;
        while (!finished) {
            Vec3d nextPos = curPos.func_178787_e(slope);
            for (BlockPos pos : BlockPos.func_177980_a((BlockPos)new BlockPos(curPos), (BlockPos)new BlockPos(nextPos))) {
                possible.add(pos);
            }
            if (curPos.func_72438_d(beam.finalLoc) <= curPos.func_72438_d(nextPos)) {
                finished = true;
            }
            curPos = nextPos;
        }
        Vec3d invSlope = new Vec3d(1.0 / slope.field_72450_a, 1.0 / slope.field_72448_b, 1.0 / slope.field_72449_c);
        for (BlockPos pos : possible) {
            if (!this.collides(beam, pos, invSlope)) continue;
            this.locations.put((Object)pos, (Object)beam);
        }
        this.locations.remove((Object)new BlockPos(beam.initLoc), (Object)beam);
        this.locations.remove((Object)beam.trace.func_178782_a(), (Object)beam);
    }

    private boolean collides(Beam beam, BlockPos pos, Vec3d invSlope) {
        boolean signX = invSlope.field_72450_a < 0.0;
        boolean signY = invSlope.field_72448_b < 0.0;
        boolean signZ = invSlope.field_72449_c < 0.0;
        AxisAlignedBB axis = new AxisAlignedBB(pos);
        double txMin = ((signX ? axis.field_72336_d : axis.field_72340_a) - beam.initLoc.field_72450_a) * invSlope.field_72450_a;
        double txMax = ((signX ? axis.field_72340_a : axis.field_72336_d) - beam.initLoc.field_72450_a) * invSlope.field_72450_a;
        double tyMin = ((signY ? axis.field_72337_e : axis.field_72338_b) - beam.initLoc.field_72448_b) * invSlope.field_72448_b;
        double tyMax = ((signY ? axis.field_72338_b : axis.field_72337_e) - beam.initLoc.field_72448_b) * invSlope.field_72448_b;
        double tzMin = ((signZ ? axis.field_72334_f : axis.field_72339_c) - beam.initLoc.field_72449_c) * invSlope.field_72449_c;
        double tzMax = ((signZ ? axis.field_72339_c : axis.field_72334_f) - beam.initLoc.field_72449_c) * invSlope.field_72449_c;
        if (txMin > txMax || tyMin > txMax) {
            return false;
        }
        if (tyMin > txMin) {
            txMin = tyMin;
        }
        if (tyMax < txMax) {
            txMax = tyMax;
        }
        if (txMin > tzMax || tzMin > txMax) {
            return false;
        }
        if (tzMin > txMin) {
            txMin = tzMin;
        }
        if (tzMax < txMax) {
            txMax = tzMax;
        }
        return true;
    }

    public void generateEffects() {
        if (this.world.get() != null) {
            for (BlockPos pos : this.locations.keySet()) {
                for (Beam beam : this.locations.get((Object)pos)) {
                    EffectTracker.addEffect((World)this.world.get(), new Vec3d((Vec3i)pos), EffectTracker.getEffect(beam));
                }
            }
        }
        this.locations.clear();
    }
}

