/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.refraction.api.beam;

import com.teamwizardry.librarianlib.common.network.PacketHandler;
import com.teamwizardry.refraction.api.ConfigValues;
import com.teamwizardry.refraction.api.Utils;
import com.teamwizardry.refraction.api.beam.BeamHitEntityEvent;
import com.teamwizardry.refraction.api.beam.BeamHitEvent;
import com.teamwizardry.refraction.api.beam.Effect;
import com.teamwizardry.refraction.api.beam.EffectTracker;
import com.teamwizardry.refraction.api.beam.IBeamHandler;
import com.teamwizardry.refraction.api.beam.IReflectiveArmor;
import com.teamwizardry.refraction.api.beam.modes.BeamMode;
import com.teamwizardry.refraction.api.beam.modes.BeamModeRegistry;
import com.teamwizardry.refraction.api.beam.modes.ModeEffect;
import com.teamwizardry.refraction.api.raytrace.EntityTrace;
import com.teamwizardry.refraction.common.network.PacketBeamParticle1;
import com.teamwizardry.refraction.common.network.PacketBeamParticle2;
import java.awt.Color;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Beam
implements INBTSerializable<NBTTagCompound> {
    @NotNull
    public BeamMode mode = BeamModeRegistry.NONE;
    public Vec3d initLoc;
    public Vec3d slope;
    public Vec3d finalLoc;
    @NotNull
    public Color color = Color.WHITE;
    @NotNull
    public World world;
    @Nullable
    public Effect effect;
    public boolean ignoreEntities = false;
    public RayTraceResult trace;
    public double range = ConfigValues.BEAM_RANGE;
    public int bouncedTimes = 0;
    public int allowedBounceTimes = ConfigValues.BEAM_BOUNCE_LIMIT;
    public boolean enableParticleBeginning = false;
    public boolean enableParticleEnd;
    @Nullable
    public UUID uuidToSkip;
    @Nullable
    public Entity caster;
    public String customName = "";

    public Beam(@NotNull World world, @NotNull Vec3d initLoc, @NotNull Vec3d slope, @NotNull Color color) {
        this.world = world;
        this.initLoc = initLoc;
        this.slope = slope;
        this.finalLoc = slope.func_72432_b().func_186678_a(128.0).func_178787_e(initLoc);
        this.color = color;
    }

    public Beam(World world, double initX, double initY, double initZ, double slopeX, double slopeY, double slopeZ, Color color) {
        this(world, new Vec3d(initX, initY, initZ), new Vec3d(slopeX, slopeY, slopeZ), color);
    }

    public Beam(World world, double initX, double initY, double initZ, double slopeX, double slopeY, double slopeZ, float red, float green, float blue, float alpha) {
        this(world, initX, initY, initZ, slopeX, slopeY, slopeZ, new Color(red, green, blue, alpha));
    }

    public Beam(NBTTagCompound compound) {
        this.deserializeNBT(compound);
    }

    public boolean doBeamsMatch(Beam beam) {
        return beam.color.getRGB() == this.color.getRGB() && beam.slope.field_72450_a == this.slope.field_72450_a && beam.slope.field_72448_b == this.slope.field_72448_b && beam.slope.field_72449_c == this.slope.field_72449_c && beam.initLoc.field_72450_a == this.initLoc.field_72450_a && beam.initLoc.field_72448_b == this.initLoc.field_72448_b && beam.initLoc.field_72449_c == this.initLoc.field_72449_c && beam.enableParticleEnd == this.enableParticleEnd && beam.enableParticleBeginning == this.enableParticleBeginning && beam.ignoreEntities == this.ignoreEntities && beam.allowedBounceTimes == this.allowedBounceTimes && beam.bouncedTimes == this.bouncedTimes && beam.range == this.range && beam.mode.equals(this.mode);
    }

    public Beam createSimilarBeam() {
        return this.createSimilarBeam(this.initLoc, this.finalLoc);
    }

    public Beam createSimilarBeam(Color color) {
        return this.createSimilarBeam(this.initLoc, this.finalLoc, color);
    }

    public Beam createSimilarBeam(Vec3d slope) {
        return this.createSimilarBeam(this.finalLoc, slope);
    }

    public Beam createSimilarBeam(Vec3d init, Vec3d dir) {
        return this.createSimilarBeam(init, dir, this.color);
    }

    public Beam createSimilarBeam(Vec3d init, Vec3d dir, Color color) {
        return new Beam(this.world, init, dir, color).setIgnoreEntities(this.ignoreEntities).setAllowedBounceTimes(this.allowedBounceTimes).setBouncedTimes(this.bouncedTimes).incrementBouncedTimes().setMode(this.mode).setRange(this.range).setCaster(this.caster);
    }

    public Beam setMode(@NotNull BeamMode mode) {
        this.mode = mode;
        return this;
    }

    public Beam setName(@NotNull String name) {
        this.customName = name;
        return this;
    }

    public Beam setCaster(@Nullable Entity caster) {
        this.caster = caster;
        return this;
    }

    public Beam setUUIDToSkip(UUID uuidToSkip) {
        this.uuidToSkip = uuidToSkip;
        return this;
    }

    public Beam enableParticleBeginning() {
        this.enableParticleBeginning = true;
        return this;
    }

    public Beam enableParticleEnd() {
        this.enableParticleEnd = true;
        return this;
    }

    public Beam setBouncedTimes(int bouncedTimes) {
        this.bouncedTimes = bouncedTimes;
        return this;
    }

    public Beam setAllowedBounceTimes(int allowedBounceTimes) {
        this.allowedBounceTimes = allowedBounceTimes;
        return this;
    }

    public Beam setSlope(@NotNull Vec3d slope) {
        this.slope = slope;
        this.finalLoc = slope.func_72432_b().func_186678_a(128.0).func_178787_e(this.initLoc);
        return this;
    }

    public Beam incrementBouncedTimes() {
        ++this.bouncedTimes;
        return this;
    }

    public Beam setColor(@NotNull Color color) {
        this.color = color;
        return this;
    }

    public Beam setIgnoreEntities(boolean ignoreEntities) {
        this.ignoreEntities = ignoreEntities;
        return this;
    }

    public Beam setInitLoc(@NotNull Vec3d initLoc) {
        this.initLoc = initLoc;
        this.finalLoc = this.slope.func_72432_b().func_186678_a(128.0).func_178787_e(initLoc);
        return this;
    }

    public Beam setEffect(@Nullable Effect effect) {
        this.effect = effect;
        return this;
    }

    public Beam setRange(double range) {
        this.range = range;
        return this;
    }

    private Beam initializeVariables() {
        if (this.effect == null && this.mode instanceof ModeEffect) {
            Effect tempEffect = EffectTracker.getEffect(this);
            if (tempEffect != null) {
                this.effect = tempEffect;
            }
        } else if (this.effect != null && !(this.mode instanceof ModeEffect)) {
            this.effect = null;
        }
        EntityTrace entityTrace = new EntityTrace(this.world, this.initLoc, this.slope).setUUIDToSkip(this.uuidToSkip).setRange(this.range);
        this.trace = this.ignoreEntities || this.effect != null && this.effect.getType() == Effect.EffectType.BEAM ? entityTrace.setIgnoreEntities(true).cast() : entityTrace.setIgnoreEntities(false).cast();
        if (this.trace != null && this.trace.field_72307_f != null) {
            this.finalLoc = this.trace.field_72307_f;
        }
        return this;
    }

    public void spawn() {
        BlockPos pos;
        if (this.world.field_72995_K) {
            return;
        }
        if (this.color.getAlpha() <= 1) {
            return;
        }
        if (this.bouncedTimes > this.allowedBounceTimes) {
            return;
        }
        this.initializeVariables();
        if (this.trace == null) {
            return;
        }
        if (this.trace.field_72307_f == null) {
            return;
        }
        if (this.finalLoc == null) {
            return;
        }
        boolean pass = true;
        boolean traceCompleted = false;
        int tries = 0;
        while (!traceCompleted && tries < 100) {
            ++tries;
            if (this.trace == null) {
                return;
            }
            if (this.trace.field_72313_a == RayTraceResult.Type.BLOCK) {
                pos = this.trace.func_178782_a();
                IBlockState state = this.world.func_180495_p(pos);
                BeamHitEvent event = new BeamHitEvent(this.world, this, pos, state);
                MinecraftForge.EVENT_BUS.post((Event)event);
                if (event.getResult() == Event.Result.DEFAULT) {
                    traceCompleted = true;
                    if (state.func_177230_c() instanceof IBeamHandler) {
                        traceCompleted = ((IBeamHandler)state.func_177230_c()).handleBeam(this.world, pos, this);
                        pass = false;
                    }
                } else {
                    traceCompleted = event.getResult() == Event.Result.DENY;
                    pass = event.getResult() == Event.Result.ALLOW;
                }
            } else {
                boolean bl = traceCompleted = this.trace.field_72313_a != RayTraceResult.Type.ENTITY || !MinecraftForge.EVENT_BUS.post((Event)new BeamHitEntityEvent(this.world, this, this.trace.field_72308_g));
            }
            if (traceCompleted) continue;
            traceCompleted = this.recast();
        }
        if (this.mode instanceof ModeEffect && this.effect != null) {
            if (this.effect.getType() == Effect.EffectType.BEAM) {
                EffectTracker.addEffect(this.world, this);
            } else if (pass && this.effect.getType() == Effect.EffectType.SINGLE) {
                if (this.trace.field_72313_a != RayTraceResult.Type.MISS) {
                    EffectTracker.addEffect(this.world, this.trace.field_72307_f, this.effect);
                } else if (this.trace.field_72313_a == RayTraceResult.Type.BLOCK) {
                    pos = this.trace.func_178782_a();
                    EffectTracker.addEffect(this.world, new Vec3d((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5), this.effect);
                }
            }
        }
        if (this.trace.field_72313_a == RayTraceResult.Type.ENTITY && this.trace.field_72308_g instanceof EntityLivingBase) {
            EntityLivingBase entity = (EntityLivingBase)this.trace.field_72308_g;
            boolean flag = true;
            for (ItemStack armor : entity.func_184193_aE()) {
                if (armor == null) {
                    flag = false;
                    break;
                }
                if (armor.func_77973_b() instanceof IReflectiveArmor) continue;
                flag = false;
                break;
            }
            if (flag) {
                this.createSimilarBeam(entity.func_70676_i(1.0f)).setUUIDToSkip(entity.func_110124_au()).enableParticleBeginning().spawn();
            }
        }
        Utils.HANDLER.fireLaserPacket(this);
        if (this.enableParticleBeginning) {
            if (ThreadLocalRandom.current().nextInt(10) == 0) {
                PacketHandler.NETWORK.sendToAllAround((IMessage)new PacketBeamParticle1(this.initLoc, this.color), new NetworkRegistry.TargetPoint(this.world.field_73011_w.getDimension(), this.initLoc.field_72450_a, this.initLoc.field_72448_b, this.initLoc.field_72449_c, 30.0));
            }
            if (ThreadLocalRandom.current().nextInt(100) == 0) {
                PacketHandler.NETWORK.sendToAllAround((IMessage)new PacketBeamParticle2(this.initLoc, this.color), new NetworkRegistry.TargetPoint(this.world.field_73011_w.getDimension(), this.initLoc.field_72450_a, this.initLoc.field_72448_b, this.initLoc.field_72449_c, 30.0));
            }
        }
        if (this.trace.field_72307_f != null && this.enableParticleEnd) {
            if (ThreadLocalRandom.current().nextInt(10) == 0) {
                PacketHandler.NETWORK.sendToAllAround((IMessage)new PacketBeamParticle1(this.finalLoc, this.color), new NetworkRegistry.TargetPoint(this.world.field_73011_w.getDimension(), this.finalLoc.field_72450_a, this.finalLoc.field_72448_b, this.finalLoc.field_72449_c, 30.0));
            }
            if (ThreadLocalRandom.current().nextInt(100) == 0) {
                PacketHandler.NETWORK.sendToAllAround((IMessage)new PacketBeamParticle2(this.finalLoc, this.color), new NetworkRegistry.TargetPoint(this.world.field_73011_w.getDimension(), this.finalLoc.field_72450_a, this.finalLoc.field_72448_b, this.finalLoc.field_72449_c, 30.0));
            }
        }
    }

    private boolean recast() {
        EntityTrace entityTrace = new EntityTrace(this.world, this).setUUIDToSkip(this.uuidToSkip);
        if (entityTrace.range <= 0.0) {
            return true;
        }
        this.trace = entityTrace.rayTraceResult != null ? entityTrace.rayTraceResult : (this.ignoreEntities || this.effect != null && this.effect.getType() == Effect.EffectType.BEAM ? entityTrace.setIgnoreEntities(true).cast() : entityTrace.setIgnoreEntities(false).cast());
        if (this.trace != null && this.trace.field_72307_f != null) {
            this.finalLoc = this.trace.field_72307_f;
        }
        return false;
    }

    public boolean equals(Object other) {
        return super.equals(other);
    }

    public int hashCode() {
        return super.hashCode();
    }

    public NBTTagCompound serializeNBT() {
        NBTTagCompound compound = new NBTTagCompound();
        compound.func_74780_a("init_loc_x", this.initLoc.field_72450_a);
        compound.func_74780_a("init_loc_y", this.initLoc.field_72448_b);
        compound.func_74780_a("init_loc_z", this.initLoc.field_72449_c);
        compound.func_74780_a("slope_x", this.slope.field_72450_a);
        compound.func_74780_a("slope_y", this.slope.field_72448_b);
        compound.func_74780_a("slope_z", this.slope.field_72449_c);
        compound.func_74768_a("color", this.color.getRGB());
        compound.func_74768_a("world", this.world.field_73011_w.getDimension());
        compound.func_74768_a("bounce_times", this.bouncedTimes);
        compound.func_74768_a("allowed_bounce_times", this.allowedBounceTimes);
        compound.func_74780_a("range", this.range);
        compound.func_74778_a("name", this.customName);
        compound.func_74757_a("ignore_entities", this.ignoreEntities);
        compound.func_74757_a("enable_particle_beginning", this.enableParticleBeginning);
        compound.func_74757_a("enable_particle_end", this.enableParticleEnd);
        compound.func_74778_a("mode", this.mode.getName());
        if (this.uuidToSkip != null) {
            compound.func_186854_a("uuid_to_skip", this.uuidToSkip);
        }
        return compound;
    }

    public void deserializeNBT(NBTTagCompound nbt) {
        if (!nbt.func_74764_b("world")) {
            throw new NullPointerException("'world' key not found or missing in deserialized beam object.");
        }
        this.world = FMLCommonHandler.instance().getMinecraftServerInstance().func_71218_a(nbt.func_74762_e("dim"));
        if (!(nbt.func_74764_b("init_loc_x") && nbt.func_74764_b("init_loc_y") && nbt.func_74764_b("init_loc_z"))) {
            throw new NullPointerException("'init_loc' key not found or missing in deserialized beam object.");
        }
        this.initLoc = new Vec3d(nbt.func_74769_h("init_loc_x"), nbt.func_74769_h("init_loc_y"), nbt.func_74769_h("init_loc_z"));
        if (!(nbt.func_74764_b("slope_x") && nbt.func_74764_b("slope_y") && nbt.func_74764_b("slope_z"))) {
            throw new NullPointerException("'slope' key not found or missing in deserialized beam object.");
        }
        this.slope = new Vec3d(nbt.func_74769_h("slope_x"), nbt.func_74769_h("slope_y"), nbt.func_74769_h("slope_z"));
        this.finalLoc = this.slope.func_72432_b().func_186678_a(128.0).func_178787_e(this.initLoc);
        if (!nbt.func_74764_b("color")) {
            throw new NullPointerException("'color' or 'color_alpha' keys not found or missing in deserialized beam object.");
        }
        this.color = new Color(nbt.func_74762_e("color"), true);
        if (nbt.func_74764_b("name")) {
            this.customName = nbt.func_74779_i("name");
        }
        if (nbt.func_74764_b("uuid_to_skip")) {
            this.uuidToSkip = nbt.func_186857_a("uuid_to_skip");
        }
        if (nbt.func_74764_b("ignore_entities")) {
            this.ignoreEntities = nbt.func_74767_n("ignore_entities");
        }
        if (nbt.func_74764_b("range")) {
            this.range = nbt.func_74769_h("range");
        }
        if (nbt.func_74764_b("bounce_times")) {
            this.bouncedTimes = nbt.func_74762_e("bounce_times");
        }
        if (nbt.func_74764_b("allowed_bounce_times")) {
            this.allowedBounceTimes = nbt.func_74762_e("allowed_bounce_times");
        }
        if (nbt.func_74764_b("enable_particle_beginning")) {
            this.enableParticleBeginning = nbt.func_74767_n("enable_particle_beginning");
        }
        this.mode = BeamModeRegistry.getMode(nbt.func_74779_i("mode"));
        if (nbt.func_74764_b("enable_particle_end")) {
            this.enableParticleEnd = nbt.func_74767_n("enable_particle_end");
        }
    }
}

