/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.refraction.api;

import com.teamwizardry.refraction.api.internal.DummyInternalHandler;
import com.teamwizardry.refraction.api.internal.IInternalHandler;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.oredict.OreDictionary;
import org.jetbrains.annotations.Nullable;

public final class Utils {
    public static IInternalHandler HANDLER = new DummyInternalHandler();

    public static Color getColorFromDyeEnum(EnumDyeColor dye) {
        switch (dye) {
            case WHITE: {
                return Color.WHITE;
            }
            case ORANGE: {
                return Color.ORANGE;
            }
            case MAGENTA: {
                return Color.MAGENTA;
            }
            case LIGHT_BLUE: {
                return new Color(11393254);
            }
            case YELLOW: {
                return Color.YELLOW;
            }
            case LIME: {
                return new Color(3329330);
            }
            case PINK: {
                return Color.PINK;
            }
            case GRAY: {
                return Color.GRAY;
            }
            case SILVER: {
                return new Color(0xD3D3D3);
            }
            case CYAN: {
                return Color.CYAN;
            }
            case PURPLE: {
                return new Color(10494192);
            }
            case BLUE: {
                return Color.BLUE;
            }
            case BROWN: {
                return new Color(9127187);
            }
            case GREEN: {
                return Color.GREEN;
            }
            case RED: {
                return Color.RED;
            }
            case BLACK: {
                return Color.BLACK;
            }
        }
        return Color.WHITE;
    }

    public static boolean doColorsMatchNoAlpha(Color color1, Color color2) {
        return color1.getRed() == color2.getRed() && color1.getGreen() == color2.getGreen() && color1.getBlue() == color2.getBlue();
    }

    public static Color mixColors(Color color1, Color color2, double percent) {
        double inverse_percent = 1.0 - percent;
        double redPart = (double)color1.getRed() * percent + (double)color2.getRed() * inverse_percent;
        double greenPart = (double)color1.getGreen() * percent + (double)color2.getGreen() * inverse_percent;
        double bluePart = (double)color1.getBlue() * percent + (double)color2.getBlue() * inverse_percent;
        double alphaPart = (double)color1.getAlpha() * percent + (double)color2.getAlpha() * inverse_percent;
        return new Color((int)redPart, (int)greenPart, (int)bluePart, (int)alphaPart);
    }

    public static EnumFacing getCollisionSide(RayTraceResult trace) {
        if (trace != null && trace.field_72313_a == RayTraceResult.Type.BLOCK) {
            BlockPos pos = trace.func_178782_a();
            Vec3d hitPos = trace.field_72307_f;
            Vec3d center = new Vec3d((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5);
            Vec3d dir = hitPos.func_178788_d(center);
            return EnumFacing.func_176737_a((float)((float)dir.field_72450_a), (float)((float)dir.field_72448_b), (float)((float)dir.field_72449_c));
        }
        return null;
    }

    public static boolean matchItemStackLists(List<ItemStack> items, List<Object> required) {
        ArrayList<Object> inputsMissing = new ArrayList<Object>(required);
        block0: for (ItemStack i : items) {
            for (int j = 0; j < inputsMissing.size(); ++j) {
                Object inp = inputsMissing.get(j);
                if (inp == null) continue;
                if (inp instanceof ItemStack && ((ItemStack)inp).func_77952_i() == Short.MAX_VALUE) {
                    ((ItemStack)inp).func_77964_b(i.func_77952_i());
                }
                if (inp instanceof List) {
                    for (Object obj : (List)inp) {
                        if (obj instanceof ItemStack && ((ItemStack)obj).func_77952_i() == Short.MAX_VALUE) {
                            ((ItemStack)obj).func_77964_b(i.func_77952_i());
                        }
                        if (!Utils.itemEquals(i, obj)) continue;
                        inputsMissing.remove(j);
                        continue block0;
                    }
                }
                if (!Utils.itemEquals(i, inp)) continue;
                inputsMissing.remove(j);
                continue block0;
            }
        }
        return inputsMissing.isEmpty();
    }

    public static boolean matchItemLists(List<ItemStack> items, List<Object> required) {
        ArrayList<Object> inputsMissing = new ArrayList<Object>(required);
        block0: for (ItemStack i : items) {
            for (int j = 0; j < inputsMissing.size(); ++j) {
                Object inp = inputsMissing.get(j);
                if (inp == null) continue;
                if (inp instanceof ItemStack && ((ItemStack)inp).func_77952_i() == Short.MAX_VALUE) {
                    ((ItemStack)inp).func_77964_b(i.func_77952_i());
                }
                if (inp instanceof List) {
                    for (Object obj : (List)inp) {
                        if (obj instanceof ItemStack && ((ItemStack)obj).func_77952_i() == Short.MAX_VALUE) {
                            ((ItemStack)obj).func_77964_b(i.func_77952_i());
                        }
                        if (!Utils.itemEqualsItemsOnly(i, obj)) continue;
                        inputsMissing.remove(j);
                        continue block0;
                    }
                }
                if (!Utils.itemEqualsItemsOnly(i, inp)) continue;
                inputsMissing.remove(j);
                continue block0;
            }
        }
        return inputsMissing.isEmpty();
    }

    public static boolean itemEqualsItemsOnly(ItemStack stack, Object stack2) {
        if (stack2 instanceof String) {
            for (ItemStack orestack : OreDictionary.getOres((String)((String)stack2))) {
                ItemStack cstack = orestack.func_77946_l();
                if (cstack.func_77952_i() == Short.MAX_VALUE) {
                    cstack.func_77964_b(stack.func_77952_i());
                }
                if (!stack.func_77969_a(cstack)) continue;
                return true;
            }
        } else if (stack2 instanceof ItemStack) {
            for (int oreID : OreDictionary.getOreIDs((ItemStack)((ItemStack)stack2))) {
                for (ItemStack orestack : OreDictionary.getOres((String)OreDictionary.getOreName((int)oreID))) {
                    ItemStack cstack = orestack.func_77946_l();
                    if (cstack.func_77952_i() == Short.MAX_VALUE) {
                        cstack.func_77964_b(stack.func_77952_i());
                    }
                    if (!stack.func_77969_a(cstack)) continue;
                    return true;
                }
            }
            return Utils.simpleAreItemsEqual(stack, (ItemStack)stack2);
        }
        return false;
    }

    public static boolean itemEquals(ItemStack stack, Object stack2) {
        if (stack2 instanceof String) {
            for (ItemStack orestack : OreDictionary.getOres((String)((String)stack2))) {
                ItemStack cstack = orestack.func_77946_l();
                if (cstack.func_77952_i() == Short.MAX_VALUE) {
                    cstack.func_77964_b(stack.func_77952_i());
                }
                if (!stack.func_77969_a(cstack)) continue;
                return true;
            }
        } else if (stack2 instanceof ItemStack) {
            for (int oreID : OreDictionary.getOreIDs((ItemStack)((ItemStack)stack2))) {
                for (ItemStack orestack : OreDictionary.getOres((String)OreDictionary.getOreName((int)oreID))) {
                    ItemStack cstack = orestack.func_77946_l();
                    if (cstack.func_77952_i() == Short.MAX_VALUE) {
                        cstack.func_77964_b(stack.func_77952_i());
                    }
                    if (!stack.func_77969_a(cstack)) continue;
                    return true;
                }
            }
            return Utils.simpleAreStacksEqual(stack, (ItemStack)stack2);
        }
        return false;
    }

    public static boolean simpleAreItemsEqual(ItemStack stack, ItemStack stack2) {
        return stack.func_77973_b() == stack2.func_77973_b();
    }

    public static boolean simpleAreStacksEqual(ItemStack stack, ItemStack stack2) {
        return stack.func_77973_b() == stack2.func_77973_b() && stack.func_77952_i() == stack2.func_77952_i();
    }

    public static double getColorDistance(Color one, Color two) {
        if (one == null || two == null) {
            return Double.MAX_VALUE;
        }
        double meanRed = (double)(one.getRed() + two.getRed()) / 2.0;
        int r = one.getRed() - two.getRed();
        int g = one.getGreen() - two.getGreen();
        int b = one.getBlue() - two.getBlue();
        double weightR = 2.0 + meanRed / 256.0;
        double weightG = 4.0;
        double weightB = 2.0 + (255.0 - meanRed) / 256.0;
        return weightR * (double)r * (double)r + weightG * (double)g * (double)g + weightB * (double)b * (double)b;
    }

    @Nullable
    public static ItemStack getStackFromString(String itemId) {
        Block block;
        ResourceLocation location = new ResourceLocation(itemId);
        ItemStack stack = null;
        if (ForgeRegistries.ITEMS.containsKey(location)) {
            Item item = (Item)ForgeRegistries.ITEMS.getValue(location);
            if (item != null) {
                stack = new ItemStack(item);
            }
        } else if (ForgeRegistries.BLOCKS.containsKey(location) && (block = (Block)ForgeRegistries.BLOCKS.getValue(location)) != null) {
            stack = new ItemStack(block);
        }
        return stack;
    }
}

