/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.refraction.api;

import java.util.List;
import net.minecraft.util.math.Vec3d;

public final class RotationHelper {
    public static Vec3d toVec3d(float pitch, float yaw) {
        double sinPitch = Math.sin(pitch);
        double cosPitch = Math.cos(pitch);
        double sinYaw = Math.sin(yaw);
        double cosYaw = Math.cos(yaw);
        return new Vec3d(cosPitch * cosYaw, sinPitch, cosPitch * sinYaw);
    }

    public static Vec3d toSpherical(Vec3d vec) {
        double x = vec.field_72450_a;
        double y = vec.field_72448_b;
        double z = vec.field_72449_c;
        double radius = Math.sqrt(x * x + y * y + z * z);
        double theta = Math.atan2(z, x);
        double phi = Math.atan2(Math.sqrt(x * x + z * z), y);
        return new Vec3d(radius, theta, phi);
    }

    public static Vec3d averageDirection(List<Vec3d> vectors) {
        if (vectors == null) {
            return Vec3d.field_186680_a;
        }
        if (vectors.isEmpty()) {
            return Vec3d.field_186680_a;
        }
        double x = 0.0;
        double y = 0.0;
        double z = 0.0;
        for (Vec3d vec : vectors) {
            if (vec == null) continue;
            vec.func_72432_b();
            x += vec.field_72450_a;
            y += vec.field_72448_b;
            z += vec.field_72449_c;
        }
        return new Vec3d(x, y, z);
    }

    public static Vec3d reflectLine(Vec3d vector, Vec3d line) {
        line = line.func_72432_b();
        return vector.func_186678_a(-1.0).func_178787_e(line.func_186678_a(2.0 * vector.func_72430_b(line)));
    }

    public static Vec3d reflectPlane(Vec3d vector, Vec3d normal) {
        normal = normal.func_72432_b();
        return vector.func_178788_d(normal.func_186678_a(vector.func_72430_b(normal) * 2.0));
    }

    public static Vec3d rotateAroundVector(Vec3d vector, Vec3d axis, float angle) {
        double cos = Math.cos((double)angle * Math.PI / 180.0);
        double sin = Math.sin((double)angle * Math.PI / 180.0);
        Vec3d cross = vector.func_72431_c(axis);
        return vector.func_186678_a(cos).func_178787_e(cross.func_186678_a(sin)).func_178787_e(axis.func_186678_a(axis.func_72430_b(vector)).func_186678_a(1.0 - cos));
    }
}

