/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.refraction.api;

import com.google.common.collect.HashMultimap;
import com.teamwizardry.librarianlib.common.base.block.TileMod;
import com.teamwizardry.refraction.api.beam.Beam;
import com.teamwizardry.refraction.api.beam.modes.BeamMode;
import java.awt.Color;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ITickable;
import org.jetbrains.annotations.NotNull;

public class MultipleBeamTile
extends TileMod
implements ITickable {
    @NotNull
    public HashMultimap<BeamMode, Beam> beamData = HashMultimap.create();
    @NotNull
    public Set<Beam> beams = new HashSet<Beam>();

    public void readCustomNBT(NBTTagCompound compound) {
        this.beams.clear();
        NBTTagList array1 = compound.func_150295_c("beams", 10);
        for (int i = 0; i < array1.func_74745_c(); ++i) {
            Beam beam = new Beam(array1.func_150305_b(i));
            this.beams.add(beam);
        }
    }

    public void writeCustomNBT(NBTTagCompound compound, boolean sync) {
        if (!this.beams.isEmpty()) {
            NBTTagList array = new NBTTagList();
            for (Beam beam : this.beams) {
                array.func_74742_a((NBTBase)beam.serializeNBT());
            }
            compound.func_74782_a("beams", (NBTBase)array);
        }
    }

    public Color mergeColors(Set<Color> colors) {
        Color color2;
        int red = 0;
        int green = 0;
        int blue = 0;
        int alpha = 0;
        for (Color color2 : colors) {
            double colorCount = 0.0;
            if (color2.getRed() > 0) {
                colorCount += 1.0;
            }
            if (color2.getGreen() > 0) {
                colorCount += 1.0;
            }
            if (color2.getBlue() > 0) {
                colorCount += 1.0;
            }
            if (colorCount <= 0.0) continue;
            red = (int)((double)red + (double)((float)(color2.getRed() * color2.getAlpha()) / 255.0f) / colorCount);
            green = (int)((double)green + (double)((float)(color2.getGreen() * color2.getAlpha()) / 255.0f) / colorCount);
            blue = (int)((double)blue + (double)((float)(color2.getBlue() * color2.getAlpha()) / 255.0f) / colorCount);
            alpha += color2.getAlpha();
        }
        if (!colors.isEmpty()) {
            red = Math.min(red / colors.size(), 255);
            green = Math.min(green / colors.size(), 255);
            blue = Math.min(blue / colors.size(), 255);
        }
        float[] hsbvals = Color.RGBtoHSB(red, green, blue, null);
        color2 = new Color(Color.HSBtoRGB(hsbvals[0], hsbvals[1], 1.0f));
        return new Color(color2.getRed(), color2.getGreen(), color2.getBlue(), Math.min(alpha, 255));
    }

    public Color mergeColors(BeamMode mode) {
        int red = 0;
        int green = 0;
        int blue = 0;
        int alpha = 0;
        Set beamSet = this.beamData.get((Object)mode);
        for (Beam beam : beamSet) {
            Color color = beam.color;
            double colorCount = 0.0;
            if (color.getRed() > 0) {
                colorCount += 1.0;
            }
            if (color.getGreen() > 0) {
                colorCount += 1.0;
            }
            if (color.getBlue() > 0) {
                colorCount += 1.0;
            }
            if (colorCount <= 0.0) continue;
            red = (int)((double)red + (double)((float)(color.getRed() * color.getAlpha()) / 255.0f) / colorCount);
            green = (int)((double)green + (double)((float)(color.getGreen() * color.getAlpha()) / 255.0f) / colorCount);
            blue = (int)((double)blue + (double)((float)(color.getBlue() * color.getAlpha()) / 255.0f) / colorCount);
            alpha += color.getAlpha();
        }
        red = Math.min(red / beamSet.size(), 255);
        green = Math.min(green / beamSet.size(), 255);
        blue = Math.min(blue / beamSet.size(), 255);
        float[] hsbvals = Color.RGBtoHSB(red, green, blue, null);
        Color color = new Color(Color.HSBtoRGB(hsbvals[0], hsbvals[1], 1.0f));
        return new Color(color.getRed(), color.getGreen(), color.getBlue(), Math.min(alpha, 255));
    }

    public void handleBeam(Beam beam) {
        this.beams.add(beam);
        this.func_70296_d();
    }

    protected void purge() {
        this.beams.clear();
        this.beamData.clear();
        this.func_70296_d();
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K && !this.beams.isEmpty()) {
            for (Beam beam : this.beams) {
                this.beamData.put((Object)beam.mode, (Object)beam);
            }
            this.func_70296_d();
        }
    }
}

