/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.refraction.api;

import com.teamwizardry.refraction.api.IAmmo;
import com.teamwizardry.refraction.api.Utils;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface IAmmoConsumer {
    @NotNull
    public static List<ItemStack> findAllAmmo(EntityPlayer player) {
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        if (IAmmoConsumer.isAmmo(player.func_184586_b(EnumHand.OFF_HAND))) {
            stacks.add(player.func_184586_b(EnumHand.OFF_HAND));
        }
        if (IAmmoConsumer.isAmmo(player.func_184586_b(EnumHand.MAIN_HAND))) {
            stacks.add(player.func_184586_b(EnumHand.MAIN_HAND));
        }
        for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
            ItemStack itemstack = player.field_71071_by.func_70301_a(i);
            if (!IAmmoConsumer.isAmmo(itemstack)) continue;
            stacks.add(itemstack);
        }
        return stacks;
    }

    @NotNull
    public static List<ItemStack> findAllAmmo(EntityPlayer player, Color color) {
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        if (IAmmoConsumer.isAmmo(player.func_184586_b(EnumHand.OFF_HAND), color)) {
            stacks.add(player.func_184586_b(EnumHand.OFF_HAND));
        }
        if (IAmmoConsumer.isAmmo(player.func_184586_b(EnumHand.MAIN_HAND), color)) {
            stacks.add(player.func_184586_b(EnumHand.MAIN_HAND));
        }
        for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
            ItemStack itemstack = player.field_71071_by.func_70301_a(i);
            if (!IAmmoConsumer.isAmmo(itemstack, color)) continue;
            stacks.add(itemstack);
        }
        return stacks;
    }

    @Nullable
    public static ItemStack findAmmo(EntityPlayer player, Color color) {
        if (IAmmoConsumer.isAmmo(player.func_184586_b(EnumHand.OFF_HAND), color)) {
            return player.func_184586_b(EnumHand.OFF_HAND);
        }
        if (IAmmoConsumer.isAmmo(player.func_184586_b(EnumHand.MAIN_HAND), color)) {
            return player.func_184586_b(EnumHand.MAIN_HAND);
        }
        for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
            ItemStack itemstack = player.field_71071_by.func_70301_a(i);
            if (!IAmmoConsumer.isAmmo(itemstack, color)) continue;
            return itemstack;
        }
        return null;
    }

    public static boolean isAmmo(@Nullable ItemStack stack) {
        return stack != null && stack.func_77973_b() instanceof IAmmo && ((IAmmo)stack.func_77973_b()).hasColor(stack) && ((IAmmo)stack.func_77973_b()).drain(stack, 1, true);
    }

    public static boolean isAmmo(@Nullable ItemStack stack, Color color) {
        return IAmmoConsumer.isAmmo(stack) && Utils.doColorsMatchNoAlpha(color, new Color(((IAmmo)stack.func_77973_b()).getInternalColor(stack)));
    }
}

