/*
 * Decompiled with CFR 0.152.
 */
package com.dmfmm.extrafood.worldgen.spawn;

import com.dmfmm.extrafood.worldgen.gen.BananaTreeGenerator;
import com.dmfmm.extrafood.worldgen.gen.OliveTreeGenerator;
import com.dmfmm.extrafood.worldgen.gen.OrangeTreeGenerator;
import java.util.Random;
import net.minecraft.init.Biomes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.IChunkGenerator;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraftforge.fml.common.IWorldGenerator;

public class TreeSpawner
implements IWorldGenerator {
    public static TreeSpawner INSTANCE = new TreeSpawner();

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        switch (world.field_73011_w.getDimension()) {
            case -1: {
                this.generateNether(world, random, chunkX * 16, chunkZ * 16);
            }
            case 0: {
                this.generateSurface(world, random, chunkX * 16, chunkZ * 16);
            }
            case 1: {
                this.generateEnd(world, random, chunkX * 16, chunkZ * 16);
            }
        }
    }

    private void generateEnd(World world, Random random, int x, int z) {
    }

    private void generateSurface(World world, Random random, int x, int z) {
        for (int i = 0; i < 3; ++i) {
            int Xcoord1 = x + random.nextInt(16);
            int Ycoord1 = random.nextInt(89) + 49;
            int Zcoord1 = z + random.nextInt(16);
            Biome biome = world.func_180494_b(new BlockPos(Xcoord1, Ycoord1, Zcoord1));
            BlockPos blockPos = new BlockPos(Xcoord1, Ycoord1, Zcoord1);
            if (world.func_175623_d(blockPos.func_177984_a()) && world.func_175623_d(blockPos)) {
                new OrangeTreeGenerator().func_180709_b(world, random, new BlockPos(Xcoord1, Ycoord1, Zcoord1));
            }
            if (biome == Biomes.field_76782_w || biome == Biomes.field_150574_L || biome == Biomes.field_76792_x) {
                Xcoord1 = x + random.nextInt(16);
                Ycoord1 = random.nextInt(89) + 49;
                Zcoord1 = z + random.nextInt(16);
                new BananaTreeGenerator().func_180709_b(world, random, new BlockPos(Xcoord1, Ycoord1, Zcoord1));
                continue;
            }
            if (!this.shouldTreesSpawn(biome)) continue;
            Xcoord1 = x + random.nextInt(16);
            Ycoord1 = random.nextInt(89) + 49;
            Zcoord1 = z + random.nextInt(16);
            int rand = random.nextInt(100);
            if (rand <= 75) continue;
            new OliveTreeGenerator().func_180709_b(world, random, new BlockPos(Xcoord1, Ycoord1, Zcoord1));
        }
    }

    private void generateNether(World world, Random random, int x, int z) {
    }

    private boolean shouldTreesSpawn(Biome biome) {
        return biome != Biomes.field_150584_S && biome != Biomes.field_150579_T && biome != Biomes.field_150575_M && biome != Biomes.field_76769_d && biome != Biomes.field_76786_s && biome != Biomes.field_185431_ac && biome != Biomes.field_76781_i && biome != Biomes.field_150590_f && biome != Biomes.field_76771_b && biome != Biomes.field_76768_g && biome != Biomes.field_76784_u;
    }
}

