/*
 * Decompiled with CFR 0.152.
 */
package com.dmfmm.extrafood.worldgen.gen;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFlower;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraftforge.common.IPlantable;

public abstract class BaseTreeGenerator
extends WorldGenerator {
    public boolean func_180709_b(World worldIn, Random rand, BlockPos position) {
        int z;
        int x;
        int startz;
        int startx;
        int size;
        int treeHeight = this.getMaxTreeHeight() == this.getMinTreeHeight() ? this.getMinTreeHeight() : rand.nextInt(this.getMaxTreeHeight() - this.getMinTreeHeight()) + this.getMinTreeHeight();
        if (position.func_177956_o() < 1 || position.func_177956_o() > 255 - treeHeight) {
            return false;
        }
        for (int y = position.func_177956_o(); y < position.func_177956_o() + 1 + treeHeight; ++y) {
            for (int x2 = position.func_177958_n() - this.getLeavesWidthAndLength() / 2; x2 < position.func_177958_n() + this.getLeavesWidthAndLength() / 2; ++x2) {
                for (int z2 = position.func_177952_p() - this.getLeavesWidthAndLength() / 2; z2 < position.func_177952_p() + this.getLeavesWidthAndLength() / 2; ++z2) {
                    if (this.isReplaceable(worldIn, new BlockPos(x2, y, z2)) || worldIn.func_180495_p(new BlockPos(x2, y, z2)).func_177230_c() == Blocks.field_150329_H || worldIn.func_180495_p(new BlockPos(x2, y, z2)).func_177230_c() == Blocks.field_150398_cm || worldIn.func_180495_p(new BlockPos(x2, y, z2)).func_177230_c() instanceof BlockFlower) continue;
                    return false;
                }
            }
        }
        BlockPos down = position.func_177977_b();
        Block block = worldIn.func_180495_p(down).func_177230_c();
        if (!block.canSustainPlant(block.func_176194_O().func_177621_b(), (IBlockAccess)worldIn, down, EnumFacing.UP, (IPlantable)Blocks.field_150345_g)) {
            return false;
        }
        BlockPos head = new BlockPos((Vec3i)position);
        for (int i = 0; i < treeHeight; ++i) {
            worldIn.func_175656_a(head, this.getWoodBlock());
            head = head.func_177984_a();
        }
        float value = this.getLeavesWidthAndLength() / this.getLeavesCanopyHeight();
        float current = this.getLeavesWidthAndLength();
        int[] height = new int[this.getLeavesCanopyHeight() + 1];
        for (int i = 0; i < this.getLeavesCanopyHeight(); ++i) {
            height[i] = MathHelper.func_76123_f((float)current);
            if (height[i] % 2 == 0 && i != 0) {
                int n = i;
                height[n] = height[n] - 1;
            }
            if (!((current -= value) < 3.0f)) continue;
            current = 3.0f;
        }
        height[this.getLeavesCanopyHeight()] = 1;
        for (int leafLayer = 0; leafLayer < height.length - 1; ++leafLayer) {
            int layer = treeHeight - (height.length - leafLayer) + 2;
            size = height[leafLayer];
            startx = position.func_177958_n() - size / 2;
            startz = position.func_177952_p() - size / 2;
            for (x = 0; x < size; ++x) {
                for (z = 0; z < size; ++z) {
                    if ((x == 0 && z == 0 || x == size - 1 && z == 0 || x == size - 1 && z == size - 1 || z == size - 1 && x == 0) && rand.nextInt(8) < 7 && leafLayer % 2 == 0 || x + startx == position.func_177958_n() && z + startz == position.func_177952_p()) continue;
                    BlockPos blockPos = new BlockPos(x + startx, layer + position.func_177956_o(), z + startz);
                    boolean flag = false;
                    for (EnumFacing facing : EnumFacing.values()) {
                        if (worldIn.func_180495_p(blockPos.func_177972_a(facing)).func_177230_c() != this.getWoodBlock()) continue;
                        flag = true;
                    }
                    if (flag) {
                        worldIn.func_175656_a(blockPos, this.getLeafBlock());
                        continue;
                    }
                    worldIn.func_175656_a(blockPos, this.getLeafBlockWithoutCheckDecay());
                }
            }
        }
        BlockPos blockPos = position.func_177981_b(treeHeight);
        worldIn.func_175656_a(blockPos, this.getLeafBlock());
        if (this.hasHangingBlocks()) {
            int hangheight = treeHeight - this.getLeavesCanopyHeight();
            size = this.getLeavesWidthAndLength();
            startx = position.func_177958_n() - size / 2;
            startz = position.func_177952_p() - size / 2;
            for (x = 0; x < size; ++x) {
                block10: for (z = 0; z < size; ++z) {
                    head = new BlockPos(startx + x, hangheight + position.func_177956_o() + 1, startz + z);
                    if (worldIn.func_175623_d(head) || rand.nextInt(10) > 4) continue;
                    int tailheight = this.getMaximumHangingBlockHeight() == this.getMinimumHangingBlockHeight() ? this.getMaximumHangingBlockHeight() : rand.nextInt(this.getMaximumHangingBlockHeight() - this.getMinimumHangingBlockHeight()) + this.getMinimumHangingBlockHeight();
                    for (int i = 0; i < tailheight; ++i) {
                        if (worldIn.func_180495_p((head = head.func_177977_b()).func_177984_a()) != this.getLeafBlock()) continue;
                        if (this.hangingBlockOnEdgeOnly() && x != 0 && x != size - 1 && z != 0 && z != size - 1) continue block10;
                        worldIn.func_175656_a(head, this.getHangingBlock());
                    }
                }
            }
        }
        return true;
    }

    protected abstract IBlockState getLeafBlockWithoutCheckDecay();

    abstract IBlockState getHangingBlock();

    public int getMinimumHangingBlockHeight() {
        return 1;
    }

    public int getMaximumHangingBlockHeight() {
        return 1;
    }

    public boolean hangingBlockOnEdgeOnly() {
        return true;
    }

    abstract boolean hasHangingBlocks();

    abstract IBlockState getLeafBlock();

    abstract IBlockState getWoodBlock();

    public int getLeavesWidthAndLength() {
        return 5;
    }

    public int getLeavesCanopyHeight() {
        return 3;
    }

    public int getMinTreeHeight() {
        return 4;
    }

    public int getMaxTreeHeight() {
        return 7;
    }

    public boolean isReplaceable(World world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        return (state.func_177230_c().isAir(world.func_180495_p(pos), (IBlockAccess)world, pos) || state.func_177230_c().isLeaves(world.func_180495_p(pos), (IBlockAccess)world, pos) || state.func_177230_c().isWood((IBlockAccess)world, pos) || this.hasValidMaterialTypeForReplacing(state.func_177230_c())) && !this.invalidBlock(state.func_177230_c());
    }

    private boolean invalidBlock(Block block) {
        return false;
    }

    protected boolean hasValidMaterialTypeForReplacing(Block block) {
        Material material = block.func_149688_o(block.func_176194_O().func_177621_b());
        return material == Material.field_151579_a || material == Material.field_151584_j || block == Blocks.field_150364_r || block == Blocks.field_150363_s || block == Blocks.field_150345_g || block == Blocks.field_150395_bd || block == Blocks.field_150355_j || block == Blocks.field_150346_d || block == Blocks.field_150349_c;
    }
}

