/*
 * Decompiled with CFR 0.152.
 */
package com.dmfmm.extrafood.utilities;

import com.dmfmm.extrafood.init.FluidLoader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidContainerItem;

public class FluidContainerRegistryHelper {
    public static Map<Item, ArrayList<IFluidContainerItem>> specialCases = new HashMap<Item, ArrayList<IFluidContainerItem>>();

    public static boolean isFilledContainer(ItemStack stackInSlot) {
        if (stackInSlot.func_77973_b() instanceof IFluidContainerItem) {
            FluidStack fluidStack = ((IFluidContainerItem)stackInSlot.func_77973_b()).getFluid(stackInSlot);
            return fluidStack != null;
        }
        return FluidContainerRegistry.isFilledContainer((ItemStack)stackInSlot);
    }

    public static FluidStack getFluidForFilledItem(ItemStack stackInSlot) {
        if (stackInSlot.func_77973_b() instanceof IFluidContainerItem) {
            return ((IFluidContainerItem)stackInSlot.func_77973_b()).getFluid(stackInSlot);
        }
        return FluidContainerRegistry.getFluidForFilledItem((ItemStack)stackInSlot);
    }

    public static ItemStack drainFluidContainer(ItemStack stackInSlot) {
        if (stackInSlot.func_77973_b() instanceof IFluidContainerItem) {
            ItemStack working = stackInSlot.func_77946_l();
            ((IFluidContainerItem)stackInSlot.func_77973_b()).drain(working, ((IFluidContainerItem)stackInSlot.func_77973_b()).getCapacity(stackInSlot), true);
            return working;
        }
        return FluidContainerRegistry.drainFluidContainer((ItemStack)stackInSlot);
    }

    public static boolean isEmptyContainer(ItemStack stackInSlot) {
        if (stackInSlot.func_77973_b() instanceof IFluidContainerItem) {
            FluidStack fluidStack = ((IFluidContainerItem)stackInSlot.func_77973_b()).getFluid(stackInSlot);
            return fluidStack == null;
        }
        return FluidContainerRegistry.isEmptyContainer((ItemStack)stackInSlot);
    }

    public static int getContainerCapacity(FluidStack fluidStack, ItemStack stackInSlot) {
        if (specialCases.containsKey(stackInSlot.func_77973_b())) {
            ArrayList<IFluidContainerItem> iFluidContainerItems = specialCases.get(stackInSlot.func_77973_b());
            int result = 0;
            for (IFluidContainerItem iFluidContainerItem : iFluidContainerItems) {
                result = Math.max(iFluidContainerItem.fill(stackInSlot, fluidStack, false), result);
            }
            if (result > 0) {
                return result;
            }
        }
        if (stackInSlot.func_77973_b() instanceof IFluidContainerItem) {
            return ((IFluidContainerItem)stackInSlot.func_77973_b()).getCapacity(stackInSlot);
        }
        return FluidContainerRegistry.getContainerCapacity((FluidStack)fluidStack, (ItemStack)stackInSlot);
    }

    public static ItemStack fillFluidContainer(FluidStack fluidStack, ItemStack stackInSlot) {
        if (specialCases.containsKey(stackInSlot.func_77973_b())) {
            ArrayList<IFluidContainerItem> iFluidContainerItems = specialCases.get(stackInSlot.func_77973_b());
            ItemStack working = stackInSlot.func_77946_l();
            for (IFluidContainerItem iFluidContainerItem : iFluidContainerItems) {
                int amt = iFluidContainerItem.fill(working, fluidStack, true);
                if (amt == 0) continue;
                return working;
            }
        }
        if (stackInSlot.func_77973_b() instanceof IFluidContainerItem) {
            ItemStack working = stackInSlot.func_77946_l();
            ((IFluidContainerItem)stackInSlot.func_77973_b()).fill(working, fluidStack, true);
            return working;
        }
        return FluidContainerRegistry.fillFluidContainer((FluidStack)fluidStack, (ItemStack)stackInSlot);
    }

    static {
        specialCases.put(Items.field_151069_bo, new ArrayList(){
            {
                this.add(FluidLoader.FLUID_CONTAINER);
            }
        });
    }
}

