/*
 * Decompiled with CFR 0.152.
 */
package com.dmfmm.extrafood.tileentities;

import com.dmfmm.extrafood.blocks.BlockContainerRotate;
import com.dmfmm.extrafood.container.JuiceMixerContainer;
import com.dmfmm.extrafood.crafting.JuiceMixerRegistry;
import com.dmfmm.extrafood.utilities.FluidContainerRegistryHelper;
import java.util.ArrayList;
import java.util.Arrays;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;

public class JuiceMixerTileEntity
extends TileEntity
implements IFluidHandler,
ITickable,
IInventory {
    public FluidTank input1;
    public FluidTank input2;
    public FluidTank input3;
    public ArrayList<FluidStack> outputState;
    public SelectedTank selected;
    private ItemStack[] inv = new ItemStack[4];

    public JuiceMixerTileEntity() {
        this.selected = SelectedTank.LEFT;
        this.input1 = new FluidTank(2000);
        this.input2 = new FluidTank(2000);
        this.input3 = new FluidTank(2000);
        this.outputState = new ArrayList();
    }

    public void handleMakeDestroy(int id) {
        switch (id) {
            case 0: {
                this.outputState = new ArrayList<FluidStack>(Arrays.asList(JuiceMixerRegistry.instance.getOutputForCurrent(this.outputState)));
                break;
            }
            case 1: {
                this.outputState = new ArrayList();
            }
        }
    }

    public void handleClickingRelease(int tank) {
        FluidTank toDrain = null;
        switch (tank) {
            case 0: {
                toDrain = this.input1;
                break;
            }
            case 1: {
                toDrain = this.input2;
                break;
            }
            case 2: {
                toDrain = this.input3;
            }
        }
        FluidStack drainable = toDrain.drain(500, false);
        if (drainable == null || drainable.amount < 500) {
            return;
        }
        int total = 0;
        for (FluidStack fluidStack : this.outputState) {
            total += fluidStack.amount;
        }
        if (total > 5500) {
            return;
        }
        Fluid fluid = toDrain.getFluid().getFluid();
        toDrain.drain(500, true);
        ArrayList<FluidStack> outputStateNew = new ArrayList<FluidStack>();
        boolean existed = false;
        for (FluidStack fluidStack : this.outputState) {
            if (fluidStack.getFluid() == fluid) {
                FluidStack newFluidStack = fluidStack.copy();
                newFluidStack.amount += 500;
                outputStateNew.add(newFluidStack);
                existed = true;
                continue;
            }
            outputStateNew.add(fluidStack.copy());
        }
        if (!existed) {
            outputStateNew.add(new FluidStack(fluid, 500));
        }
        this.outputState = outputStateNew;
    }

    public void changeSelected(SelectedTank tank) {
        this.selected = tank;
    }

    public int fill(EnumFacing from, FluidStack resource, boolean doFill) {
        switch (BlockContainerRotate.RelativeDirection.getRelativeDirection(from, BlockContainerRotate.getFacing(this.field_145850_b, this.field_174879_c))) {
            case LEFT: {
                return this.input1.fill(resource, doFill);
            }
            case RIGHT: {
                return this.input3.fill(resource, doFill);
            }
            case BACK: {
                return this.input2.fill(resource, doFill);
            }
            case DOWN: {
                return 0;
            }
        }
        return 0;
    }

    public FluidStack drain(EnumFacing from, FluidStack resource, boolean doDrain) {
        switch (BlockContainerRotate.RelativeDirection.getRelativeDirection(from, BlockContainerRotate.getFacing(this.field_145850_b, this.field_174879_c))) {
            case LEFT: {
                if (this.input1.getFluid().isFluidEqual(resource)) {
                    return this.input1.drain(resource.amount, doDrain);
                }
                return null;
            }
            case RIGHT: {
                if (this.input3.getFluid().isFluidEqual(resource)) {
                    return this.input3.drain(resource.amount, doDrain);
                }
                return null;
            }
            case BACK: {
                if (this.input2.getFluid().isFluidEqual(resource)) {
                    return this.input2.drain(resource.amount, doDrain);
                }
                return null;
            }
            case DOWN: {
                if (this.outputState.size() == 1 && resource.isFluidEqual(this.outputState.get(0))) {
                    return this.drainOutput(resource.amount, doDrain);
                }
                return null;
            }
        }
        return null;
    }

    public FluidStack drainOutput(int maxDrain, boolean doDrain) {
        FluidStack fluid = this.outputState.get(0);
        if (this.outputState.size() != 1) {
            return null;
        }
        int drained = maxDrain;
        if (fluid.amount < drained) {
            drained = fluid.amount;
        }
        FluidStack stack = new FluidStack(fluid, drained);
        if (doDrain) {
            fluid.amount -= drained;
            if (fluid.amount <= 0) {
                this.outputState.clear();
            } else {
                this.outputState.set(0, fluid);
            }
        }
        return stack;
    }

    public FluidStack drain(EnumFacing from, int maxDrain, boolean doDrain) {
        switch (BlockContainerRotate.RelativeDirection.getRelativeDirection(from, BlockContainerRotate.getFacing(this.field_145850_b, this.field_174879_c))) {
            case LEFT: {
                return this.input1.drain(maxDrain, doDrain);
            }
            case BACK: {
                return this.input2.drain(maxDrain, doDrain);
            }
            case RIGHT: {
                return this.input3.drain(maxDrain, doDrain);
            }
            case DOWN: {
                return this.drainOutput(maxDrain, doDrain);
            }
        }
        return null;
    }

    public boolean canFill(EnumFacing from, Fluid fluid) {
        switch (BlockContainerRotate.RelativeDirection.getRelativeDirection(from, BlockContainerRotate.getFacing(this.field_145850_b, this.field_174879_c))) {
            case LEFT: 
            case RIGHT: 
            case BACK: {
                return true;
            }
        }
        return false;
    }

    public boolean canDrain(EnumFacing from, Fluid fluid) {
        switch (BlockContainerRotate.RelativeDirection.getRelativeDirection(from, BlockContainerRotate.getFacing(this.field_145850_b, this.field_174879_c))) {
            case LEFT: 
            case RIGHT: 
            case BACK: {
                return true;
            }
            case DOWN: {
                return this.outputState.size() == 1;
            }
        }
        return false;
    }

    public FluidTankInfo[] getTankInfo(EnumFacing from) {
        switch (BlockContainerRotate.RelativeDirection.getRelativeDirection(from, BlockContainerRotate.getFacing(this.field_145850_b, this.field_174879_c))) {
            case LEFT: {
                return new FluidTankInfo[]{new FluidTankInfo(this.input1.getFluid(), this.input1.getFluidAmount())};
            }
            case BACK: {
                return new FluidTankInfo[]{new FluidTankInfo(this.input2.getFluid(), this.input2.getFluidAmount())};
            }
            case RIGHT: {
                return new FluidTankInfo[]{new FluidTankInfo(this.input3.getFluid(), this.input3.getFluidAmount())};
            }
        }
        return new FluidTankInfo[0];
    }

    public int func_70302_i_() {
        return this.inv.length;
    }

    public ItemStack func_70301_a(int index) {
        return this.inv[index];
    }

    public ItemStack func_70298_a(int slot, int amt) {
        ItemStack stack = this.func_70301_a(slot);
        if (stack != null) {
            if (stack.field_77994_a <= amt) {
                this.func_70299_a(slot, null);
            } else {
                stack = stack.func_77979_a(amt);
                if (stack.field_77994_a == 0) {
                    this.func_70299_a(slot, null);
                }
            }
        }
        return stack;
    }

    public ItemStack func_70304_b(int slot) {
        ItemStack stack = this.func_70301_a(slot);
        if (stack != null) {
            this.func_70299_a(slot, null);
        }
        return stack;
    }

    public void func_70299_a(int index, ItemStack stack) {
        this.inv[index] = stack;
        if (stack != null && stack.field_77994_a > this.func_70297_j_()) {
            stack.field_77994_a = this.func_70297_j_();
        }
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return true;
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_174886_c(EntityPlayer player) {
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        return index != 2 && index != 3;
    }

    public int func_174887_a_(int id) {
        return 0;
    }

    public void func_174885_b(int id, int value) {
    }

    public int func_174890_g() {
        return 0;
    }

    public void func_174888_l() {
    }

    public void func_73660_a() {
        int amount;
        FluidStack toAdd;
        if (this.func_70301_a(JuiceMixerContainer.INPUT_1) != null && FluidContainerRegistryHelper.isFilledContainer(this.func_70301_a(JuiceMixerContainer.INPUT_1)) && (toAdd = FluidContainerRegistryHelper.getFluidForFilledItem(this.func_70301_a(JuiceMixerContainer.INPUT_1))) != null && JuiceMixerRegistry.instance.validFluid(toAdd.getFluid())) {
            FluidTank toFill = null;
            switch (this.selected) {
                case LEFT: {
                    toFill = this.input1;
                    break;
                }
                case MIDDLE: {
                    toFill = this.input2;
                    break;
                }
                case RIGHT: {
                    toFill = this.input3;
                }
            }
            if (toFill.fill(toAdd, false) == toAdd.amount && this.func_70301_a(JuiceMixerContainer.OUTPUT_1) == null) {
                this.func_70299_a(JuiceMixerContainer.OUTPUT_1, FluidContainerRegistryHelper.drainFluidContainer(this.func_70301_a(JuiceMixerContainer.INPUT_1)));
                this.func_70299_a(JuiceMixerContainer.INPUT_1, null);
                toFill.fill(toAdd, true);
            }
        }
        if (this.func_70301_a(JuiceMixerContainer.INPUT_2) != null && FluidContainerRegistryHelper.isEmptyContainer(this.func_70301_a(JuiceMixerContainer.INPUT_2)) && this.outputState.size() == 1 && this.drainOutput((int)amount, (boolean)false).amount == (amount = FluidContainerRegistryHelper.getContainerCapacity(this.outputState.get(0), this.func_70301_a(JuiceMixerContainer.INPUT_2))) && amount > 0 && this.func_70301_a(JuiceMixerContainer.OUTPUT_2) == null) {
            this.func_70299_a(JuiceMixerContainer.OUTPUT_2, FluidContainerRegistryHelper.fillFluidContainer(this.drainOutput(amount, true), this.func_70301_a(JuiceMixerContainer.INPUT_2)));
            this.func_70299_a(JuiceMixerContainer.INPUT_2, null);
        }
    }

    public String func_70005_c_() {
        return "extrafood.juicemixerTE";
    }

    public boolean func_145818_k_() {
        return false;
    }

    public ITextComponent func_145748_c_() {
        return null;
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound syncData = new NBTTagCompound();
        syncData.func_74768_a("State", this.selected.toInt());
        NBTTagCompound fluidTank1 = new NBTTagCompound();
        this.input1.writeToNBT(fluidTank1);
        NBTTagCompound fluidTank2 = new NBTTagCompound();
        this.input2.writeToNBT(fluidTank2);
        NBTTagCompound fluidTank3 = new NBTTagCompound();
        this.input3.writeToNBT(fluidTank3);
        syncData.func_74782_a("InputTank1", (NBTBase)fluidTank1);
        syncData.func_74782_a("InputTank2", (NBTBase)fluidTank2);
        syncData.func_74782_a("InputTank3", (NBTBase)fluidTank3);
        NBTTagList output = new NBTTagList();
        for (FluidStack f : this.outputState) {
            NBTTagCompound fluidCompound = new NBTTagCompound();
            f.writeToNBT(fluidCompound);
            output.func_74742_a((NBTBase)fluidCompound);
        }
        syncData.func_74782_a("OutputState", (NBTBase)output);
        return new SPacketUpdateTileEntity(this.func_174877_v(), 1, syncData);
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.selected = SelectedTank.values()[pkt.func_148857_g().func_74762_e("State")];
        NBTTagCompound compound = pkt.func_148857_g();
        this.input1.readFromNBT(compound.func_74775_l("InputTank1"));
        this.input2.readFromNBT(compound.func_74775_l("InputTank2"));
        this.input3.readFromNBT(compound.func_74775_l("InputTank3"));
        NBTTagList outputStateList = compound.func_150295_c("OutputState", 10);
        for (int outputIndex = 0; outputIndex < outputStateList.func_74745_c(); ++outputIndex) {
            NBTTagCompound fluidStackCompound = outputStateList.func_150305_b(outputIndex);
            this.outputState.add(FluidStack.loadFluidStackFromNBT((NBTTagCompound)fluidStackCompound));
        }
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        NBTTagCompound fluidTank1 = new NBTTagCompound();
        this.input1.writeToNBT(fluidTank1);
        NBTTagCompound fluidTank2 = new NBTTagCompound();
        this.input2.writeToNBT(fluidTank2);
        NBTTagCompound fluidTank3 = new NBTTagCompound();
        this.input3.writeToNBT(fluidTank3);
        compound.func_74782_a("InputTank1", (NBTBase)fluidTank1);
        compound.func_74782_a("InputTank2", (NBTBase)fluidTank2);
        compound.func_74782_a("InputTank3", (NBTBase)fluidTank3);
        NBTTagList output = new NBTTagList();
        for (FluidStack f : this.outputState) {
            NBTTagCompound fluidCompound = new NBTTagCompound();
            f.writeToNBT(fluidCompound);
            output.func_74742_a((NBTBase)fluidCompound);
        }
        compound.func_74782_a("OutputState", (NBTBase)output);
        compound.func_74768_a("Selected", this.selected.toInt());
        NBTTagList inventory = new NBTTagList();
        for (int i = 0; i < 4; ++i) {
            ItemStack stacky = this.inv[i];
            if (stacky == null) continue;
            NBTTagCompound stackCompound = new NBTTagCompound();
            stacky.func_77955_b(stackCompound);
            stackCompound.func_74768_a("Slot", i);
        }
        compound.func_74782_a("Inventory", (NBTBase)inventory);
        return compound;
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.input1.readFromNBT(compound.func_74775_l("InputTank1"));
        this.input2.readFromNBT(compound.func_74775_l("InputTank2"));
        this.input3.readFromNBT(compound.func_74775_l("InputTank3"));
        NBTTagList outputStateList = compound.func_150295_c("OutputState", 10);
        for (int outputIndex = 0; outputIndex < outputStateList.func_74745_c(); ++outputIndex) {
            NBTTagCompound fluidStackCompound = outputStateList.func_150305_b(outputIndex);
            this.outputState.add(FluidStack.loadFluidStackFromNBT((NBTTagCompound)fluidStackCompound));
        }
        this.selected = SelectedTank.fromInt(compound.func_74762_e("Selected"));
        NBTTagList inventoryList = compound.func_150295_c("Inventory", 10);
        for (int inventoryListIndex = 0; inventoryListIndex < inventoryList.func_74745_c(); ++inventoryListIndex) {
            NBTTagCompound stackCompound = inventoryList.func_150305_b(inventoryListIndex);
            int slot = stackCompound.func_74762_e("Slot");
            this.inv[slot] = ItemStack.func_77949_a((NBTTagCompound)stackCompound);
        }
    }

    public static enum SelectedTank {
        LEFT(0),
        MIDDLE(1),
        RIGHT(2);

        private int id;

        private SelectedTank(int id) {
            this.id = id;
        }

        public int toInt() {
            return this.id;
        }

        public static SelectedTank fromInt(int i) {
            return SelectedTank.values()[i];
        }
    }
}

