/*
 * Decompiled with CFR 0.152.
 */
package com.dmfmm.extrafood.items.nbt;

import com.dmfmm.extrafood.items.nbt.NBTFoodRegistry;
import com.dmfmm.extrafood.items.nbt.NBTFoodSpecs;
import com.dmfmm.extrafood.utilities.tabs.OvenFoodTab;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;

public class NBTFood
extends ItemFood {
    public String name;
    public NBTFoodSpecs specs;

    public NBTFood(String name) {
        super(0, 0.0f, false);
        this.specs = NBTFoodRegistry.food.getSpecs(name);
        this.func_77637_a(OvenFoodTab.INSTANCE);
        this.func_77627_a(true);
        this.func_77655_b(name);
        this.name = name;
    }

    public boolean requiresMultipleRenderPasses() {
        return true;
    }

    public int getRenderPasses(int k) {
        return 5;
    }

    public ItemStack onEaten(ItemStack stack, World world, EntityPlayer player) {
        --stack.field_77994_a;
        player.func_71024_bL().func_75122_a(this.getHunger(stack), this.getSaturation(stack));
        world.func_184133_a(player, player.func_180425_c(), SoundEvents.field_187739_dZ, SoundCategory.PLAYERS, 0.5f, world.field_73012_v.nextFloat() * 0.1f + 0.9f);
        this.func_77849_c(stack, world, player);
        return stack;
    }

    public int getHunger(ItemStack stack) {
        NBTTagCompound comp = stack.func_77978_p();
        ArrayList<String> things = new ArrayList<String>();
        for (Object keyb : comp.func_150296_c().toArray()) {
            String key = (String)keyb;
            if (!Collections.list(this.specs.additives.keys()).contains(key) || !comp.func_74764_b(key) || !comp.func_74767_n(key)) continue;
            things.add(key);
        }
        if (this.specs.info.get(things) != null) {
            try {
                return (Integer)this.specs.info.get(things).get(0);
            }
            catch (Exception exception) {
                try {
                    return Math.round(((Float)this.specs.info.get(things).get(0)).floatValue());
                }
                catch (Exception exception2) {
                }
            }
        } else {
            return (int)this.specs.defualtHunger[0];
        }
        return (int)this.specs.defualtHunger[0];
    }

    public float getSaturation(ItemStack stack) {
        NBTTagCompound comp = stack.func_77978_p();
        ArrayList<String> things = new ArrayList<String>();
        for (Object keyb : comp.func_150296_c().toArray()) {
            String key = (String)keyb;
            if (!Collections.list(this.specs.additives.keys()).contains(key) || !comp.func_74764_b(key) || !comp.func_74767_n(key)) continue;
            things.add(key);
        }
        if (this.specs.info.get(things) != null) {
            return ((Float)this.specs.info.get(things).get(1)).floatValue();
        }
        return this.specs.defualtHunger[1];
    }

    public void func_77624_a(ItemStack stack, EntityPlayer player, List text, boolean idk) {
        NBTTagCompound comp = stack.func_77978_p();
        if (comp == null) {
            return;
        }
        ArrayList<String> things = new ArrayList<String>();
        for (Object keyb : comp.func_150296_c().toArray()) {
            String key = (String)keyb;
            if (!Collections.list(this.specs.additives.keys()).contains(key) || !comp.func_74764_b(key) || !comp.func_74767_n(key)) continue;
            things.add(key);
        }
        for (String i : things) {
            if (I18n.func_94522_b((String)("add." + this.name + "." + i))) {
                text.add("- " + TextFormatting.GREEN.toString() + I18n.func_74838_a((String)("add." + this.name + "." + i)));
                continue;
            }
            text.add("- " + i);
        }
    }

    public ArrayList<String> getIconNames(ItemStack t) {
        ArrayList<String> ret = new ArrayList<String>();
        HashMap<String, String> possibleicons = new HashMap<String, String>();
        ArrayList<String> keys = Collections.list(this.specs.additives.keys());
        for (String key : keys) {
            String iconstring = this.specs.additives.get(key);
            possibleicons.put(key, iconstring);
        }
        NBTTagCompound comp = t.func_77978_p();
        ArrayList<String> things = new ArrayList<String>();
        if (comp != null) {
            for (Object keyb : comp.func_150296_c().toArray()) {
                String key;
                key = (String)keyb;
                if (!Collections.list(this.specs.additives.keys()).contains(key) || !comp.func_74764_b(key) || !comp.func_74767_n(key)) continue;
                things.add(key);
            }
        }
        for (String thing : things) {
            ret.add((String)possibleicons.get(thing));
        }
        return ret;
    }

    public String getBase() {
        return this.specs.defualtIcon;
    }

    public NBTTagCompound getNBT(String ... strings) {
        return this.getNBT(this.ar(strings));
    }

    public NBTTagCompound getNBT(ArrayList<String> things) {
        NBTTagCompound compound = new NBTTagCompound();
        for (String i : things) {
            compound.func_74757_a(i, true);
        }
        return compound;
    }

    public void func_150895_a(Item item, CreativeTabs tab, List things) {
        for (ArrayList<String> i : Collections.list(this.specs.info.keys())) {
            ItemStack toAdd = new ItemStack(item);
            toAdd.func_77982_d(this.getNBT(i));
            things.add(toAdd);
        }
    }

    public ArrayList<String> ar(String ... strings) {
        ArrayList<String> rval = new ArrayList<String>();
        for (String i : strings) {
            rval.add(i);
        }
        return rval;
    }
}

