/*
 * Decompiled with CFR 0.152.
 */
package com.dmfmm.extrafood.fluids;

import com.dmfmm.extrafood.fluids.EdibleFluid;
import com.dmfmm.extrafood.init.FluidLoader;
import com.dmfmm.extrafood.utilities.EFLog;
import com.dmfmm.extrafood.utilities.tabs.ExtraFoodTab;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidContainerItem;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class GlassFluidContainer
extends Item
implements IFluidContainerItem {
    public static ArrayList<Fluid> list = new ArrayList();

    public GlassFluidContainer() {
        this.RnR();
        this.setRegistryName("EFglassBottle");
        this.func_77637_a(ExtraFoodTab.INSTANCE);
    }

    public static ItemStack createFluidFilledBottle(Fluid fluid) {
        ItemStack itemStack = new ItemStack(FluidLoader.FLUID_CONTAINER);
        NBTTagCompound tagCompound = new NBTTagCompound();
        tagCompound.func_74778_a("fluid", fluid.getName());
        itemStack.func_77982_d(tagCompound);
        return itemStack;
    }

    public String func_77653_i(ItemStack stack) {
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("fluid")) {
            return I18n.func_74838_a((String)("item.EFbottle." + stack.func_77978_p().func_74779_i("fluid") + ".name"));
        }
        return "BOTTLE ERROR, REPORT IMMEDIATELY!";
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item itemIn, CreativeTabs tab, List<ItemStack> subItems) {
        for (Fluid fluid : list) {
            subItems.add(GlassFluidContainer.createFluidFilledBottle(fluid));
        }
    }

    public static void createGlassBottles() {
        for (Fluid fluid : list) {
            EFLog.fatal("Added " + fluid.getName() + " to the Registry");
        }
    }

    private void RnR() {
        Field[] fields;
        for (Field dec : fields = FluidLoader.class.getDeclaredFields()) {
            if (!Modifier.isStatic(dec.getModifiers())) continue;
            try {
                Object obj = dec.get(null);
                if (!(obj instanceof Fluid)) continue;
                list.add((Fluid)obj);
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
    }

    public EnumAction func_77661_b(ItemStack stack) {
        return EnumAction.DRINK;
    }

    public ActionResult<ItemStack> func_77659_a(ItemStack stack, World world, EntityPlayer player, EnumHand hand) {
        if (stack.func_77973_b() == this && player.func_71043_e(false)) {
            player.func_184598_c(hand);
            return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
        }
        return new ActionResult(EnumActionResult.FAIL, (Object)stack);
    }

    public ItemStack func_77654_b(ItemStack stack, World world, EntityLivingBase entityLiving) {
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("fluid") && FluidRegistry.getFluid((String)stack.func_77978_p().func_74779_i("fluid")) instanceof EdibleFluid) {
            EdibleFluid edibleFluid = (EdibleFluid)FluidRegistry.getFluid((String)stack.func_77978_p().func_74779_i("fluid"));
            --stack.field_77994_a;
            if (entityLiving instanceof EntityPlayer) {
                EntityPlayer player = (EntityPlayer)entityLiving;
                player.func_71024_bL().func_75122_a(edibleFluid.hunger, edibleFluid.starve);
                world.func_184148_a((EntityPlayer)null, player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundEvents.field_187739_dZ, SoundCategory.PLAYERS, 0.5f, world.field_73012_v.nextFloat() * 0.1f + 0.9f);
                if (!player.field_71075_bZ.field_75098_d) {
                    if (stack.field_77994_a <= 0) {
                        return new ItemStack(Items.field_151069_bo);
                    }
                    player.field_71071_by.func_70441_a(new ItemStack(Items.field_151069_bo));
                }
            }
        }
        return stack;
    }

    public int func_77626_a(ItemStack p_77626_1_) {
        return 32;
    }

    public FluidStack getFluid(ItemStack container) {
        return new FluidStack(FluidRegistry.getFluid((String)container.func_77978_p().func_74779_i("fluid")), 1000);
    }

    public int getCapacity(ItemStack container) {
        return 1000;
    }

    public int fill(ItemStack container, FluidStack resource, boolean doFill) {
        if (container.func_77973_b() != Items.field_151069_bo) {
            return 0;
        }
        if (resource.amount < 1000) {
            return 0;
        }
        if (!list.contains(resource.getFluid())) {
            return 0;
        }
        if (doFill) {
            container.func_150996_a((Item)this);
            container.func_77982_d(new NBTTagCompound());
            container.func_77978_p().func_74778_a("fluid", resource.getFluid().getName());
        }
        return 1000;
    }

    public FluidStack drain(ItemStack container, int maxDrain, boolean doDrain) {
        if (container.func_77973_b() != this) {
            return null;
        }
        if (maxDrain != 1000) {
            return null;
        }
        FluidStack previous = this.getFluid(container);
        if (doDrain) {
            container.func_150996_a(Items.field_151069_bo);
            container.func_77982_d(null);
        }
        return previous;
    }
}

