/*
 * Decompiled with CFR 0.152.
 */
package com.dmfmm.extrafood.events;

import com.dmfmm.extrafood.init.BlockLoader;
import com.dmfmm.extrafood.init.ItemLoader;
import com.dmfmm.extrafood.utilities.ConfigHandler;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.player.FillBucketEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class BucketEvent {
    public static BucketEvent INSTANCE = new BucketEvent();
    public Map<Block, Item> buckets = new HashMap<Block, Item>();

    private BucketEvent() {
        this.buckets.put(BlockLoader.BANANA_JUICE_BLOCK, ItemLoader.BUCKET_BANANA);
        this.buckets.put(BlockLoader.STRAWBERRY_JUICE_BLOCK, ItemLoader.BUCKET_STRAWBERRY);
        this.buckets.put(BlockLoader.CARROT_JUICE_BLOCK, ItemLoader.BUCKET_CARROT);
        if (ConfigHandler.overrideWater) {
            this.buckets.put((Block)Blocks.field_150355_j, ItemLoader.BUCKET_SEA_WATER);
        }
    }

    @SubscribeEvent
    public void onBucketFill(FillBucketEvent event) {
        if (event.getTarget() == null) {
            return;
        }
        ItemStack result = this.fillCustomBucket(event.getWorld(), event.getTarget());
        if (result == null) {
            return;
        }
        event.setFilledBucket(result);
        event.setResult(Event.Result.ALLOW);
    }

    private ItemStack fillCustomBucket(World world, RayTraceResult pos) {
        IBlockState state = world.func_180495_p(pos.func_178782_a());
        Item bucket = this.buckets.get(state.func_177230_c());
        if (bucket != null && state.func_177230_c().func_176201_c(state) == 0) {
            world.func_175698_g(pos.func_178782_a());
            return new ItemStack(bucket);
        }
        return null;
    }
}

