/*
 * Decompiled with CFR 0.152.
 */
package com.dmfmm.extrafood.crafting;

import com.dmfmm.extrafood.init.FluidLoader;
import com.dmfmm.extrafood.utilities.DualObjectLink;
import java.util.ArrayList;
import java.util.Arrays;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;

public class JuiceMixerRegistry {
    public static JuiceMixerRegistry instance = new JuiceMixerRegistry();
    public ArrayList<RecipeJuiceMixer> recipes = new ArrayList();
    public ArrayList<Fluid> validFluids = new ArrayList();

    public JuiceMixerRegistry() {
        this.addRecipe(4, FluidLoader.Fapplegrapejuice, this.dl(2, FluidLoader.Fapplejuice), this.dl(2, FluidLoader.Fgrapejuice));
        this.addRecipe(4, FluidLoader.Fcitusjuice, this.dl(1, FluidLoader.Fapplejuice), this.dl(2, FluidLoader.Fgrapejuice), this.dl(1, FluidLoader.Forangejuice));
        this.addRecipe(6, FluidLoader.Ffruitjuice, this.dl(2, FluidLoader.Fapplejuice), this.dl(2, FluidLoader.Fwatermelonjuice), this.dl(1, FluidLoader.Fstrawberryjuice), this.dl(1, FluidLoader.Fgrapejuice));
        this.addRecipe(2, FluidLoader.Fmixedberryjuice, this.dl(1, FluidLoader.Fstrawberryjuice), this.dl(1, FluidLoader.Fgrapejuice));
        this.addRecipe(2, FluidLoader.Fstrawberrybanana, this.dl(1, FluidLoader.Fbananajuice), this.dl(1, FluidLoader.Fstrawberryjuice));
        this.addRecipe(2, FluidLoader.Ftropicaljuice, this.dl(1, FluidLoader.FpinappleJuice), this.dl(1, FluidLoader.Fcitusjuice));
    }

    public void addRecipe(int output, Fluid outputFluid, DualObjectLink<Integer, Fluid> ... fluids) {
        RecipeJuiceMixer recipe = new RecipeJuiceMixer(output, outputFluid, fluids);
        for (DualObjectLink<Integer, Fluid> dualObjectLink : fluids) {
            if (this.validFluids.contains(dualObjectLink.getB())) continue;
            this.validFluids.add(dualObjectLink.getB());
        }
        this.recipes.add(recipe);
    }

    public DualObjectLink<Integer, Fluid> dl(Integer i, Fluid f) {
        return new DualObjectLink<Integer, Fluid>(i, f);
    }

    public FluidStack getOutputForCurrent(ArrayList<FluidStack> fluidStacks) {
        if (fluidStacks.size() == 1) {
            return fluidStacks.get(0).copy();
        }
        for (RecipeJuiceMixer recipe : this.recipes) {
            if (!recipe.matches(fluidStacks)) continue;
            int millis = 500 * recipe.output(fluidStacks);
            return new FluidStack(recipe.outputFluid, millis);
        }
        int total = 0;
        for (FluidStack fluidStack : fluidStacks) {
            total += fluidStack.amount;
        }
        return new FluidStack(FluidLoader.FHorribleLiquid, total);
    }

    public boolean validFluid(Fluid f) {
        return this.validFluids.contains(f);
    }

    public class RecipeJuiceMixer {
        ArrayList<DualObjectLink<Integer, Fluid>> inputFluids = new ArrayList();
        int outputAmount = 1;
        Fluid outputFluid;

        @SafeVarargs
        public RecipeJuiceMixer(int outputAmount, Fluid outputFluid, DualObjectLink<Integer, Fluid> ... inputFluids) {
            this.outputAmount = outputAmount;
            this.outputFluid = outputFluid;
            this.inputFluids = new ArrayList<DualObjectLink<Integer, Fluid>>(Arrays.asList(inputFluids));
        }

        public boolean matches(ArrayList<FluidStack> fluidStacks) {
            if (fluidStacks.size() != this.inputFluids.size()) {
                return false;
            }
            int ratio_amount = -1;
            ArrayList fluidStacksCopy = (ArrayList)fluidStacks.clone();
            for (DualObjectLink<Integer, Fluid> inputFluid : this.inputFluids) {
                FluidStack target = null;
                for (FluidStack candidate : fluidStacksCopy) {
                    if (candidate.getFluid() != inputFluid.getB()) continue;
                    target = candidate;
                    break;
                }
                if (target == null) {
                    return false;
                }
                fluidStacksCopy.remove(target);
                if (ratio_amount == -1) {
                    ratio_amount = target.amount / 500 / inputFluid.getA();
                    continue;
                }
                if (target.amount / 500 / inputFluid.getA() == ratio_amount) continue;
                return false;
            }
            return true;
        }

        public int output(ArrayList<FluidStack> fluidStacks) {
            if (fluidStacks.size() != this.inputFluids.size()) {
                return 0;
            }
            int ratio_amount = -1;
            ArrayList fluidStacksCopy = (ArrayList)fluidStacks.clone();
            for (DualObjectLink<Integer, Fluid> inputFluid : this.inputFluids) {
                FluidStack target = null;
                for (FluidStack candidate : fluidStacksCopy) {
                    if (candidate.getFluid() != inputFluid.getB()) continue;
                    target = candidate;
                    break;
                }
                if (target == null) {
                    return 0;
                }
                fluidStacksCopy.remove(target);
                if (ratio_amount == -1) {
                    ratio_amount = target.amount / 500 / inputFluid.getA();
                    continue;
                }
                if (target.amount / 500 / inputFluid.getA() == ratio_amount) continue;
                return 0;
            }
            return this.outputAmount * ratio_amount;
        }
    }
}

