/*
 * Decompiled with CFR 0.152.
 */
package com.dmfmm.extrafood.client.modelbake.NBTFood;

import com.dmfmm.extrafood.items.nbt.NBTFoodRegistry;
import com.dmfmm.extrafood.items.nbt.NBTFoodSpecs;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.vecmath.Matrix4f;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ICustomModelLoader;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.IModelCustomData;
import net.minecraftforge.client.model.IPerspectiveAwareModel;
import net.minecraftforge.client.model.IRetexturableModel;
import net.minecraftforge.client.model.ItemLayerModel;
import net.minecraftforge.client.model.SimpleModelState;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.common.model.TRSRTransformation;
import org.apache.commons.lang3.tuple.Pair;

public class NBTFoodModel
implements IModel,
IModelCustomData,
IRetexturableModel {
    NBTFoodSpecs nbtFood;
    ArrayList<String> nbtFoodAddivites;
    static NBTFoodModel MODEL = new NBTFoodModel();

    public NBTFoodModel() {
        this("pizza", new ArrayList<String>());
    }

    public NBTFoodModel(String nbtFood, ArrayList<String> strings) {
        this.nbtFood = NBTFoodRegistry.food.getSpecs(nbtFood);
        this.nbtFoodAddivites = strings;
    }

    public IModel process(ImmutableMap<String, String> customData) {
        ArrayList<String> strings = new ArrayList<String>();
        if (customData.containsKey((Object)"data")) {
            strings.addAll(Arrays.asList(((String)customData.get((Object)"data")).split(";")));
        }
        String namey = "";
        namey = ((String)customData.get((Object)"food")).replaceAll("^\"+", "").replaceAll("\"+$", "");
        return new NBTFoodModel(namey, strings);
    }

    public Collection<ResourceLocation> getDependencies() {
        return ImmutableList.of();
    }

    public Collection<ResourceLocation> getTextures() {
        ImmutableList.Builder builder = ImmutableList.builder();
        builder.add((Object)new ResourceLocation(this.nbtFood.defualtIcon));
        for (String nbtFoodAddivite : this.nbtFoodAddivites) {
            builder.add((Object)new ResourceLocation(this.nbtFood.additives.get(nbtFoodAddivite)));
        }
        return builder.build();
    }

    public IBakedModel bake(IModelState state, VertexFormat format, Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter) {
        ImmutableMap transformMap = IPerspectiveAwareModel.MapWrapper.getTransforms((IModelState)state);
        TRSRTransformation transform = (TRSRTransformation)state.apply(Optional.absent()).or((Object)TRSRTransformation.identity());
        TextureAtlasSprite base = (TextureAtlasSprite)bakedTextureGetter.apply((Object)new ResourceLocation(this.nbtFood.defualtIcon));
        ImmutableList.Builder builder = ImmutableList.builder();
        ImmutableList.Builder objectBuilder = ImmutableList.builder();
        objectBuilder.add((Object)new ResourceLocation(this.nbtFood.defualtIcon));
        for (String a : this.nbtFoodAddivites) {
            try {
                ResourceLocation r = new ResourceLocation(this.nbtFood.additives.get(a));
                objectBuilder.add((Object)r);
            }
            catch (NullPointerException nullPointerException) {}
        }
        IBakedModel model = new ItemLayerModel(objectBuilder.build()).bake(state, format, bakedTextureGetter);
        builder.addAll((Iterable)model.func_188616_a(null, null, 0L));
        return new BakedNBTFoodModel(this, (ImmutableList<BakedQuad>)builder.build(), base, format, (ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation>)transformMap);
    }

    public IModelState getDefaultState() {
        return TRSRTransformation.identity();
    }

    public IModel retexture(ImmutableMap<String, String> textures) {
        return this;
    }

    public static enum ModelLodaer implements ICustomModelLoader
    {
        instance;


        public boolean accepts(ResourceLocation modelLocation) {
            return modelLocation.func_110624_b().equals("extrafood") && modelLocation.func_110623_a().contains("nbtfood");
        }

        public IModel loadModel(ResourceLocation modelLocation) throws IOException {
            return MODEL;
        }

        public void func_110549_a(IResourceManager resourceManager) {
        }
    }

    public static class BakedNBTFoodModel
    implements IPerspectiveAwareModel {
        private final ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation> transforms;
        private final NBTFoodModel parent;
        private final Map<ArrayList<String>, IBakedModel> cache;
        private final ImmutableList<BakedQuad> quads;
        private final TextureAtlasSprite particle;
        private final VertexFormat format;

        public BakedNBTFoodModel(NBTFoodModel parent, ImmutableList<BakedQuad> quads, TextureAtlasSprite particle, VertexFormat fmt, ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation> transforms) {
            this.quads = quads;
            this.particle = particle;
            this.format = fmt;
            this.parent = parent;
            this.transforms = transforms;
            this.cache = Maps.newHashMap();
        }

        public Pair<? extends IBakedModel, Matrix4f> handlePerspective(ItemCameraTransforms.TransformType cameraTransformType) {
            return IPerspectiveAwareModel.MapWrapper.handlePerspective((IBakedModel)this, this.transforms, (ItemCameraTransforms.TransformType)cameraTransformType);
        }

        public List<BakedQuad> func_188616_a(IBlockState state, EnumFacing side, long rand) {
            if (side == null) {
                return this.quads;
            }
            return ImmutableList.of();
        }

        public boolean func_177555_b() {
            return true;
        }

        public boolean func_177556_c() {
            return false;
        }

        public boolean func_188618_c() {
            return false;
        }

        public TextureAtlasSprite func_177554_e() {
            return this.particle;
        }

        public ItemCameraTransforms func_177552_f() {
            return ItemCameraTransforms.field_178357_a;
        }

        public ItemOverrideList func_188617_f() {
            return BakedNBTFoodOverrideHandler.INSTANCE;
        }
    }

    private static final class BakedNBTFoodOverrideHandler
    extends ItemOverrideList {
        public static final BakedNBTFoodOverrideHandler INSTANCE = new BakedNBTFoodOverrideHandler();

        public BakedNBTFoodOverrideHandler() {
            super((List)ImmutableList.of());
        }

        public IBakedModel handleItemState(IBakedModel originalModel, ItemStack stack, World world, EntityLivingBase entity) {
            BakedNBTFoodModel model = (BakedNBTFoodModel)originalModel;
            ArrayList<String> dtat = new ArrayList<String>();
            for (String key : stack.func_77978_p().func_150296_c()) {
                if (!stack.func_77978_p().func_150297_b(key, 1) || !stack.func_77978_p().func_74767_n(key)) continue;
                dtat.add(key);
            }
            if (!model.cache.containsKey(dtat)) {
                Joiner joiner = Joiner.on((String)";");
                IModel model2 = model.parent.process((ImmutableMap<String, String>)ImmutableMap.of((Object)"food", (Object)((BakedNBTFoodModel)model).parent.nbtFood.name, (Object)"data", (Object)joiner.join(dtat)));
                Function<ResourceLocation, TextureAtlasSprite> textureGetter = new Function<ResourceLocation, TextureAtlasSprite>(){

                    public TextureAtlasSprite apply(ResourceLocation location) {
                        return Minecraft.func_71410_x().func_147117_R().func_110572_b(location.toString());
                    }
                };
                IBakedModel bakedModel = model2.bake((IModelState)new SimpleModelState(model.transforms), model.format, (Function)textureGetter);
                model.cache.put(dtat, bakedModel);
                return bakedModel;
            }
            return (IBakedModel)model.cache.get(dtat);
        }
    }
}

