/*
 * Decompiled with CFR 0.152.
 */
package com.dmfmm.extrafood.client.modelbake.GlassBottle;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.vecmath.Matrix4f;
import javax.vecmath.Quat4f;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ICustomModelLoader;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.IModelCustomData;
import net.minecraftforge.client.model.IPerspectiveAwareModel;
import net.minecraftforge.client.model.IRetexturableModel;
import net.minecraftforge.client.model.ItemLayerModel;
import net.minecraftforge.client.model.ItemTextureQuadConverter;
import net.minecraftforge.client.model.ModelStateComposition;
import net.minecraftforge.client.model.SimpleModelState;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.common.model.TRSRTransformation;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidContainerItem;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.tuple.Pair;

@SideOnly(value=Side.CLIENT)
public final class ModelDynGlassBottle
implements IModel,
IModelCustomData,
IRetexturableModel {
    public static final ModelResourceLocation LOCATION = new ModelResourceLocation(new ResourceLocation("forge", "dynbucket"), "inventory");
    private static final float NORTH_Z_BASE = 0.4685f;
    private static final float SOUTH_Z_BASE = 0.5315f;
    private static final float NORTH_Z_FLUID = 0.468625f;
    private static final float SOUTH_Z_FLUID = 0.531375f;
    public static final IModel MODEL = new ModelDynGlassBottle();
    private final ResourceLocation baseLocation;
    private final ResourceLocation liquidLocation;
    private final ResourceLocation coverLocation;
    private final Fluid fluid;
    private final boolean flipGas;

    public ModelDynGlassBottle() {
        this(null, null, null, null, false);
    }

    public ModelDynGlassBottle(ResourceLocation baseLocation, ResourceLocation liquidLocation, ResourceLocation coverLocation, Fluid fluid, boolean flipGas) {
        this.baseLocation = baseLocation;
        this.liquidLocation = liquidLocation;
        this.coverLocation = coverLocation;
        this.fluid = fluid;
        this.flipGas = flipGas;
    }

    public Collection<ResourceLocation> getDependencies() {
        return ImmutableList.of();
    }

    public Collection<ResourceLocation> getTextures() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        if (this.baseLocation != null) {
            builder.add((Object)this.baseLocation);
        }
        if (this.liquidLocation != null) {
            builder.add((Object)this.liquidLocation);
        }
        if (this.coverLocation != null) {
            builder.add((Object)this.coverLocation);
        }
        return builder.build();
    }

    public IBakedModel bake(IModelState state, VertexFormat format, Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter) {
        ImmutableMap transformMap = IPerspectiveAwareModel.MapWrapper.getTransforms((IModelState)state);
        if (this.flipGas && this.fluid != null && this.fluid.isGaseous()) {
            state = new ModelStateComposition(state, (IModelState)TRSRTransformation.blockCenterToCorner((TRSRTransformation)new TRSRTransformation(null, new Quat4f(0.0f, 0.0f, 1.0f, 0.0f), null, null)));
        }
        TRSRTransformation transform = (TRSRTransformation)state.apply(Optional.absent()).or((Object)TRSRTransformation.identity());
        TextureAtlasSprite fluidSprite = null;
        ImmutableList.Builder builder = ImmutableList.builder();
        if (this.fluid != null) {
            fluidSprite = (TextureAtlasSprite)bakedTextureGetter.apply((Object)this.fluid.getStill());
        }
        if (this.baseLocation != null) {
            IBakedModel model = new ItemLayerModel(ImmutableList.of((Object)this.baseLocation)).bake(state, format, bakedTextureGetter);
            builder.addAll((Iterable)model.func_188616_a(null, null, 0L));
        }
        if (this.liquidLocation != null && fluidSprite != null) {
            TextureAtlasSprite liquid = (TextureAtlasSprite)bakedTextureGetter.apply((Object)this.liquidLocation);
            builder.addAll((Iterable)ItemTextureQuadConverter.convertTexture((VertexFormat)format, (TRSRTransformation)transform, (TextureAtlasSprite)liquid, (TextureAtlasSprite)fluidSprite, (float)0.468625f, (EnumFacing)EnumFacing.NORTH, (int)this.fluid.getColor()));
            builder.addAll((Iterable)ItemTextureQuadConverter.convertTexture((VertexFormat)format, (TRSRTransformation)transform, (TextureAtlasSprite)liquid, (TextureAtlasSprite)fluidSprite, (float)0.531375f, (EnumFacing)EnumFacing.SOUTH, (int)this.fluid.getColor()));
        }
        if (this.coverLocation != null) {
            TextureAtlasSprite base = (TextureAtlasSprite)bakedTextureGetter.apply((Object)this.coverLocation);
            builder.add((Object)ItemTextureQuadConverter.genQuad((VertexFormat)format, (TRSRTransformation)transform, (float)0.0f, (float)0.0f, (float)16.0f, (float)16.0f, (float)0.4685f, (TextureAtlasSprite)base, (EnumFacing)EnumFacing.NORTH, (int)-1));
            builder.add((Object)ItemTextureQuadConverter.genQuad((VertexFormat)format, (TRSRTransformation)transform, (float)0.0f, (float)0.0f, (float)16.0f, (float)16.0f, (float)0.5315f, (TextureAtlasSprite)base, (EnumFacing)EnumFacing.SOUTH, (int)-1));
        }
        return new BakedDynBucketz(this, (ImmutableList<BakedQuad>)builder.build(), fluidSprite, format, (ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation>)Maps.immutableEnumMap((Map)transformMap), Maps.newHashMap());
    }

    public IModelState getDefaultState() {
        return TRSRTransformation.identity();
    }

    public ModelDynGlassBottle process(ImmutableMap<String, String> customData) {
        String fluidName = (String)customData.get((Object)"fluid");
        Fluid fluid = FluidRegistry.getFluid((String)fluidName);
        if (fluid == null) {
            fluid = this.fluid;
        }
        boolean flip = this.flipGas;
        if (customData.containsKey((Object)"flipGas")) {
            String flipStr = (String)customData.get((Object)"flipGas");
            if (flipStr.equals("true")) {
                flip = true;
            } else if (flipStr.equals("false")) {
                flip = false;
            } else {
                throw new IllegalArgumentException(String.format("DynBucket custom data \"flipGas\" must have value 'true' or 'false' (was '%s')", flipStr));
            }
        }
        return new ModelDynGlassBottle(this.baseLocation, this.liquidLocation, this.coverLocation, fluid, flip);
    }

    public ModelDynGlassBottle retexture(ImmutableMap<String, String> textures) {
        ResourceLocation base = this.baseLocation;
        ResourceLocation liquid = this.liquidLocation;
        ResourceLocation cover = this.coverLocation;
        if (textures.containsKey((Object)"base")) {
            base = new ResourceLocation((String)textures.get((Object)"base"));
        }
        if (textures.containsKey((Object)"fluid")) {
            liquid = new ResourceLocation((String)textures.get((Object)"fluid"));
        }
        if (textures.containsKey((Object)"cover")) {
            cover = new ResourceLocation((String)textures.get((Object)"cover"));
        }
        return new ModelDynGlassBottle(base, liquid, cover, this.fluid, this.flipGas);
    }

    private static final class BakedDynBucketz
    implements IPerspectiveAwareModel {
        private final ModelDynGlassBottle parent;
        private final Map<String, IBakedModel> cache;
        private final ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation> transforms;
        private final ImmutableList<BakedQuad> quads;
        private final TextureAtlasSprite particle;
        private final VertexFormat format;

        public BakedDynBucketz(ModelDynGlassBottle parent, ImmutableList<BakedQuad> quads, TextureAtlasSprite particle, VertexFormat format, ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation> transforms, Map<String, IBakedModel> cache) {
            this.quads = quads;
            this.particle = particle;
            this.format = format;
            this.parent = parent;
            this.transforms = transforms;
            this.cache = cache;
        }

        public ItemOverrideList func_188617_f() {
            return BakedDynBucketOverrideHandlerz.INSTANCE;
        }

        public Pair<? extends IBakedModel, Matrix4f> handlePerspective(ItemCameraTransforms.TransformType cameraTransformType) {
            return IPerspectiveAwareModel.MapWrapper.handlePerspective((IBakedModel)this, this.transforms, (ItemCameraTransforms.TransformType)cameraTransformType);
        }

        public List<BakedQuad> func_188616_a(IBlockState state, EnumFacing side, long rand) {
            if (side == null) {
                return this.quads;
            }
            return ImmutableList.of();
        }

        public boolean func_177555_b() {
            return true;
        }

        public boolean func_177556_c() {
            return false;
        }

        public boolean func_188618_c() {
            return false;
        }

        public TextureAtlasSprite func_177554_e() {
            return this.particle;
        }

        public ItemCameraTransforms func_177552_f() {
            return ItemCameraTransforms.field_178357_a;
        }
    }

    private static final class BakedDynBucketOverrideHandlerz
    extends ItemOverrideList {
        public static final BakedDynBucketOverrideHandlerz INSTANCE = new BakedDynBucketOverrideHandlerz();

        private BakedDynBucketOverrideHandlerz() {
            super((List)ImmutableList.of());
        }

        public IBakedModel handleItemState(IBakedModel originalModel, ItemStack stack, World world, EntityLivingBase entity) {
            FluidStack fluidStack = FluidContainerRegistry.getFluidForFilledItem((ItemStack)stack);
            if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("fluid")) {
                fluidStack = new FluidStack(FluidRegistry.getFluid((String)stack.func_77978_p().func_74779_i("fluid")), 1);
            }
            if (fluidStack == null && stack.func_77973_b() instanceof IFluidContainerItem) {
                fluidStack = ((IFluidContainerItem)stack.func_77973_b()).getFluid(stack);
            }
            if (fluidStack == null) {
                return originalModel;
            }
            BakedDynBucketz model = (BakedDynBucketz)originalModel;
            Fluid fluid = fluidStack.getFluid();
            String name = fluid.getName();
            if (!model.cache.containsKey(name)) {
                IModel parent = model.parent.process(ImmutableMap.of((Object)"fluid", (Object)name));
                Function<ResourceLocation, TextureAtlasSprite> textureGetter = new Function<ResourceLocation, TextureAtlasSprite>(){

                    public TextureAtlasSprite apply(ResourceLocation location) {
                        return Minecraft.func_71410_x().func_147117_R().func_110572_b(location.toString());
                    }
                };
                IBakedModel bakedModel = parent.bake((IModelState)new SimpleModelState(model.transforms), model.format, (Function)textureGetter);
                model.cache.put(name, bakedModel);
                return bakedModel;
            }
            return (IBakedModel)model.cache.get(name);
        }
    }

    public static enum LoaderDynBucketz implements ICustomModelLoader
    {
        instance;


        public boolean accepts(ResourceLocation modelLocation) {
            return modelLocation.func_110624_b().equals("extrafood") && modelLocation.func_110623_a().contains("glassbottles");
        }

        public IModel loadModel(ResourceLocation modelLocation) {
            return MODEL;
        }

        public void func_110549_a(IResourceManager resourceManager) {
        }
    }
}

