/*
 * Decompiled with CFR 0.152.
 */
package com.dmfmm.extrafood.client.gui;

import com.dmfmm.extrafood.client.gui.buttons.MixerReleaseButton;
import com.dmfmm.extrafood.client.gui.buttons.MixerSquareButton;
import com.dmfmm.extrafood.container.JuiceMixerContainer;
import com.dmfmm.extrafood.library.GuiLib;
import com.dmfmm.extrafood.network.ChannelHandler;
import com.dmfmm.extrafood.network.packets.PacketMakeDestroy;
import com.dmfmm.extrafood.network.packets.PacketReleaseFluid;
import com.dmfmm.extrafood.network.packets.PacketSelector;
import com.dmfmm.extrafood.tileentities.JuiceMixerTileEntity;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.translation.I18n;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class JuiceMixerGUI
extends GuiContainer {
    JuiceMixerTileEntity te;

    public JuiceMixerGUI(InventoryPlayer inventoryPlayer, JuiceMixerTileEntity tileEntity) {
        super((Container)new JuiceMixerContainer(inventoryPlayer, tileEntity));
        this.te = tileEntity;
    }

    protected void func_146284_a(GuiButton button) throws IOException {
        super.func_146284_a(button);
        switch (button.field_146127_k) {
            case 0: 
            case 1: 
            case 2: {
                JuiceMixerTileEntity.SelectedTank selectedTank = JuiceMixerTileEntity.SelectedTank.fromInt(button.field_146127_k);
                ChannelHandler.EFchannel.sendToServer((IMessage)new PacketReleaseFluid(selectedTank, this.te.func_174877_v()));
                this.te.handleClickingRelease(button.field_146127_k);
                break;
            }
            case 3: 
            case 4: {
                ChannelHandler.EFchannel.sendToServer((IMessage)new PacketMakeDestroy(button.field_146127_k - 3, this.te.func_174877_v()));
                this.te.handleMakeDestroy(button.field_146127_k - 3);
            }
        }
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.addButtons();
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        this.drawBkgd();
        this.drawFluids();
        this.drawFluidOverlay();
        this.drawSelector();
        for (int i = 0; i < this.field_146292_n.size(); ++i) {
            ((GuiButton)this.field_146292_n.get(i)).func_146112_a(this.field_146297_k, mouseX, mouseY);
        }
    }

    private void drawSelector() {
        int x = (this.field_146294_l - this.field_146999_f) / 2;
        int y = (this.field_146295_m - this.field_147000_g) / 2;
        int lx = 0;
        switch (this.te.selected) {
            case LEFT: {
                lx = 6;
                break;
            }
            case MIDDLE: {
                lx = 31;
                break;
            }
            case RIGHT: {
                lx = 56;
                break;
            }
            default: {
                lx = 6;
            }
        }
        this.field_146297_k.field_71446_o.func_110577_a(GuiLib.JMgui);
        this.func_73729_b(x + lx, y + 5, 177, 0, 20, 64);
    }

    private void drawFluidOverlay() {
        this.field_146297_k.field_71446_o.func_110577_a(GuiLib.JMgui);
        int x = (this.field_146294_l - this.field_146999_f) / 2;
        int y = (this.field_146295_m - this.field_147000_g) / 2;
        this.func_73729_b(x + 8, y + 12, 217, 0, 16, 49);
        this.func_73729_b(x + 33, y + 12, 217, 0, 16, 49);
        this.func_73729_b(x + 58, y + 12, 217, 0, 16, 49);
        this.func_73729_b(x + 101, y + 41, 199, 0, 16, 22);
    }

    private void handleTooltips(int mouseX, int mouseY) {
        int realX = mouseX - this.field_147003_i;
        int realY = mouseY - this.field_147009_r;
        if (this.func_146978_c(7, 6, 18, 62, mouseX, mouseY)) {
            FluidTank theFluidTank = this.te.input1;
            if (theFluidTank.getFluid() == null) {
                this.func_146283_a(Arrays.asList(TextFormatting.GREEN + "Empty"), realX, realY);
            } else {
                this.func_146283_a(Arrays.asList("Contents:", TextFormatting.GREEN + theFluidTank.getFluid().getFluid().getLocalizedName(theFluidTank.getFluid()) + ": " + TextFormatting.RED + theFluidTank.getFluidAmount() + TextFormatting.WHITE + "mB"), realX, realY);
            }
        } else if (this.func_146978_c(32, 6, 18, 62, mouseX, mouseY)) {
            FluidTank theFluidTank = this.te.input2;
            if (theFluidTank.getFluid() == null) {
                this.func_146283_a(Arrays.asList(TextFormatting.GREEN + "Empty"), realX, realY);
            } else {
                this.func_146283_a(Arrays.asList("Contents:", TextFormatting.GREEN + theFluidTank.getFluid().getFluid().getLocalizedName(theFluidTank.getFluid()) + ": " + TextFormatting.RED + theFluidTank.getFluidAmount() + TextFormatting.WHITE + "mB"), realX, realY);
            }
        } else if (this.func_146978_c(57, 6, 18, 62, mouseX, mouseY)) {
            FluidTank theFluidTank = this.te.input3;
            if (theFluidTank.getFluid() == null) {
                this.func_146283_a(Arrays.asList(TextFormatting.GREEN + "Empty"), realX, realY);
            } else {
                this.func_146283_a(Arrays.asList("Contents:", TextFormatting.GREEN + theFluidTank.getFluid().getFluid().getLocalizedName(theFluidTank.getFluid()) + ": " + TextFormatting.RED + theFluidTank.getFluidAmount() + TextFormatting.WHITE + "mB"), realX, realY);
            }
        } else if (this.func_146978_c(101, 37, 16, 30, mouseX, mouseY)) {
            if (this.te.outputState.size() == 0) {
                this.func_146283_a(Arrays.asList(TextFormatting.GREEN + "Empty"), realX, realY);
            } else {
                ArrayList<String> strings = new ArrayList<String>(Arrays.asList("Contents:"));
                for (FluidStack fluidStack : this.te.outputState) {
                    strings.add(TextFormatting.GREEN + fluidStack.getFluid().getLocalizedName(fluidStack) + ": " + TextFormatting.RED + fluidStack.amount + TextFormatting.WHITE + "mB");
                }
                this.func_146283_a(strings, realX, realY);
            }
        }
    }

    private void drawFluids() {
        int x = (this.field_146294_l - this.field_146999_f) / 2;
        int y = (this.field_146295_m - this.field_147000_g) / 2;
        this.drawFluid(this.te.input1, x + 8, y + 7, 16, 60);
        this.drawFluid(this.te.input2, x + 8 + 25, y + 7, 16, 60);
        this.drawFluid(this.te.input3, x + 8 + 50, y + 7, 16, 60);
        int offset = 0;
        for (FluidStack fluidStack : this.te.outputState) {
            offset += this.drawFluid(fluidStack, 6000, x + 101, y + 37, 16, 30, offset);
        }
    }

    private int drawFluid(FluidTank fluidTank, int x, int y, int w, int h) {
        if (fluidTank.getFluid() == null) {
            return -1;
        }
        TextureAtlasSprite tas = Minecraft.func_71410_x().func_147117_R().func_110572_b(fluidTank.getFluid().getFluid().getStill().toString());
        Minecraft.func_71410_x().func_110434_K().func_110577_a(TextureMap.field_110575_b);
        int height = (int)((float)h / (float)fluidTank.getCapacity() * (float)fluidTank.getFluid().amount);
        int full = height / 16;
        int semi = height % 16;
        y += h;
        for (int i = 0; i < full; ++i) {
            this.func_175175_a(x, y -= 16, tas, w, 16);
        }
        this.func_175175_a(x, y -= semi, tas, w, semi);
        return 16 * full + semi;
    }

    private int drawFluid(FluidStack fluidTank, int cap, int x, int y, int w, int h, int yOffset) {
        if (fluidTank == null) {
            return -1;
        }
        TextureAtlasSprite tas = Minecraft.func_71410_x().func_147117_R().func_110572_b(fluidTank.getFluid().getStill().toString());
        Minecraft.func_71410_x().func_110434_K().func_110577_a(TextureMap.field_110575_b);
        int height = (int)((float)h / (float)cap * (float)fluidTank.amount);
        int full = height / 16;
        int semi = height % 16;
        y += h - yOffset;
        for (int i = 0; i < full; ++i) {
            this.func_175175_a(x, y -= 16, tas, w, 16);
        }
        this.func_175175_a(x, y -= semi, tas, w, semi);
        return 16 * full + semi;
    }

    private void addButtons() {
        int x = (this.field_146294_l - this.field_146999_f) / 2;
        int y = (this.field_146295_m - this.field_147000_g) / 2;
        this.field_146292_n.add(new MixerReleaseButton(0, x + 13, y + 71));
        this.field_146292_n.add(new MixerReleaseButton(1, x + 13 + 25, y + 71));
        this.field_146292_n.add(new MixerReleaseButton(2, x + 13 + 50, y + 71));
        this.field_146292_n.add(new MixerSquareButton(3, x + 121, y + 58, I18n.func_74838_a((String)"button.make"), false));
        this.field_146292_n.add(new MixerSquareButton(4, x + 121, y + 68, I18n.func_74838_a((String)"button.delete"), true));
    }

    private void drawBkgd() {
        this.field_146297_k.field_71446_o.func_110577_a(GuiLib.JMgui);
        int x = (this.field_146294_l - this.field_146999_f) / 2;
        int y = (this.field_146295_m - this.field_147000_g) / 2;
        this.func_73729_b(x, y, 0, 0, this.field_146999_f, this.field_147000_g);
    }

    protected void func_146286_b(int mouseX, int mouseY, int state) {
        if (this.func_146978_c(7, 6, 18, 62, mouseX, mouseY)) {
            ChannelHandler.EFchannel.sendToServer((IMessage)new PacketSelector(JuiceMixerTileEntity.SelectedTank.LEFT, this.te.func_174877_v()));
            this.te.changeSelected(JuiceMixerTileEntity.SelectedTank.LEFT);
        } else if (this.func_146978_c(32, 6, 18, 62, mouseX, mouseY)) {
            ChannelHandler.EFchannel.sendToServer((IMessage)new PacketSelector(JuiceMixerTileEntity.SelectedTank.MIDDLE, this.te.func_174877_v()));
            this.te.changeSelected(JuiceMixerTileEntity.SelectedTank.MIDDLE);
        } else if (this.func_146978_c(57, 6, 18, 62, mouseX, mouseY)) {
            ChannelHandler.EFchannel.sendToServer((IMessage)new PacketSelector(JuiceMixerTileEntity.SelectedTank.RIGHT, this.te.func_174877_v()));
            this.te.changeSelected(JuiceMixerTileEntity.SelectedTank.RIGHT);
        }
        super.func_146286_b(mouseX, mouseY, state);
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        this.field_146289_q.func_78276_b(I18n.func_74838_a((String)"gui.JM"), 135, 6, 0x404040);
        this.handleTooltips(mouseX, mouseY);
    }
}

