/*
 * Decompiled with CFR 0.152.
 */
package net.shadowfacts.discordchat.repack.org.apache.http.protocol;

import java.io.IOException;
import net.shadowfacts.discordchat.repack.org.apache.http.HttpEntity;
import net.shadowfacts.discordchat.repack.org.apache.http.HttpEntityEnclosingRequest;
import net.shadowfacts.discordchat.repack.org.apache.http.HttpException;
import net.shadowfacts.discordchat.repack.org.apache.http.HttpRequest;
import net.shadowfacts.discordchat.repack.org.apache.http.HttpRequestInterceptor;
import net.shadowfacts.discordchat.repack.org.apache.http.HttpVersion;
import net.shadowfacts.discordchat.repack.org.apache.http.ProtocolVersion;
import net.shadowfacts.discordchat.repack.org.apache.http.annotation.Immutable;
import net.shadowfacts.discordchat.repack.org.apache.http.protocol.HttpContext;
import net.shadowfacts.discordchat.repack.org.apache.http.util.Args;

@Immutable
public class RequestExpectContinue
implements HttpRequestInterceptor {
    private final boolean activeByDefault;

    @Deprecated
    public RequestExpectContinue() {
        this(false);
    }

    public RequestExpectContinue(boolean activeByDefault) {
        this.activeByDefault = activeByDefault;
    }

    @Override
    public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
        Args.notNull(request, "HTTP request");
        if (!request.containsHeader("Expect") && request instanceof HttpEntityEnclosingRequest) {
            boolean active;
            ProtocolVersion ver = request.getRequestLine().getProtocolVersion();
            HttpEntity entity = ((HttpEntityEnclosingRequest)request).getEntity();
            if (entity != null && entity.getContentLength() != 0L && !ver.lessEquals(HttpVersion.HTTP_1_0) && (active = request.getParams().getBooleanParameter("http.protocol.expect-continue", this.activeByDefault))) {
                request.addHeader("Expect", "100-continue");
            }
        }
    }
}

