/*
 * Decompiled with CFR 0.152.
 */
package net.shadowfacts.discordchat.repack.org.apache.http.nio.protocol;

import java.io.IOException;
import net.shadowfacts.discordchat.repack.org.apache.http.ContentTooLongException;
import net.shadowfacts.discordchat.repack.org.apache.http.HttpEntity;
import net.shadowfacts.discordchat.repack.org.apache.http.HttpResponse;
import net.shadowfacts.discordchat.repack.org.apache.http.entity.ContentType;
import net.shadowfacts.discordchat.repack.org.apache.http.nio.ContentDecoder;
import net.shadowfacts.discordchat.repack.org.apache.http.nio.IOControl;
import net.shadowfacts.discordchat.repack.org.apache.http.nio.entity.ContentBufferEntity;
import net.shadowfacts.discordchat.repack.org.apache.http.nio.protocol.AbstractAsyncResponseConsumer;
import net.shadowfacts.discordchat.repack.org.apache.http.nio.util.HeapByteBufferAllocator;
import net.shadowfacts.discordchat.repack.org.apache.http.nio.util.SimpleInputBuffer;
import net.shadowfacts.discordchat.repack.org.apache.http.protocol.HttpContext;
import net.shadowfacts.discordchat.repack.org.apache.http.util.Asserts;

public class BasicAsyncResponseConsumer
extends AbstractAsyncResponseConsumer<HttpResponse> {
    private volatile HttpResponse response;
    private volatile SimpleInputBuffer buf;

    @Override
    protected void onResponseReceived(HttpResponse response) throws IOException {
        this.response = response;
    }

    @Override
    protected void onEntityEnclosed(HttpEntity entity, ContentType contentType) throws IOException {
        long len = entity.getContentLength();
        if (len > Integer.MAX_VALUE) {
            throw new ContentTooLongException("Entity content is too long: " + len);
        }
        if (len < 0L) {
            len = 4096L;
        }
        this.buf = new SimpleInputBuffer((int)len, new HeapByteBufferAllocator());
        this.response.setEntity(new ContentBufferEntity(entity, this.buf));
    }

    @Override
    protected void onContentReceived(ContentDecoder decoder, IOControl ioctrl) throws IOException {
        Asserts.notNull(this.buf, "Content buffer");
        this.buf.consumeContent(decoder);
    }

    @Override
    protected void releaseResources() {
        this.response = null;
        this.buf = null;
    }

    @Override
    protected HttpResponse buildResult(HttpContext context) {
        return this.response;
    }
}

