/*
 * Decompiled with CFR 0.152.
 */
package net.shadowfacts.discordchat.repack.org.apache.http.client.protocol;

import java.io.IOException;
import java.util.Collection;
import net.shadowfacts.discordchat.repack.org.apache.http.Header;
import net.shadowfacts.discordchat.repack.org.apache.http.HttpException;
import net.shadowfacts.discordchat.repack.org.apache.http.HttpRequest;
import net.shadowfacts.discordchat.repack.org.apache.http.HttpRequestInterceptor;
import net.shadowfacts.discordchat.repack.org.apache.http.annotation.Immutable;
import net.shadowfacts.discordchat.repack.org.apache.http.protocol.HttpContext;
import net.shadowfacts.discordchat.repack.org.apache.http.util.Args;

@Immutable
public class RequestDefaultHeaders
implements HttpRequestInterceptor {
    private final Collection<? extends Header> defaultHeaders;

    public RequestDefaultHeaders(Collection<? extends Header> defaultHeaders) {
        this.defaultHeaders = defaultHeaders;
    }

    public RequestDefaultHeaders() {
        this(null);
    }

    @Override
    public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
        Args.notNull(request, "HTTP request");
        String method = request.getRequestLine().getMethod();
        if (method.equalsIgnoreCase("CONNECT")) {
            return;
        }
        Collection<? extends Header> defHeaders = (Collection<? extends Header>)request.getParams().getParameter("http.default-headers");
        if (defHeaders == null) {
            defHeaders = this.defaultHeaders;
        }
        if (defHeaders != null) {
            for (Header header : defHeaders) {
                request.addHeader(header);
            }
        }
    }
}

