/*
 * Decompiled with CFR 0.152.
 */
package net.shadowfacts.discordchat.repack.org.apache.http.client.methods;

import java.net.URI;
import net.shadowfacts.discordchat.repack.org.apache.http.ProtocolVersion;
import net.shadowfacts.discordchat.repack.org.apache.http.RequestLine;
import net.shadowfacts.discordchat.repack.org.apache.http.annotation.NotThreadSafe;
import net.shadowfacts.discordchat.repack.org.apache.http.client.config.RequestConfig;
import net.shadowfacts.discordchat.repack.org.apache.http.client.methods.AbstractExecutionAwareRequest;
import net.shadowfacts.discordchat.repack.org.apache.http.client.methods.Configurable;
import net.shadowfacts.discordchat.repack.org.apache.http.client.methods.HttpUriRequest;
import net.shadowfacts.discordchat.repack.org.apache.http.message.BasicRequestLine;
import net.shadowfacts.discordchat.repack.org.apache.http.params.HttpProtocolParams;

@NotThreadSafe
public abstract class HttpRequestBase
extends AbstractExecutionAwareRequest
implements HttpUriRequest,
Configurable {
    private ProtocolVersion version;
    private URI uri;
    private RequestConfig config;

    @Override
    public abstract String getMethod();

    public void setProtocolVersion(ProtocolVersion version) {
        this.version = version;
    }

    @Override
    public ProtocolVersion getProtocolVersion() {
        return this.version != null ? this.version : HttpProtocolParams.getVersion(this.getParams());
    }

    @Override
    public URI getURI() {
        return this.uri;
    }

    @Override
    public RequestLine getRequestLine() {
        String method = this.getMethod();
        ProtocolVersion ver = this.getProtocolVersion();
        URI uriCopy = this.getURI();
        String uritext = null;
        if (uriCopy != null) {
            uritext = uriCopy.toASCIIString();
        }
        if (uritext == null || uritext.isEmpty()) {
            uritext = "/";
        }
        return new BasicRequestLine(method, uritext, ver);
    }

    @Override
    public RequestConfig getConfig() {
        return this.config;
    }

    public void setConfig(RequestConfig config) {
        this.config = config;
    }

    public void setURI(URI uri) {
        this.uri = uri;
    }

    public void started() {
    }

    public void releaseConnection() {
        this.reset();
    }

    public String toString() {
        return this.getMethod() + " " + this.getURI() + " " + this.getProtocolVersion();
    }
}

