/*
 * Decompiled with CFR 0.152.
 */
package net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.utils;

import java.util.List;
import java.util.Map;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.Permission;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.entities.Channel;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.entities.Emote;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.entities.Guild;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.entities.Member;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.entities.MessageChannel;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.entities.PermissionOverride;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.entities.Role;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.entities.TextChannel;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.entities.User;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.entities.impl.GuildImpl;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.entities.impl.PermissionOverrideImpl;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.entities.impl.TextChannelImpl;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.entities.impl.VoiceChannelImpl;
import net.shadowfacts.discordchat.repack.org.apache.commons.collections4.CollectionUtils;

public class PermissionUtil {
    public static boolean canInteract(Member issuer, Member target) {
        PermissionUtil.checkNull(issuer, "issuer member");
        PermissionUtil.checkNull(target, "target member");
        Guild guild = issuer.getGuild();
        if (!guild.equals(target.getGuild())) {
            throw new IllegalArgumentException("Provided members must both be Member objects of the same Guild!");
        }
        if (guild.getOwner().equals(issuer)) {
            return true;
        }
        if (guild.getOwner().equals(target)) {
            return false;
        }
        List<Role> issuerRoles = issuer.getRoles();
        List<Role> targetRoles = target.getRoles();
        return !issuerRoles.isEmpty() && (targetRoles.isEmpty() || PermissionUtil.canInteract(issuerRoles.get(0), targetRoles.get(0)));
    }

    public static boolean canInteract(Member issuer, Role target) {
        PermissionUtil.checkNull(issuer, "issuer member");
        PermissionUtil.checkNull(target, "target role");
        Guild guild = issuer.getGuild();
        if (!guild.equals(target.getGuild())) {
            throw new IllegalArgumentException("Provided Member issuer and Role target must be from the same Guild!");
        }
        if (guild.getOwner().equals(issuer)) {
            return true;
        }
        List<Role> issuerRoles = issuer.getRoles();
        return !issuerRoles.isEmpty() && PermissionUtil.canInteract(issuerRoles.get(0), target);
    }

    public static boolean canInteract(Role issuer, Role target) {
        PermissionUtil.checkNull(issuer, "issuer role");
        PermissionUtil.checkNull(target, "target role");
        if (!issuer.getGuild().equals(target.getGuild())) {
            throw new IllegalArgumentException("The 2 Roles are not from same Guild!");
        }
        return target.getPosition() < issuer.getPosition();
    }

    public static boolean canInteract(Member issuer, Emote emote) {
        PermissionUtil.checkNull(issuer, "issuer member");
        PermissionUtil.checkNull(emote, "target emote");
        if (!issuer.getGuild().equals(emote.getGuild())) {
            throw new IllegalArgumentException("The issuer and target are not in the same Guild");
        }
        return !emote.isFake() && (emote.getRoles().isEmpty() || CollectionUtils.containsAny(issuer.getRoles(), emote.getRoles()));
    }

    public static boolean canInteract(User issuer, Emote emote, MessageChannel channel) {
        PermissionUtil.checkNull(issuer, "issuer member");
        PermissionUtil.checkNull(emote, "target emote");
        PermissionUtil.checkNull(channel, "target channel");
        if (emote.isFake() || !emote.getGuild().isMember(issuer)) {
            return false;
        }
        Member member = emote.getGuild().getMemberById(issuer.getId());
        if (!PermissionUtil.canInteract(member, emote)) {
            return false;
        }
        switch (channel.getType()) {
            case TEXT: {
                TextChannel text = (TextChannel)channel;
                member = text.getGuild().getMemberById(issuer.getId());
                return emote.getGuild().equals(text.getGuild()) || emote.isManaged() && PermissionUtil.checkPermission(text, member, Permission.MESSAGE_EXT_EMOJI);
            }
        }
        return emote.isManaged();
    }

    public static PermissionOverride getFullPermOverride() {
        PermissionOverrideImpl override = new PermissionOverrideImpl(null, null, null);
        long allow = 0L;
        long deny = 0L;
        for (Permission permission : Permission.values()) {
            if (permission == Permission.UNKNOWN) continue;
            allow |= (long)(1 << permission.getOffset());
        }
        return override.setAllow(allow).setDeny(deny);
    }

    public static boolean checkPermission(Guild guild, Member member, Permission ... permissions) {
        PermissionUtil.checkNull(guild, "guild");
        PermissionUtil.checkNull(member, "member");
        PermissionUtil.checkNull(permissions, "permissions");
        if (!guild.equals(member.getGuild())) {
            throw new IllegalArgumentException("Provided member is not in the provided guild");
        }
        List<Role> roles = member.getRoles();
        if (guild.getOwner().equals(member) || guild.getPublicRole().hasPermission(Permission.ADMINISTRATOR) || roles.stream().anyMatch(role -> role.hasPermission(Permission.ADMINISTRATOR))) {
            return true;
        }
        for (Permission perm : permissions) {
            if (guild.getPublicRole().hasPermission(perm) || roles.parallelStream().anyMatch(role -> role.hasPermission(perm))) continue;
            return false;
        }
        return true;
    }

    public static boolean checkPermission(Channel channel, Member member, Permission ... permissions) {
        PermissionUtil.checkNull(channel, "channel");
        PermissionUtil.checkNull(member, "member");
        PermissionUtil.checkNull(permissions, "permissions");
        GuildImpl guild = (GuildImpl)channel.getGuild();
        if (!guild.equals(member.getGuild())) {
            throw new IllegalArgumentException("Provided channel and member are not from the same guild!");
        }
        if (guild.getOwner().equals(member) || guild.getPublicRole().hasPermission(Permission.ADMINISTRATOR) || member.getRoles().stream().anyMatch(role -> role.hasPermission(Permission.ADMINISTRATOR))) {
            return true;
        }
        if (channel instanceof TextChannel) {
            for (Permission perm : permissions) {
                if (PermissionUtil.checkPermission(member, perm, (GuildImpl)channel.getGuild(), ((TextChannelImpl)channel).getRoleOverrideMap(), ((TextChannelImpl)channel).getMemberOverrideMap())) continue;
                return false;
            }
        } else {
            for (Permission perm : permissions) {
                if (PermissionUtil.checkPermission(member, perm, (GuildImpl)channel.getGuild(), ((VoiceChannelImpl)channel).getRoleOverrideMap(), ((VoiceChannelImpl)channel).getMemberOverrideMap())) continue;
                return false;
            }
        }
        return true;
    }

    public static long getEffectivePermission(Guild guild, Member member) {
        PermissionUtil.checkNull(guild, "guild");
        PermissionUtil.checkNull(member, "member");
        if (!member.getGuild().equals(guild)) {
            throw new IllegalArgumentException("Provided member is not in the provided guild!");
        }
        long permission = guild.getPublicRole().getPermissionsRaw();
        for (Role role : member.getRoles()) {
            permission |= role.getPermissionsRaw();
        }
        return permission;
    }

    public static long getEffectivePermission(Channel channel, Member member) {
        PermissionUtil.checkNull(channel, "channel");
        PermissionUtil.checkNull(member, "member");
        if (!channel.getGuild().equals(member.getGuild())) {
            throw new IllegalArgumentException("Provided channel and provided member are not of the same guild!");
        }
        if (channel instanceof TextChannel) {
            return PermissionUtil.getEffectivePermission(member, (GuildImpl)channel.getGuild(), ((TextChannelImpl)channel).getRoleOverrideMap(), ((TextChannelImpl)channel).getMemberOverrideMap());
        }
        return PermissionUtil.getEffectivePermission(member, (GuildImpl)channel.getGuild(), ((VoiceChannelImpl)channel).getRoleOverrideMap(), ((VoiceChannelImpl)channel).getMemberOverrideMap());
    }

    public static long getEffectivePermission(Channel channel, Role role) {
        PermissionUtil.checkNull(channel, "channel");
        PermissionUtil.checkNull(role, "role");
        Guild guild = channel.getGuild();
        if (!guild.equals(role.getGuild())) {
            throw new IllegalArgumentException("Provided channel and role are not of the same guild!");
        }
        long permissions = guild.getPublicRole().getPermissionsRaw() | role.getPermissionsRaw();
        PermissionOverride publicOverride = channel.getOverrideForRole(guild.getPublicRole());
        PermissionOverride roleOverride = channel.getOverrideForRole(role);
        if (publicOverride != null) {
            permissions &= publicOverride.getDeniedRaw() ^ 0xFFFFFFFFFFFFFFFFL;
            permissions |= publicOverride.getAllowedRaw();
        }
        if (roleOverride != null) {
            permissions &= roleOverride.getDeniedRaw() ^ 0xFFFFFFFFFFFFFFFFL;
            permissions |= roleOverride.getAllowedRaw();
        }
        return permissions;
    }

    private static boolean checkPermission(Member member, Permission perm, GuildImpl guild, Map<Role, PermissionOverride> roleOverrides, Map<Member, PermissionOverride> memberOverrides) {
        if (guild.getOwner().equals(member)) {
            return true;
        }
        long effectivePerms = PermissionUtil.getEffectivePermission(member, guild, roleOverrides, memberOverrides);
        return (effectivePerms & (long)(1 << Permission.ADMINISTRATOR.getOffset()) | effectivePerms & (long)(1 << perm.getOffset())) > 0L;
    }

    private static long getEffectivePermission(Member member, GuildImpl guild, Map<Role, PermissionOverride> roleOverrides, Map<Member, PermissionOverride> memberOverrides) {
        PermissionOverride memberOverride;
        long permission = PermissionUtil.getEffectivePermission(guild, member);
        PermissionOverride override = roleOverrides.get(guild.getPublicRole());
        if (override != null) {
            permission = PermissionUtil.apply(permission, override.getAllowedRaw(), override.getDeniedRaw());
        }
        long allow = -1L;
        long deny = -1L;
        for (Role role : member.getRoles()) {
            PermissionOverride po = roleOverrides.get(role);
            if (po == null) continue;
            if (allow == -1L || deny == -1L) {
                allow = po.getAllowedRaw();
                deny = po.getDeniedRaw();
                continue;
            }
            allow = po.getAllowedRaw() | allow;
            deny = (po.getDeniedRaw() | deny) & (allow ^ 0xFFFFFFFFFFFFFFFFL);
        }
        if (allow != -1L && deny != -1L) {
            permission = PermissionUtil.apply(permission, allow, deny);
        }
        if ((memberOverride = memberOverrides.get(member)) != null) {
            permission = PermissionUtil.apply(permission, memberOverride.getAllowedRaw(), memberOverride.getDeniedRaw());
        }
        return permission;
    }

    private static long apply(long permission, long allow, long deny) {
        permission |= allow;
        return permission &= deny ^ 0xFFFFFFFFFFFFFFFFL;
    }

    private static void checkNull(Object obj, String name) {
        if (obj == null) {
            throw new NullPointerException("Provided " + name + " was null!");
        }
    }
}

