/*
 * Decompiled with CFR 0.152.
 */
package net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.utils;

import java.lang.reflect.Method;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Calendar;
import java.util.TimeZone;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.entities.impl.JDAImpl;

public class MiscUtil {
    private static final DateTimeFormatter dtFormatter = DateTimeFormatter.RFC_1123_DATE_TIME;

    public static OffsetDateTime getCreationTime(String entityId) {
        try {
            long timestamp = (Long.parseLong(entityId) >> 22) + 1420070400000L;
            Calendar gmt = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
            gmt.setTimeInMillis(timestamp);
            return OffsetDateTime.ofInstant(gmt.toInstant(), gmt.getTimeZone().toZoneId());
        }
        catch (NumberFormatException ex) {
            return null;
        }
    }

    public static OffsetDateTime getCreationTime(Object entity) {
        try {
            Method idMethod = entity.getClass().getMethod("getId", new Class[0]);
            if (idMethod.getReturnType() != String.class) {
                JDAImpl.LOG.warn("Tried to look up creation-time for entity of class " + entity.getClass().getName() + " which doesn't have the correct id getter");
                return null;
            }
            String objId = (String)idMethod.invoke(entity, new Object[0]);
            return MiscUtil.getCreationTime(objId);
        }
        catch (Exception e) {
            JDAImpl.LOG.warn("Tried to look up creation-time for entity of class " + entity.getClass().getName() + " which doesn't have the correct id getter");
            return null;
        }
    }

    public static String getDateTimeString(OffsetDateTime time) {
        return time.format(dtFormatter);
    }
}

