/*
 * Decompiled with CFR 0.152.
 */
package net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.requests.ratelimit;

import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Iterator;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.RejectedExecutionException;
import net.shadowfacts.discordchat.repack.com.mashape.unirest.http.Headers;
import net.shadowfacts.discordchat.repack.com.mashape.unirest.http.HttpResponse;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.requests.RateLimiter;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.requests.Request;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.requests.Requester;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.requests.Route;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.requests.ratelimit.IBucket;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.utils.SimpleLog;
import net.shadowfacts.discordchat.repack.org.json.JSONObject;

public class BotRateLimiter
extends RateLimiter {
    volatile Long timeOffset = null;
    volatile Long globalCooldown = null;

    public BotRateLimiter(Requester requester, int poolSize) {
        super(requester, poolSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long getRateLimit(Route.CompiledRoute route) {
        Bucket bucket;
        Bucket bucket2 = bucket = this.getBucket(route.getRatelimitRoute());
        synchronized (bucket2) {
            if (this.globalCooldown != null) {
                long now = this.getNow();
                if (now > this.globalCooldown) {
                    this.globalCooldown = null;
                } else {
                    return this.globalCooldown - now;
                }
            }
            if (bucket.routeUsageRemaining <= 0 && this.getNow() > bucket.resetTime) {
                bucket.routeUsageRemaining = bucket.routeUsageLimit;
                bucket.resetTime = 0L;
            }
            if (bucket.routeUsageRemaining > 0) {
                return null;
            }
            return bucket.resetTime - this.getNow();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void queueRequest(Request request) {
        Bucket bucket;
        if (this.isShutdown) {
            throw new RejectedExecutionException("Cannot queue a request after shutdown");
        }
        Bucket bucket2 = bucket = this.getBucket(request.getRoute().getRatelimitRoute());
        synchronized (bucket2) {
            bucket.addToQueue(request);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Long handleResponse(Route.CompiledRoute route, HttpResponse<String> response) {
        Bucket bucket;
        Bucket bucket2 = bucket = this.getBucket(route.getRatelimitRoute());
        synchronized (bucket2) {
            Headers headers = response.getHeaders();
            int code = response.getStatus();
            if (this.timeOffset == null) {
                this.setTimeOffset(headers);
            }
            if (code == 429) {
                String global = headers.getFirst("x-ratelimit-global");
                String retry = headers.getFirst("retry-after");
                if (retry == null || retry.isEmpty()) {
                    JSONObject limitObj = new JSONObject(response.getBody());
                    retry = limitObj.get("retry_after").toString();
                }
                long retryAfter = Long.parseLong(retry);
                if (!Boolean.parseBoolean(global)) {
                    this.updateBucket(bucket, headers);
                } else {
                    this.globalCooldown = this.getNow() + retryAfter;
                }
                return retryAfter;
            }
            this.updateBucket(bucket, headers);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Bucket getBucket(String route) {
        Bucket bucket = (Bucket)this.buckets.get(route);
        if (bucket == null) {
            ConcurrentHashMap concurrentHashMap = this.buckets;
            synchronized (concurrentHashMap) {
                bucket = (Bucket)this.buckets.get(route);
                if (bucket == null) {
                    bucket = new Bucket(route);
                    this.buckets.put(route, bucket);
                }
            }
        }
        return bucket;
    }

    public long getNow() {
        return System.currentTimeMillis() + this.getTimeOffset();
    }

    public long getTimeOffset() {
        return this.timeOffset == null ? 0L : this.timeOffset;
    }

    private void setTimeOffset(Headers headers) {
        String date;
        long time = System.currentTimeMillis();
        if (this.timeOffset == null && (date = headers.getFirst("date")) != null) {
            OffsetDateTime tDate = OffsetDateTime.parse(date, DateTimeFormatter.RFC_1123_DATE_TIME);
            long lDate = tDate.toEpochSecond() * 1000L;
            this.timeOffset = Math.floorDiv(lDate - time, 1000L) * 1000L;
        }
    }

    private void updateBucket(Bucket bucket, Headers headers) {
        block2: {
            try {
                bucket.resetTime = Long.parseLong(headers.getFirst("x-ratelimit-reset")) * 1000L;
                bucket.routeUsageLimit = Integer.parseInt(headers.getFirst("x-ratelimit-limit"));
                bucket.routeUsageRemaining = Integer.parseInt(headers.getFirst("x-ratelimit-remaining"));
            }
            catch (NumberFormatException ex) {
                if (bucket.getRoute().equals("gateway") || bucket.getRoute().equals("users/@me") || Requester.LOG.getEffectiveLevel().getPriority() > SimpleLog.Level.DEBUG.getPriority()) break block2;
                Requester.LOG.log(ex);
            }
        }
    }

    private class Bucket
    implements IBucket,
    Runnable {
        final String route;
        volatile long resetTime = 0L;
        volatile int routeUsageRemaining = 1;
        volatile int routeUsageLimit = 1;
        volatile ConcurrentLinkedQueue<Request> requests = new ConcurrentLinkedQueue();

        public Bucket(String route) {
            this.route = route;
        }

        void addToQueue(Request request) {
            this.requests.add(request);
            this.submitForProcessing();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void submitForProcessing() {
            ConcurrentLinkedQueue concurrentLinkedQueue = BotRateLimiter.this.submittedBuckets;
            synchronized (concurrentLinkedQueue) {
                if (!BotRateLimiter.this.submittedBuckets.contains(this)) {
                    BotRateLimiter.this.pool.submit(this);
                    BotRateLimiter.this.submittedBuckets.add(this);
                }
            }
        }

        public boolean equals(Object o) {
            if (!(o instanceof Bucket)) {
                return false;
            }
            Bucket oBucket = (Bucket)o;
            return this.route.equals(((Bucket)o).route);
        }

        public int hashCode() {
            return this.route.hashCode();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                ConcurrentLinkedQueue<Request> concurrentLinkedQueue = this.requests;
                synchronized (concurrentLinkedQueue) {
                    Iterator<Request> it = this.requests.iterator();
                    while (it.hasNext()) {
                        Request request = null;
                        try {
                            request = it.next();
                            Long retryAfter = BotRateLimiter.this.requester.execute(request);
                            if (retryAfter != null) break;
                            it.remove();
                        }
                        catch (Throwable t) {
                            Requester.LOG.fatal("Requester system encountered an internal error");
                            Requester.LOG.log(t);
                            it.remove();
                            if (request == null) continue;
                            request.onFailure(t);
                        }
                    }
                    ConcurrentLinkedQueue concurrentLinkedQueue2 = BotRateLimiter.this.submittedBuckets;
                    synchronized (concurrentLinkedQueue2) {
                        BotRateLimiter.this.submittedBuckets.remove(this);
                        if (!this.requests.isEmpty()) {
                            try {
                                this.submitForProcessing();
                            }
                            catch (RejectedExecutionException e) {
                                Requester.LOG.debug("Caught RejectedExecutionException when re-queuing a ratelimited request. The requester is probably shutdown, thus, this can be ignored.");
                            }
                        }
                    }
                }
            }
            catch (Throwable err) {
                Requester.LOG.fatal("Requester system encountered an internal error from beyond the sychronized execution blocks. NOT GOOD!");
                Requester.LOG.log(err);
            }
        }

        @Override
        public String getRoute() {
            return this.route;
        }

        @Override
        public Queue<Request> getRequests() {
            return this.requests;
        }
    }
}

